/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.OutputValidator;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.general.DSAOutputVerifier;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.io.DigestOutputStream;

class DSAOutputValidator<T extends Parameters>
implements OutputValidator<T> {
    private final DSA dsa;
    private final Digest digest;
    private final T parameter;
    private final boolean reverse;
    private final BigInteger[] rs;

    DSAOutputValidator(DSA dSA, Digest digest, T t2, byte[] byArray) throws InvalidSignatureException {
        this(dSA, digest, t2, byArray, false);
    }

    DSAOutputValidator(DSA dSA, Digest digest, T t2, byte[] byArray, boolean bl) throws InvalidSignatureException {
        this.dsa = dSA;
        this.digest = digest;
        this.parameter = t2;
        this.reverse = bl;
        try {
            this.rs = DSAOutputVerifier.decode(dSA, byArray, bl);
        }
        catch (IOException iOException) {
            throw new InvalidSignatureException("Unable to process signature: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public UpdateOutputStream getValidatingStream() {
        return new DigestOutputStream(this.digest);
    }

    @Override
    public boolean isValidated() {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        return this.dsa.verifySignature(byArray, this.rs[0], this.rs[1]);
    }
}

