/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.io.IOException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.notifications.model.Attachment;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u00c6\u0003J+\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J\u001c\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006%"}, d2={"Lorg/opensearch/commons/notifications/model/ChannelMessage;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "textDescription", "", "htmlDescription", "attachment", "Lorg/opensearch/commons/notifications/model/Attachment;", "(Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/commons/notifications/model/Attachment;)V", "getAttachment", "()Lorg/opensearch/commons/notifications/model/Attachment;", "getHtmlDescription", "()Ljava/lang/String;", "getTextDescription", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "output", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
@SourceDebugExtension(value={"SMAP\nChannelMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelMessage.kt\norg/opensearch/commons/notifications/model/ChannelMessage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class ChannelMessage
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String textDescription;
    @Nullable
    private final String htmlDescription;
    @Nullable
    private final Attachment attachment;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(ChannelMessage.class);
    @NotNull
    private static final Writeable.Reader<ChannelMessage> reader = ChannelMessage::reader$lambda$1;

    public ChannelMessage(@NotNull String textDescription, @Nullable String htmlDescription, @Nullable Attachment attachment) {
        Intrinsics.checkNotNullParameter(textDescription, "textDescription");
        this.textDescription = textDescription;
        this.htmlDescription = htmlDescription;
        this.attachment = attachment;
        if (!(!Strings.isNullOrEmpty((String)this.textDescription))) {
            boolean bl = false;
            String string = "text message part is null or empty";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getTextDescription() {
        return this.textDescription;
    }

    @Nullable
    public final String getHtmlDescription() {
        return this.htmlDescription;
    }

    @Nullable
    public final Attachment getAttachment() {
        return this.attachment;
    }

    public ChannelMessage(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter(input, "input");
        String string = input.readString();
        Intrinsics.checkNotNullExpressionValue(string, "readString(...)");
        this(string, input.readOptionalString(), (Attachment)input.readOptionalWriteable(Attachment.Companion.getReader()));
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter(output, "output");
        output.writeString(this.textDescription);
        output.writeOptionalString(this.htmlDescription);
        output.writeOptionalWriteable((Writeable)this.attachment);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull(builder);
        XContentBuilder xContentBuilder = builder.startObject().field("text_description", this.textDescription);
        Intrinsics.checkNotNullExpressionValue(xContentBuilder, "field(...)");
        XContentBuilder xContentBuilder2 = XContentHelpersKt.fieldIfNotNull(XContentHelpersKt.fieldIfNotNull(xContentBuilder, "html_description", this.htmlDescription), "attachment", this.attachment).endObject();
        Intrinsics.checkNotNullExpressionValue(xContentBuilder2, "endObject(...)");
        return xContentBuilder2;
    }

    @NotNull
    public final String component1() {
        return this.textDescription;
    }

    @Nullable
    public final String component2() {
        return this.htmlDescription;
    }

    @Nullable
    public final Attachment component3() {
        return this.attachment;
    }

    @NotNull
    public final ChannelMessage copy(@NotNull String textDescription, @Nullable String htmlDescription, @Nullable Attachment attachment) {
        Intrinsics.checkNotNullParameter(textDescription, "textDescription");
        return new ChannelMessage(textDescription, htmlDescription, attachment);
    }

    public static /* synthetic */ ChannelMessage copy$default(ChannelMessage channelMessage, String string, String string2, Attachment attachment, int n, Object object) {
        if ((n & 1) != 0) {
            string = channelMessage.textDescription;
        }
        if ((n & 2) != 0) {
            string2 = channelMessage.htmlDescription;
        }
        if ((n & 4) != 0) {
            attachment = channelMessage.attachment;
        }
        return channelMessage.copy(string, string2, attachment);
    }

    @NotNull
    public String toString() {
        return "ChannelMessage(textDescription=" + this.textDescription + ", htmlDescription=" + this.htmlDescription + ", attachment=" + this.attachment + ")";
    }

    public int hashCode() {
        int result2 = this.textDescription.hashCode();
        result2 = result2 * 31 + (this.htmlDescription == null ? 0 : this.htmlDescription.hashCode());
        result2 = result2 * 31 + (this.attachment == null ? 0 : this.attachment.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChannelMessage)) {
            return false;
        }
        ChannelMessage channelMessage = (ChannelMessage)other;
        if (!Intrinsics.areEqual(this.textDescription, channelMessage.textDescription)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.htmlDescription, channelMessage.htmlDescription)) {
            return false;
        }
        return Intrinsics.areEqual(this.attachment, channelMessage.attachment);
    }

    private static final ChannelMessage reader$lambda$1(StreamInput it) {
        Intrinsics.checkNotNull(it);
        return new ChannelMessage(it);
    }

    @JvmStatic
    @NotNull
    public static final ChannelMessage parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/commons/notifications/model/ChannelMessage$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/ChannelMessage;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<ChannelMessage> getReader() {
            return reader;
        }

        @JvmStatic
        @NotNull
        public final ChannelMessage parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter(parser, "parser");
            String textDescription = null;
            String htmlDescription = null;
            Attachment attachment = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block15: {
                    fieldName = parser.currentName();
                    parser.nextToken();
                    String string = fieldName;
                    if (string == null) break block15;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1963501277: {
                            if (string.equals("attachment")) {
                                n = 1;
                            }
                            break;
                        }
                        case 287362026: {
                            if (string.equals("text_description")) {
                                n = 2;
                            }
                            break;
                        }
                        case -1719287448: {
                            if (string.equals("html_description")) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            textDescription = parser.text();
                            continue block10;
                        }
                        case 3: {
                            htmlDescription = parser.textOrNull();
                            continue block10;
                        }
                        case 1: {
                            attachment = Attachment.Companion.parse(parser);
                            continue block10;
                        }
                    }
                }
                parser.skipChildren();
                this.getLog().info("Skipping Unknown field " + fieldName);
            }
            if (textDescription == null) {
                throw new IllegalArgumentException("text_description not present");
            }
            return new ChannelMessage(textDescription, htmlDescription, attachment);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

