/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex.remote;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.lucene.search.TotalHits;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.collect.Tuple;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ContextParser;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.reindex.ScrollableHitSource;
import org.opensearch.search.SearchHits;

final class RemoteResponseParsers {
    public static final ConstructingObjectParser<ScrollableHitSource.BasicHit, MediaType> HIT_PARSER;
    public static final ConstructingObjectParser<Object[], MediaType> HITS_PARSER;
    public static final ConstructingObjectParser<ScrollableHitSource.SearchFailure, Void> SEARCH_FAILURE_PARSER;
    public static final ConstructingObjectParser<List<Throwable>, Void> SHARDS_PARSER;
    public static final ConstructingObjectParser<ScrollableHitSource.Response, MediaType> RESPONSE_PARSER;
    public static final ConstructingObjectParser<Version, MediaType> MAIN_ACTION_PARSER;

    private RemoteResponseParsers() {
    }

    static {
        class Fields {
            String routing;

            Fields() {
            }
        }
        HIT_PARSER = new ConstructingObjectParser("hit", true, a -> {
            Long version;
            int i = 0;
            String index = (String)a[i++];
            String id = (String)a[i++];
            return new ScrollableHitSource.BasicHit(index, id, (version = (Long)a[i++]) == null ? -1L : version);
        });
        HIT_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("_index", new String[0]));
        HIT_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("_id", new String[0]));
        HIT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField("_version", new String[0]));
        HIT_PARSER.declareObject((basicHit, tuple) -> basicHit.setSource((BytesReference)tuple.v1(), (MediaType)tuple.v2()), (p, s2) -> {
            Tuple tuple;
            block8: {
                XContentBuilder b = XContentBuilder.builder((XContent)s2.xContent());
                try {
                    b.copyCurrentStructure(p);
                    tuple = new Tuple((Object)BytesReference.bytes((XContentBuilder)b), s2);
                    if (b == null) break block8;
                }
                catch (Throwable t$) {
                    try {
                        if (b != null) {
                            try {
                                b.close();
                            }
                            catch (Throwable x2) {
                                t$.addSuppressed(x2);
                            }
                        }
                        throw t$;
                    }
                    catch (IOException e) {
                        throw new ParsingException(p.getTokenLocation(), "[hit] failed to parse [_source]", (Throwable)e, new Object[0]);
                    }
                }
                b.close();
            }
            return tuple;
        }, new ParseField("_source", new String[0]));
        ParseField routingField = new ParseField("_routing", new String[0]);
        ParseField ttlField = new ParseField("_ttl", new String[0]);
        ParseField parentField = new ParseField("_parent", new String[0]);
        HIT_PARSER.declareString(ScrollableHitSource.BasicHit::setRouting, routingField);
        ObjectParser fieldsParser = new ObjectParser("fields", () -> new Fields());
        HIT_PARSER.declareObject((hit, fields2) -> hit.setRouting(fields2.routing), (ContextParser)fieldsParser, new ParseField("fields", new String[0]));
        fieldsParser.declareString((fields2, routing) -> {
            fields2.routing = routing;
        }, routingField);
        fieldsParser.declareLong((fields2, ttl) -> {}, ttlField);
        fieldsParser.declareString((fields2, parent) -> {}, parentField);
        HITS_PARSER = new ConstructingObjectParser("hits", true, a -> a);
        HITS_PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.START_OBJECT) {
                TotalHits totalHits = SearchHits.parseTotalHitsFragment((XContentParser)p);
                assert (totalHits.relation() == TotalHits.Relation.EQUAL_TO);
                return totalHits.value();
            }
            return p.longValue();
        }, new ParseField("total", new String[0]), ObjectParser.ValueType.OBJECT_OR_LONG);
        HITS_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), HIT_PARSER, new ParseField("hits", new String[0]));
        SEARCH_FAILURE_PARSER = new ConstructingObjectParser("failure", true, a -> {
            Object reason;
            int i = 0;
            String index = (String)a[i++];
            Integer shardId = (Integer)a[i++];
            String nodeId = (String)a[i++];
            Throwable reasonThrowable = (reason = a[i++]) instanceof String ? new RuntimeException("Unknown remote exception with reason=[" + (String)reason + "]") : (Throwable)reason;
            return new ScrollableHitSource.SearchFailure(reasonThrowable, index, shardId, nodeId);
        });
        SEARCH_FAILURE_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("index", new String[0]));
        SEARCH_FAILURE_PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("shard", new String[0]));
        SEARCH_FAILURE_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("node", new String[0]));
        SEARCH_FAILURE_PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.START_OBJECT) {
                return ThrowableBuilder.PARSER.apply(p, null);
            }
            return p.text();
        }, new ParseField("reason", new String[0]), ObjectParser.ValueType.OBJECT_OR_STRING);
        SHARDS_PARSER = new ConstructingObjectParser("_shards", true, a -> {
            List failures = (List)a[0];
            failures = failures == null ? Collections.emptyList() : failures;
            return failures;
        });
        SHARDS_PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), SEARCH_FAILURE_PARSER, new ParseField("failures", new String[0]));
        RESPONSE_PARSER = new ConstructingObjectParser("search_response", true, a -> {
            Throwable catastrophicFailure;
            int i = 0;
            if ((catastrophicFailure = (Throwable)a[i++]) != null) {
                return new ScrollableHitSource.Response(false, Collections.singletonList(new ScrollableHitSource.SearchFailure(catastrophicFailure)), 0L, Collections.emptyList(), null);
            }
            boolean timedOut = (Boolean)a[i++];
            String scroll = (String)a[i++];
            Object[] hitsElement = (Object[])a[i++];
            List failures = (List)a[i++];
            long totalHits = 0L;
            List hits = Collections.emptyList();
            if (hitsElement != null) {
                List h2;
                i = 0;
                totalHits = (Long)hitsElement[i++];
                hits = h2 = (List)hitsElement[i++];
            }
            return new ScrollableHitSource.Response(timedOut, failures, totalHits, hits, scroll);
        });
        RESPONSE_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ThrowableBuilder.PARSER.apply(p, null), new ParseField("error", new String[0]));
        RESPONSE_PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("timed_out", new String[0]));
        RESPONSE_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("_scroll_id", new String[0]));
        RESPONSE_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), HITS_PARSER, new ParseField("hits", new String[0]));
        RESPONSE_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> (List)SHARDS_PARSER.apply(p, null), new ParseField("_shards", new String[0]));
        MAIN_ACTION_PARSER = new ConstructingObjectParser("/", true, a -> (Version)a[0]);
        ConstructingObjectParser versionParser = new ConstructingObjectParser("version", true, a -> a[0] == null ? LegacyESVersion.fromString((String)((String)a[1]).replace("-SNAPSHOT", "").replaceFirst("-(alpha\\d+|beta\\d+|rc\\d+)", "")) : Version.fromString((String)((String)a[1]).replace("-SNAPSHOT", "").replaceFirst("-(alpha\\d+|beta\\d+|rc\\d+)", "")));
        versionParser.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("distribution", new String[0]));
        versionParser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("number", new String[0]));
        MAIN_ACTION_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (ContextParser)versionParser, new ParseField("version", new String[0]));
    }

    public static class ThrowableBuilder {
        public static final BiFunction<XContentParser, Void, Throwable> PARSER;
        private String type;
        private String reason;
        private Integer line;
        private Integer column;
        private Throwable causedBy;

        public Throwable build() {
            Throwable t2 = this.buildWithoutCause();
            if (this.causedBy != null) {
                t2.initCause(this.causedBy);
            }
            return t2;
        }

        private Throwable buildWithoutCause() {
            Objects.requireNonNull(this.type, "[type] is required");
            Objects.requireNonNull(this.reason, "[reason] is required");
            switch (this.type) {
                case "rejected_execution_exception": {
                    return new OpenSearchRejectedExecutionException(this.reason);
                }
                case "parsing_exception": {
                    XContentLocation location = null;
                    if (this.line != null && this.column != null) {
                        location = new XContentLocation(this.line.intValue(), this.column.intValue());
                    }
                    return new ParsingException(location, this.reason, new Object[0]);
                }
            }
            return new RuntimeException(this.type + ": " + this.reason);
        }

        public void setType(String type2) {
            this.type = type2;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public void setLine(Integer line) {
            this.line = line;
        }

        public void setColumn(Integer column) {
            this.column = column;
        }

        public void setCausedBy(Throwable causedBy) {
            this.causedBy = causedBy;
        }

        static {
            ObjectParser parser = new ObjectParser("reason", true, ThrowableBuilder::new);
            PARSER = parser.andThen(ThrowableBuilder::build);
            parser.declareString(ThrowableBuilder::setType, new ParseField("type", new String[0]));
            parser.declareString(ThrowableBuilder::setReason, new ParseField("reason", new String[0]));
            parser.declareObject(ThrowableBuilder::setCausedBy, PARSER::apply, new ParseField("caused_by", new String[0]));
            parser.declareInt(ThrowableBuilder::setLine, new ParseField("line", new String[0]));
            parser.declareInt(ThrowableBuilder::setColumn, new ParseField("col", new String[0]));
        }
    }
}

