/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.mcpserver.requests;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class McpToolBaseInput
implements ToXContentObject,
Writeable {
    @Generated
    private static final Logger log = LogManager.getLogger(McpToolBaseInput.class);
    public static final String TOOL = "tool";
    public static final String TYPE_FIELD = "type";
    public static final String NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String PARAMS_FIELD = "parameters";
    public static final String ATTRIBUTES_FIELD = "attributes";
    private String type;
    private String name;
    private String description;
    private Long version;
    private Map<String, Object> parameters;
    private Map<String, Object> attributes;
    private Instant createdTime;
    private Instant lastUpdatedTime;

    public McpToolBaseInput(StreamInput streamInput) throws IOException {
        this.type = streamInput.readString();
        this.name = streamInput.readOptionalString();
        this.description = streamInput.readOptionalString();
        if (streamInput.readBoolean()) {
            this.parameters = streamInput.readMap(StreamInput::readString, StreamInput::readGenericValue);
        }
        if (streamInput.readBoolean()) {
            this.attributes = streamInput.readMap(StreamInput::readString, StreamInput::readGenericValue);
        }
        this.createdTime = streamInput.readOptionalInstant();
        this.lastUpdatedTime = streamInput.readOptionalInstant();
        this.version = streamInput.readOptionalLong();
    }

    public McpToolBaseInput(String name, String type2, String description2, Map<String, Object> parameters2, Map<String, Object> attributes, Instant createdTime, Instant lastUpdatedTime) {
        this.name = name;
        this.type = type2;
        this.description = description2;
        this.parameters = parameters2;
        this.attributes = attributes;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        streamOutput.writeString(this.type);
        streamOutput.writeOptionalString(this.name);
        streamOutput.writeOptionalString(this.description);
        if (this.parameters != null) {
            streamOutput.writeBoolean(true);
            streamOutput.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeGenericValue);
        } else {
            streamOutput.writeBoolean(false);
        }
        if (this.attributes != null) {
            streamOutput.writeBoolean(true);
            streamOutput.writeMap(this.attributes, StreamOutput::writeString, StreamOutput::writeGenericValue);
        } else {
            streamOutput.writeBoolean(false);
        }
        streamOutput.writeOptionalInstant(this.createdTime);
        streamOutput.writeOptionalInstant(this.lastUpdatedTime);
        streamOutput.writeOptionalLong(this.version);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params xcontentParams) throws IOException {
        builder.startObject();
        builder.field(TYPE_FIELD, this.type);
        if (this.name != null) {
            builder.field(NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            builder.field(PARAMS_FIELD, this.parameters);
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            builder.field(ATTRIBUTES_FIELD, this.attributes);
        }
        if (this.createdTime != null) {
            builder.field("create_time", this.createdTime.toEpochMilli());
        }
        if (this.lastUpdatedTime != null) {
            builder.field("last_update_time", this.lastUpdatedTime.toEpochMilli());
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Generated
    public void setType(String type2) {
        this.type = type2;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description2) {
        this.description = description2;
    }

    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public void setParameters(Map<String, Object> parameters2) {
        this.parameters = parameters2;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public void setLastUpdatedTime(Instant lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McpToolBaseInput)) {
            return false;
        }
        McpToolBaseInput other = (McpToolBaseInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, Object> this$parameters = this.getParameters();
        Map<String, Object> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Map<String, Object> this$attributes = this.getAttributes();
        Map<String, Object> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Instant this$createdTime = this.getCreatedTime();
        Instant other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Instant this$lastUpdatedTime = this.getLastUpdatedTime();
        Instant other$lastUpdatedTime = other.getLastUpdatedTime();
        return !(this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof McpToolBaseInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Long $version = this.getVersion();
        result2 = result2 * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $type = this.getType();
        result2 = result2 * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result2 = result2 * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result2 = result2 * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, Object> $parameters = this.getParameters();
        result2 = result2 * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Map<String, Object> $attributes = this.getAttributes();
        result2 = result2 * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Instant $createdTime = this.getCreatedTime();
        result2 = result2 * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Instant $lastUpdatedTime = this.getLastUpdatedTime();
        result2 = result2 * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        return result2;
    }

    @Generated
    public String toString() {
        return "McpToolBaseInput(type=" + this.getType() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", parameters=" + String.valueOf(this.getParameters()) + ", attributes=" + String.valueOf(this.getAttributes()) + ", createdTime=" + String.valueOf(this.getCreatedTime()) + ", lastUpdatedTime=" + String.valueOf(this.getLastUpdatedTime()) + ")";
    }
}

