/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.mcpserver.requests.update;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.mcpserver.requests.McpToolBaseInput;

public class McpToolUpdateInput
extends McpToolBaseInput {
    public static final String NAME_NOT_SHOWN_EXCEPTION_MESSAGE = "name field required";

    public McpToolUpdateInput(StreamInput streamInput) throws IOException {
        super(streamInput);
        if (super.getName() == null) {
            throw new IllegalArgumentException(NAME_NOT_SHOWN_EXCEPTION_MESSAGE);
        }
    }

    public McpToolUpdateInput(String name, String description2, Map<String, Object> parameters2, Map<String, Object> attributes, Instant createdTime, Instant lastUpdateTime) {
        super(name, null, description2, parameters2, attributes, createdTime, lastUpdateTime);
        if (name == null) {
            throw new IllegalArgumentException(NAME_NOT_SHOWN_EXCEPTION_MESSAGE);
        }
    }

    public static McpToolUpdateInput parse(XContentParser parser) throws IOException {
        String name = null;
        String description2 = null;
        Map params = null;
        Map attributes = null;
        Instant createdTime = null;
        Instant lastUpdateTime = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block16: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block16;
                }
                case "description": {
                    description2 = parser.text();
                    continue block16;
                }
                case "parameters": {
                    params = parser.map();
                    continue block16;
                }
                case "attributes": {
                    attributes = parser.map();
                    continue block16;
                }
                case "create_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block16;
                }
                case "last_update_time": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block16;
                }
            }
            parser.skipChildren();
        }
        return new McpToolUpdateInput(name, description2, params, attributes, createdTime, lastUpdateTime);
    }
}

