/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.utils;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLTextLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.common.collect.Tuple;
import org.opensearch.sql.legacy.domain.Field;
import org.opensearch.sql.legacy.domain.KVValue;
import org.opensearch.sql.legacy.domain.MethodField;
import org.opensearch.sql.legacy.domain.ScriptMethodField;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.executor.format.Schema;
import org.opensearch.sql.legacy.utils.StringUtils;
import org.opensearch.sql.legacy.utils.Util;
import shaded.com.google.common.base.Joiner;
import shaded.com.google.common.base.Strings;
import shaded.com.google.common.collect.Lists;
import shaded.com.google.common.collect.Sets;

public class SQLFunctions {
    private static final Set<String> numberOperators = Sets.newHashSet("exp", "expm1", "log", "log2", "log10", "ln", "sqrt", "cbrt", "ceil", "floor", "rint", "pow", "power", "round", "rand", "abs", "sign", "signum");
    private static final Set<String> mathConstants = Sets.newHashSet("e", "pi");
    private static final Set<String> trigFunctions = Sets.newHashSet("degrees", "radians", "sin", "cos", "tan", "asin", "acos", "atan", "atan2", "sinh", "cosh", "cot");
    private static final Set<String> stringOperators = Sets.newHashSet("split", "concat_ws", "substring", "trim", "lower", "upper", "rtrim", "ltrim", "replace", "left", "right");
    private static final Set<String> stringFunctions = Sets.newHashSet("length", "locate", "ascii");
    private static final Set<String> binaryOperators = Sets.newHashSet("add", "multiply", "divide", "subtract", "modulus");
    private static final Set<String> dateFunctions = Sets.newHashSet("date_format", "year", "month_of_year", "week_of_year", "day_of_year", "day_of_month", "day_of_week", "hour_of_day", "minute_of_day", "minute_of_hour", "second_of_minute", "month", "dayofmonth", "date", "monthname", "timestamp", "maketime", "now", "curdate");
    private static final Set<String> conditionalFunctions = Sets.newHashSet("if", "ifnull", "isnull");
    private static final Set<String> utilityFunctions = Sets.newHashSet("field", "assign", "cast");
    public static final Set<String> builtInFunctions = Stream.of(numberOperators, mathConstants, trigFunctions, stringOperators, stringFunctions, binaryOperators, dateFunctions, conditionalFunctions, utilityFunctions).flatMap(Collection::stream).collect(Collectors.toSet());
    private final Map<String, Integer> generatedIds = new HashMap<String, Integer>();

    public String nextId(String methodName) {
        return methodName + "_" + String.valueOf(this.generatedIds.merge(methodName, 1, Integer::sum));
    }

    public static boolean isFunctionTranslatedToScript(String function) {
        return builtInFunctions.contains(function.toLowerCase());
    }

    public Tuple<String, String> function(String methodName, List<KVValue> paramers, String name, boolean returnValue) throws SqlParseException {
        Tuple<String, String> functionStr = null;
        switch (methodName.toLowerCase()) {
            case "cast": {
                SQLCastExpr castExpr = (SQLCastExpr)((SQLIdentifierExpr)paramers.get((int)0).value).getParent();
                String typeName = castExpr.getDataType().getName();
                functionStr = this.cast(typeName, paramers);
                break;
            }
            case "lower": {
                functionStr = this.lower((SQLExpr)paramers.get((int)0).value, this.getLocaleForCaseChangingFunction(paramers), name);
                break;
            }
            case "upper": {
                functionStr = this.upper((SQLExpr)paramers.get((int)0).value, this.getLocaleForCaseChangingFunction(paramers), name);
                break;
            }
            case "split": {
                if (paramers.size() == 3) {
                    functionStr = this.split((SQLExpr)paramers.get((int)0).value, Util.expr2Object((SQLExpr)paramers.get((int)1).value).toString(), Integer.parseInt(Util.expr2Object((SQLExpr)paramers.get((int)2).value).toString()), name);
                    break;
                }
                functionStr = this.split((SQLExpr)paramers.get((int)0).value, paramers.get((int)1).value.toString(), name);
                break;
            }
            case "concat_ws": {
                ArrayList<SQLExpr> result2 = Lists.newArrayList();
                for (int i = 1; i < paramers.size(); ++i) {
                    result2.add((SQLExpr)paramers.get((int)i).value);
                }
                functionStr = this.concat_ws(paramers.get((int)0).value.toString(), result2);
                break;
            }
            case "date_format": {
                functionStr = this.date_format((SQLExpr)paramers.get((int)0).value, Util.expr2Object((SQLExpr)paramers.get((int)1).value).toString(), paramers.size() > 2 ? Util.expr2Object((SQLExpr)paramers.get((int)2).value).toString() : null, name);
                break;
            }
            case "year": {
                functionStr = this.dateFunctionTemplate("year", (SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "month_of_year": 
            case "month": {
                functionStr = this.dateFunctionTemplate("monthValue", (SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "monthname": {
                functionStr = this.dateFunctionTemplate("month", (SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "week_of_year": {
                functionStr = this.dateFunctionTemplate("weekOfWeekyear", "get(WeekFields.ISO.weekOfWeekBasedYear())", (SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "day_of_year": {
                functionStr = this.dateFunctionTemplate("dayOfYear", (SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "day_of_month": 
            case "dayofmonth": {
                functionStr = this.dateFunctionTemplate("dayOfMonth", (SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "day_of_week": {
                functionStr = this.dateFunctionTemplate("dayOfWeek", "getDayOfWeekEnum().getValue()", (SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "date": {
                functionStr = this.date((SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "hour_of_day": {
                functionStr = this.dateFunctionTemplate("hour", (SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "minute_of_day": {
                functionStr = this.dateFunctionTemplate("minuteOfDay", "get(ChronoField.MINUTE_OF_DAY)", (SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "minute_of_hour": {
                functionStr = this.dateFunctionTemplate("minute", (SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "second_of_minute": {
                functionStr = this.dateFunctionTemplate("second", (SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "timestamp": {
                functionStr = this.timestamp((SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "maketime": {
                functionStr = this.maketime((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value, (SQLExpr)paramers.get((int)2).value);
                break;
            }
            case "now": {
                functionStr = this.now();
                break;
            }
            case "curdate": {
                functionStr = this.curdate();
                break;
            }
            case "e": 
            case "pi": {
                methodName = methodName.toUpperCase();
                functionStr = this.mathConstantTemplate("Math." + methodName, methodName);
                break;
            }
            case "abs": 
            case "round": 
            case "floor": 
            case "ceil": 
            case "cbrt": 
            case "rint": 
            case "exp": 
            case "expm1": 
            case "sqrt": 
            case "sin": 
            case "cos": 
            case "tan": 
            case "asin": 
            case "acos": 
            case "atan": 
            case "sinh": 
            case "cosh": {
                functionStr = this.mathSingleValueTemplate("Math." + methodName, methodName, (SQLExpr)paramers.get((int)0).value, name);
                break;
            }
            case "rand": {
                if (paramers.isEmpty()) {
                    functionStr = this.rand();
                    break;
                }
                functionStr = this.rand((SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "cot": {
                functionStr = this.mathSingleValueTemplate("1 / Math.tan", methodName, (SQLExpr)paramers.get((int)0).value, name);
                break;
            }
            case "sign": 
            case "signum": {
                methodName = "signum";
                functionStr = this.mathSingleValueTemplate("Math." + methodName, methodName, (SQLExpr)paramers.get((int)0).value, name);
                break;
            }
            case "pow": 
            case "power": {
                methodName = "pow";
                functionStr = this.mathDoubleValueTemplate("Math." + methodName, methodName, (SQLExpr)paramers.get((int)0).value, Util.expr2Object((SQLExpr)paramers.get((int)1).value).toString(), name);
                break;
            }
            case "atan2": {
                functionStr = this.mathDoubleValueTemplate("Math." + methodName, methodName, (SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "substring": {
                functionStr = this.substring((SQLExpr)paramers.get((int)0).value, Integer.parseInt(Util.expr2Object((SQLExpr)paramers.get((int)1).value).toString()), Integer.parseInt(Util.expr2Object((SQLExpr)paramers.get((int)2).value).toString()));
                break;
            }
            case "degrees": {
                functionStr = this.degrees((SQLExpr)paramers.get((int)0).value, name);
                break;
            }
            case "radians": {
                functionStr = this.radians((SQLExpr)paramers.get((int)0).value, name);
                break;
            }
            case "trim": {
                functionStr = this.trim((SQLExpr)paramers.get((int)0).value, name);
                break;
            }
            case "add": {
                functionStr = this.add((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "subtract": {
                functionStr = this.subtract((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "divide": {
                functionStr = this.divide((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "multiply": {
                functionStr = this.multiply((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "modulus": {
                functionStr = this.modulus((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "field": {
                functionStr = this.field(Util.expr2Object((SQLExpr)paramers.get((int)0).value).toString());
                break;
            }
            case "log2": {
                functionStr = this.log(SQLUtils.toSQLExpr("2"), (SQLExpr)paramers.get((int)0).value, name);
                break;
            }
            case "log10": {
                functionStr = this.log10((SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "log": {
                if (paramers.size() > 1) {
                    functionStr = this.log((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value, name);
                    break;
                }
                functionStr = this.ln((SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "ln": {
                functionStr = this.ln((SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "assign": {
                functionStr = this.assign((SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "length": {
                functionStr = this.length((SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "replace": {
                functionStr = this.replace((SQLExpr)paramers.get((int)0).value, paramers.get((int)1).value.toString(), paramers.get((int)2).value.toString());
                break;
            }
            case "locate": {
                int start = 0;
                if (paramers.size() > 2) {
                    start = Integer.parseInt(paramers.get((int)2).value.toString());
                }
                functionStr = this.locate(paramers.get((int)0).value.toString(), (SQLExpr)paramers.get((int)1).value, start);
                break;
            }
            case "rtrim": {
                functionStr = this.rtrim((SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "ltrim": {
                functionStr = this.ltrim((SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "ascii": {
                functionStr = this.ascii((SQLExpr)paramers.get((int)0).value);
                break;
            }
            case "left": {
                functionStr = this.left((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "right": {
                functionStr = this.right((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "if": {
                functionStr = this.ifFunc(paramers);
                break;
            }
            case "ifnull": {
                functionStr = this.ifnull((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "isnull": {
                functionStr = this.isnull((SQLExpr)paramers.get((int)0).value);
                break;
            }
        }
        if (returnValue) {
            String generatedFieldName = (String)functionStr.v1();
            String returnCommand = ";return " + generatedFieldName + ";";
            String newScript = (String)functionStr.v2() + returnCommand;
            functionStr = new Tuple<String, String>((Object)generatedFieldName, (Object)newScript);
        }
        return functionStr;
    }

    public String getLocaleForCaseChangingFunction(List<KVValue> paramers) {
        String locale = paramers.size() == 1 ? Locale.getDefault().getLanguage() : Util.expr2Object((SQLExpr)paramers.get((int)1).value).toString();
        return locale;
    }

    public Tuple<String, String> cast(String castType, List<KVValue> paramers) throws SqlParseException {
        String name = this.nextId("cast");
        return new Tuple((Object)name, (Object)this.getCastScriptStatement(name, castType, paramers));
    }

    public Tuple<String, String> upper(SQLExpr field, String locale, String valueName) {
        String name = this.nextId("upper");
        if (valueName == null) {
            return new Tuple((Object)name, (Object)SQLFunctions.def(name, this.upper(SQLFunctions.getPropertyOrStringValue(field), locale)));
        }
        return new Tuple((Object)name, (Object)(SQLFunctions.getPropertyOrStringValue(field) + "; " + SQLFunctions.def(name, valueName + "." + this.upper(SQLFunctions.getPropertyOrStringValue(field), locale))));
    }

    public Tuple<String, String> lower(SQLExpr field, String locale, String valueName) {
        String name = this.nextId("lower");
        if (valueName == null) {
            return new Tuple((Object)name, (Object)SQLFunctions.def(name, this.lower(SQLFunctions.getPropertyOrStringValue(field), locale)));
        }
        return new Tuple((Object)name, (Object)(SQLFunctions.getPropertyOrStringValue(field) + "; " + SQLFunctions.def(name, valueName + "." + this.lower(SQLFunctions.getPropertyOrStringValue(field), locale))));
    }

    private static String def(String name, String value) {
        return "def " + name + " = " + value;
    }

    private static String doc(SQLExpr field) {
        return "doc['" + SQLFunctions.exprString(field) + "']";
    }

    private static String doc(String field) {
        return "doc['" + field + "']";
    }

    private static String exprString(SQLExpr expr) {
        return Util.expr2Object(expr).toString();
    }

    private static String func(String methodName, boolean quotes, String ... params) {
        if (quotes) {
            return methodName + "(" + SQLFunctions.quoteParams(params) + ")";
        }
        return methodName + "(" + String.join((CharSequence)", ", params) + ")";
    }

    private static String quoteParams(String ... params) {
        return Stream.of(params).collect(Collectors.joining("', '", "'", "'"));
    }

    private Tuple<String, String> concat_ws(String split, List<SQLExpr> columns) {
        String name = this.nextId("concat_ws");
        ArrayList<Object> result2 = Lists.newArrayList();
        for (SQLExpr column : columns) {
            String strColumn = SQLFunctions.exprString(column);
            if (strColumn.startsWith("def ")) {
                result2.add(strColumn);
                continue;
            }
            if (SQLFunctions.isProperty(column)) {
                result2.add("doc['" + strColumn + "'].value");
                continue;
            }
            result2.add("'" + strColumn + "'");
        }
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, Joiner.on("+ " + split + " +").join(result2)));
    }

    public Tuple<String, String> split(SQLExpr field, String pattern, int index, String valueName) {
        String name = this.nextId("split");
        Object script = valueName == null ? SQLFunctions.def(name, SQLFunctions.getPropertyOrValue(field) + "." + SQLFunctions.func("split", true, pattern) + "[" + index + "]") : "; " + SQLFunctions.def(name, valueName + "." + SQLFunctions.func("split", true, pattern) + "[" + index + "]");
        return new Tuple((Object)name, script);
    }

    public Tuple<String, String> split(SQLExpr field, String pattern, String valueName) {
        String name = this.nextId("split");
        if (valueName == null) {
            return new Tuple((Object)name, (Object)SQLFunctions.def(name, SQLFunctions.getPropertyOrValue(field) + "." + SQLFunctions.func("split", true, pattern)));
        }
        return new Tuple((Object)name, (Object)(SQLFunctions.getPropertyOrValue(field) + "; " + SQLFunctions.def(name, valueName + "." + SQLFunctions.func("split", true, pattern))));
    }

    private Tuple<String, String> date_format(SQLExpr field, String pattern, String zoneId, String valueName) {
        String name = this.nextId("date_format");
        if (valueName == null) {
            return new Tuple((Object)name, (Object)("def " + name + " = DateTimeFormatter.ofPattern('" + pattern + "').withZone(" + (String)(zoneId != null ? "ZoneId.of('" + zoneId + "')" : "ZoneId.of(\"UTC\")") + ").format(Instant.ofEpochMilli(" + SQLFunctions.getPropertyOrValue(field) + ".toInstant().toEpochMilli()))"));
        }
        return new Tuple((Object)name, (Object)(SQLFunctions.exprString(field) + "; def " + name + " = new SimpleDateFormat('" + pattern + "').format(new Date(" + valueName + " - 8*1000*60*60))"));
    }

    private Tuple<String, String> dateFunctionTemplate(String name, String methodName, SQLExpr field) {
        String id = this.nextId(name);
        return new Tuple((Object)id, (Object)SQLFunctions.def(id, SQLFunctions.doc(field) + ".value." + methodName));
    }

    private Tuple<String, String> dateFunctionTemplate(String methodName, SQLExpr field) {
        return this.dateFunctionTemplate(methodName, methodName, field);
    }

    public Tuple<String, String> add(SQLExpr a, SQLExpr b) {
        return this.binaryOpertator("add", "+", a, b);
    }

    public Tuple<String, String> assign(SQLExpr a) {
        String name = this.nextId("assign");
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, SQLFunctions.extractName(a)));
    }

    private Tuple<String, String> modulus(SQLExpr a, SQLExpr b) {
        return this.binaryOpertator("modulus", "%", a, b);
    }

    public Tuple<String, String> field(String a) {
        String name = this.nextId("field");
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, SQLFunctions.doc(a) + ".value"));
    }

    private Tuple<String, String> subtract(SQLExpr a, SQLExpr b) {
        return this.binaryOpertator("subtract", "-", a, b);
    }

    private Tuple<String, String> multiply(SQLExpr a, SQLExpr b) {
        return this.binaryOpertator("multiply", "*", a, b);
    }

    private Tuple<String, String> divide(SQLExpr a, SQLExpr b) {
        return this.binaryOpertator("divide", "/", a, b);
    }

    private Tuple<String, String> binaryOpertator(String methodName, String operator, SQLExpr a, SQLExpr b) {
        String name = this.nextId(methodName);
        return new Tuple((Object)name, (Object)(SQLFunctions.scriptDeclare(a) + SQLFunctions.scriptDeclare(b) + SQLFunctions.convertType(a) + SQLFunctions.convertType(b) + SQLFunctions.def(name, SQLFunctions.extractName(a) + " " + operator + " " + SQLFunctions.extractName(b))));
    }

    private static boolean isProperty(SQLExpr expr) {
        return expr instanceof SQLIdentifierExpr || expr instanceof SQLPropertyExpr || expr instanceof SQLVariantRefExpr;
    }

    private static String getPropertyOrValue(SQLExpr expr) {
        if (SQLFunctions.isProperty(expr)) {
            return SQLFunctions.doc(expr) + ".value";
        }
        return SQLFunctions.exprString(expr);
    }

    private static String getPropertyOrValue(String expr) {
        if (StringUtils.isQuoted(expr, "'")) {
            return expr;
        }
        if (StringUtils.isNumeric(expr)) {
            return expr;
        }
        return SQLFunctions.doc(expr) + ".value";
    }

    private static String getPropertyOrStringValue(SQLExpr expr) {
        if (SQLFunctions.isProperty(expr)) {
            return SQLFunctions.doc(expr) + ".value";
        }
        return "'" + SQLFunctions.exprString(expr) + "'";
    }

    private static String scriptDeclare(SQLExpr a) {
        if (SQLFunctions.isProperty(a) || a instanceof SQLNumericLiteralExpr) {
            return "";
        }
        return SQLFunctions.exprString(a) + ";";
    }

    private static String extractName(SQLExpr script) {
        if (SQLFunctions.isProperty(script)) {
            return SQLFunctions.doc(script) + ".value";
        }
        String scriptStr = SQLFunctions.exprString(script);
        String[] variance = scriptStr.split(";");
        String newScript = variance[variance.length - 1];
        if (newScript.trim().startsWith("def ")) {
            return newScript.trim().substring(4).split("=")[0].trim();
        }
        return scriptStr;
    }

    private static String convertType(SQLExpr script) {
        String[] variance = SQLFunctions.exprString(script).split(";");
        String newScript = variance[variance.length - 1];
        if (newScript.trim().startsWith("def ")) {
            String temp = newScript.trim().substring(4).split("=")[0].trim();
            return " if( " + temp + " instanceof String) " + temp + "= Double.parseDouble(" + temp.trim() + "); ";
        }
        return "";
    }

    private String getScriptText(MethodField field) {
        String content = ((SQLTextLiteralExpr)field.getParams().get((int)1).value).getText();
        return content;
    }

    public Tuple<String, String> log(SQLExpr base, SQLExpr field, String valueName) {
        String name = this.nextId("log");
        Object result2 = valueName == null ? SQLFunctions.def(name, SQLFunctions.func("Math.log", false, SQLFunctions.getPropertyOrValue(field)) + "/" + SQLFunctions.func("Math.log", false, SQLFunctions.exprString(base))) : SQLFunctions.getPropertyOrValue(field) + "; " + SQLFunctions.def(name, SQLFunctions.func("Math.log", false, valueName) + "/" + SQLFunctions.func("Math.log", false, SQLFunctions.exprString(base)));
        return new Tuple((Object)name, result2);
    }

    public Tuple<String, String> log10(SQLExpr field) {
        String name = this.nextId("log10");
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, StringUtils.format("Math.log10(%s)", SQLFunctions.getPropertyOrValue(field))));
    }

    public Tuple<String, String> ln(SQLExpr field) {
        String name = this.nextId("ln");
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, StringUtils.format("Math.log(%s)", SQLFunctions.getPropertyOrValue(field))));
    }

    public Tuple<String, String> trim(SQLExpr field, String valueName) {
        return this.strSingleValueTemplate("trim", field, valueName);
    }

    private Tuple<String, String> degrees(SQLExpr field, String valueName) {
        return this.mathSingleValueTemplate("Math.toDegrees", "degrees", field, valueName);
    }

    private Tuple<String, String> radians(SQLExpr field, String valueName) {
        return this.mathSingleValueTemplate("Math.toRadians", "radians", field, valueName);
    }

    private Tuple<String, String> rand(SQLExpr expr) {
        String name = this.nextId("rand");
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, StringUtils.format("new Random(%s).nextDouble()", SQLFunctions.getPropertyOrValue(expr))));
    }

    private Tuple<String, String> rand() {
        String name = this.nextId("rand");
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, "new Random().nextDouble()"));
    }

    private Tuple<String, String> mathDoubleValueTemplate(String methodName, String fieldName, SQLExpr val1, String val2, String valueName) {
        String name = this.nextId(fieldName);
        if (valueName == null) {
            return new Tuple((Object)name, (Object)SQLFunctions.def(name, SQLFunctions.func(methodName, false, SQLFunctions.getPropertyOrValue(val1), SQLFunctions.getPropertyOrValue(val2))));
        }
        return new Tuple((Object)name, (Object)(SQLFunctions.getPropertyOrValue(val1) + "; " + SQLFunctions.def(name, SQLFunctions.func(methodName, false, valueName, SQLFunctions.getPropertyOrValue(val2)))));
    }

    private Tuple<String, String> mathDoubleValueTemplate(String methodName, String fieldName, SQLExpr val1, SQLExpr val2) {
        String name = this.nextId(fieldName);
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, SQLFunctions.func(methodName, false, SQLFunctions.getPropertyOrValue(val1), SQLFunctions.getPropertyOrValue(val2))));
    }

    private Tuple<String, String> mathSingleValueTemplate(String methodName, String fieldName, SQLExpr field, String valueName) {
        String name = this.nextId(fieldName);
        if (valueName == null) {
            return new Tuple((Object)name, (Object)SQLFunctions.def(name, SQLFunctions.func(methodName, false, SQLFunctions.getPropertyOrValue(field))));
        }
        return new Tuple((Object)name, (Object)(SQLFunctions.getPropertyOrValue(field) + "; " + SQLFunctions.def(name, SQLFunctions.func(methodName, false, valueName))));
    }

    private Tuple<String, String> mathConstantTemplate(String methodName, String fieldName) {
        String name = this.nextId(fieldName);
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, methodName));
    }

    private Tuple<String, String> strSingleValueTemplate(String methodName, SQLExpr field, String valueName) {
        String name = this.nextId(methodName);
        if (valueName == null) {
            return new Tuple((Object)name, (Object)SQLFunctions.def(name, SQLFunctions.getPropertyOrStringValue(field) + "." + SQLFunctions.func(methodName, false, new String[0])));
        }
        return new Tuple((Object)name, (Object)(SQLFunctions.getPropertyOrStringValue(field) + "; " + SQLFunctions.def(name, valueName + "." + SQLFunctions.func(methodName, false, new String[0]))));
    }

    public Tuple<String, String> substring(SQLExpr field, int pos, int len) {
        String name = this.nextId("substring");
        int start = pos < 1 ? 0 : pos - 1;
        return new Tuple((Object)name, (Object)StringUtils.format("def end = (int) Math.min(%s + %s, %s.length()); " + SQLFunctions.def(name, SQLFunctions.getPropertyOrStringValue(field) + "." + SQLFunctions.func("substring", false, Integer.toString(start), "end")), Integer.toString(start), Integer.toString(len), SQLFunctions.getPropertyOrStringValue(field)));
    }

    private String lower(String property, String culture) {
        return property + ".toLowerCase(Locale.forLanguageTag(\"" + culture + "\"))";
    }

    private String upper(String property, String culture) {
        return property + ".toUpperCase(Locale.forLanguageTag(\"" + culture + "\"))";
    }

    private Tuple<String, String> length(SQLExpr field) {
        String name = this.nextId("length");
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, SQLFunctions.getPropertyOrStringValue(field) + ".length()"));
    }

    private Tuple<String, String> replace(SQLExpr field, String target, String replacement) {
        String name = this.nextId("replace");
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, SQLFunctions.getPropertyOrStringValue(field) + ".replace(" + target + "," + replacement + ")"));
    }

    private Tuple<String, String> locate(String pattern, SQLExpr source2, int start) {
        String name = this.nextId("locate");
        String docSource = SQLFunctions.getPropertyOrStringValue(source2);
        start = start < 1 ? 0 : start - 1;
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, StringUtils.format("%s.indexOf(%s,%d)+1", docSource, pattern, start)));
    }

    private Tuple<String, String> rtrim(SQLExpr field) {
        String name = this.nextId("rtrim");
        String fieldString = SQLFunctions.getPropertyOrStringValue(field);
        return new Tuple((Object)name, (Object)StringUtils.format("int pos=%s.length()-1;while(pos >= 0 && Character.isWhitespace(%s.charAt(pos))) {pos --;} " + SQLFunctions.def(name, "%s.substring(0, pos+1)"), fieldString, fieldString, fieldString));
    }

    private Tuple<String, String> ltrim(SQLExpr field) {
        String name = this.nextId("ltrim");
        String fieldString = SQLFunctions.getPropertyOrStringValue(field);
        return new Tuple((Object)name, (Object)StringUtils.format("int pos=0;while(pos < %s.length() && Character.isWhitespace(%s.charAt(pos))) {pos ++;} " + SQLFunctions.def(name, "%s.substring(pos, %s.length())"), fieldString, fieldString, fieldString, fieldString));
    }

    private Tuple<String, String> ascii(SQLExpr field) {
        String name = this.nextId("ascii");
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, "(int) " + SQLFunctions.getPropertyOrStringValue(field) + ".charAt(0)"));
    }

    private Tuple<String, String> left(SQLExpr expr, SQLExpr length) {
        String name = this.nextId("left");
        return new Tuple((Object)name, (Object)StringUtils.format("def len = (int) Math.min(%s, %s.length()); def %s = %s.substring(0, len)", SQLFunctions.exprString(length), SQLFunctions.getPropertyOrStringValue(expr), name, SQLFunctions.getPropertyOrStringValue(expr)));
    }

    private Tuple<String, String> right(SQLExpr expr, SQLExpr length) {
        String name = this.nextId("right");
        return new Tuple((Object)name, (Object)StringUtils.format("def start = (int) Math.max(0, %s.length()-%s); def %s = %s.substring(start)", SQLFunctions.getPropertyOrStringValue(expr), SQLFunctions.exprString(length), name, SQLFunctions.getPropertyOrStringValue(expr)));
    }

    private Tuple<String, String> date(SQLExpr field) {
        String name = this.nextId("date");
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, "LocalDate.parse(" + SQLFunctions.getPropertyOrStringValue(field) + ".toString(),DateTimeFormatter.ISO_DATE_TIME)"));
    }

    private Tuple<String, String> timestamp(SQLExpr field) {
        String name = this.nextId("timestamp");
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, "DateTimeFormatter.ofPattern('yyyy-MM-dd HH:mm:ss').format(DateTimeFormatter.ISO_DATE_TIME.parse(" + SQLFunctions.getPropertyOrStringValue(field) + ".toString()))"));
    }

    private Tuple<String, String> maketime(SQLExpr hr, SQLExpr min2, SQLExpr sec) {
        String name = this.nextId("maketime");
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, StringUtils.format("LocalTime.of(%s, %s, %s).format(DateTimeFormatter.ofPattern('HH:mm:ss'))", hr.toString(), min2.toString(), sec.toString())));
    }

    private Tuple<String, String> now() {
        String name = this.nextId("now");
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, "new SimpleDateFormat('HH:mm:ss').format(System.currentTimeMillis())"));
    }

    private Tuple<String, String> curdate() {
        String name = this.nextId("curdate");
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, "new SimpleDateFormat('yyyy-MM-dd').format(System.currentTimeMillis())"));
    }

    private Tuple<String, String> ifFunc(List<KVValue> paramers) {
        String expr1 = paramers.get((int)1).value.toString();
        String expr2 = paramers.get((int)2).value.toString();
        String name = this.nextId("if");
        if (paramers.get((int)0).value instanceof SQLNullExpr) {
            return new Tuple((Object)name, (Object)SQLFunctions.def(name, expr2));
        }
        if (paramers.get((int)0).value instanceof MethodField) {
            String condition = this.getScriptText((MethodField)paramers.get((int)0).value);
            return new Tuple((Object)name, (Object)("boolean cond = " + condition + ";" + SQLFunctions.def(name, "cond ? " + expr1 + " : " + expr2)));
        }
        if (paramers.get((int)0).value instanceof SQLBooleanExpr) {
            Boolean condition = ((SQLBooleanExpr)paramers.get((int)0).value).getValue();
            if (condition.booleanValue()) {
                return new Tuple((Object)name, (Object)SQLFunctions.def(name, expr1));
            }
            return new Tuple((Object)name, (Object)SQLFunctions.def(name, expr2));
        }
        String key = SQLFunctions.getPropertyOrValue(paramers.get((int)0).key);
        String value = SQLFunctions.getPropertyOrValue(paramers.get((int)0).value.toString());
        String condition = key + " == " + value;
        return new Tuple((Object)name, (Object)("boolean cond = " + condition + ";" + SQLFunctions.def(name, "cond ? " + expr1 + " : " + expr2)));
    }

    private Tuple<String, String> ifnull(SQLExpr condition, SQLExpr expr) {
        String name = this.nextId("ifnull");
        if (condition instanceof SQLNullExpr) {
            return new Tuple((Object)name, (Object)SQLFunctions.def(name, expr.toString()));
        }
        if (SQLFunctions.isProperty(condition)) {
            return new Tuple((Object)name, (Object)SQLFunctions.def(name, SQLFunctions.doc(condition) + ".size()==0 ? " + expr.toString() + " : " + SQLFunctions.getPropertyOrValue(condition)));
        }
        String condStr = Strings.isNullOrEmpty(condition.toString()) ? null : SQLFunctions.getPropertyOrStringValue(condition);
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, condStr));
    }

    private Tuple<String, String> isnull(SQLExpr expr) {
        String name = this.nextId("isnull");
        if (expr instanceof SQLNullExpr) {
            return new Tuple((Object)name, (Object)SQLFunctions.def(name, "1"));
        }
        if (SQLFunctions.isProperty(expr)) {
            return new Tuple((Object)name, (Object)SQLFunctions.def(name, SQLFunctions.doc(expr) + ".size()==0 ? 1 : 0"));
        }
        String resultStr = "0";
        if (Strings.isNullOrEmpty(expr.toString())) {
            resultStr = "1";
        }
        if (expr instanceof SQLCharExpr && this.generatedIds.size() > 1) {
            String mathExpr = ((SQLCharExpr)expr).getText();
            return new Tuple((Object)name, (Object)StringUtils.format("try {%s;} catch(ArithmeticException e) {return 1;} def %s=0", mathExpr, name, name));
        }
        return new Tuple((Object)name, (Object)SQLFunctions.def(name, resultStr));
    }

    public String getCastScriptStatement(String name, String castType, List<KVValue> paramers) throws SqlParseException {
        String castFieldName = String.format("doc['%s'].value", paramers.get(0).toString());
        switch (StringUtils.toUpper(castType)) {
            case "INT": 
            case "LONG": 
            case "FLOAT": 
            case "DOUBLE": {
                return this.getCastToNumericValueScript(name, castFieldName, StringUtils.toLower(castType));
            }
            case "STRING": {
                return String.format("def %s = %s.toString()", name, castFieldName);
            }
            case "DATETIME": {
                return String.format("def %s = DateTimeFormatter.ofPattern(\"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'\").format(DateTimeFormatter.ISO_DATE_TIME.parse(%s.toString()))", name, castFieldName);
            }
        }
        throw new SqlParseException("Unsupported cast type " + castType);
    }

    private String getCastToNumericValueScript(String varName, String docValue, String targetType) {
        String script = "def %1$s = (%2$s instanceof boolean) ? (%2$s ? 1 : 0) : Double.parseDouble(%2$s.toString()).%3$sValue()";
        return StringUtils.format(script, varName, docValue, targetType);
    }

    public static Schema.Type getScriptFunctionReturnType(MethodField field, Schema.Type resolvedType) {
        String functionName = ((ScriptMethodField)field).getFunctionName().toLowerCase();
        if (functionName.equals("cast")) {
            String castType = ((SQLCastExpr)field.getExpression()).getDataType().getName();
            return SQLFunctions.getCastFunctionReturnType(castType);
        }
        return resolvedType;
    }

    public static Schema.Type getCastFunctionReturnType(String castType) {
        switch (StringUtils.toUpper(castType)) {
            case "FLOAT": {
                return Schema.Type.FLOAT;
            }
            case "DOUBLE": {
                return Schema.Type.DOUBLE;
            }
            case "INT": {
                return Schema.Type.INTEGER;
            }
            case "STRING": {
                return Schema.Type.TEXT;
            }
            case "DATETIME": {
                return Schema.Type.DATE;
            }
            case "LONG": {
                return Schema.Type.LONG;
            }
        }
        throw new UnsupportedOperationException(StringUtils.format("The following type is not supported by cast(): %s", castType));
    }

    public static Schema.Type getOrderByFieldType(Field field) {
        String functionName = ((ScriptMethodField)field).getFunctionName().toLowerCase();
        if (functionName.equals("cast")) {
            String castType = ((SQLCastExpr)field.getExpression()).getDataType().getName();
            return SQLFunctions.getCastFunctionReturnType(castType);
        }
        if (numberOperators.contains(functionName) || mathConstants.contains(functionName) || trigFunctions.contains(functionName) || binaryOperators.contains(functionName)) {
            return Schema.Type.DOUBLE;
        }
        if (dateFunctions.contains(functionName)) {
            if (functionName.equals("date_format") || functionName.equals("now") || functionName.equals("curdate") || functionName.equals("date") || functionName.equals("timestamp") || functionName.equals("monthname")) {
                return Schema.Type.TEXT;
            }
            return Schema.Type.DOUBLE;
        }
        if (stringFunctions.contains(functionName) || stringOperators.contains(functionName)) {
            return Schema.Type.TEXT;
        }
        throw new UnsupportedOperationException(String.format("The following method is not supported in Schema for Order By: %s", functionName));
    }
}

