/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.os;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.Semaphore;
import org.eclipse.app4mc.amalthea.model.SemaphoreType;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-OS-Semaphore-Properties-Conform-Type", checks={"Semaphore properties conform to semaphore type"})
public class AmOSSemaphorePropertiesConformType
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getSemaphore();
    }

    /*
     * WARNING - void declaration
     */
    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        EObject eObject2 = eObject;
        if (eObject2 instanceof Semaphore) {
            void sem;
            Semaphore semaphore = (Semaphore)eObject2;
            Semaphore cfr_ignored_0 = (Semaphore)eObject2;
            SemaphoreType semType = sem.getSemaphoreType();
            if (sem.getInitialValue() > sem.getMaxValue()) {
                this.addIssue(results, (EObject)sem, (EStructuralFeature)ePackage.getSemaphore_InitialValue(), "The initial value must be less than or equal to the max value.");
            }
            if (EnumSet.of(SemaphoreType.RESOURCE, SemaphoreType.SPINLOCK, SemaphoreType.MUTEX).contains(semType) && sem.getInitialValue() != 0) {
                this.addIssue(results, (EObject)sem, (EStructuralFeature)ePackage.getSemaphore_InitialValue(), "The initial value must be set to 0 for semaphore type '" + semType + "'.");
            }
            if (EnumSet.of(SemaphoreType.SPINLOCK, SemaphoreType.MUTEX).contains(semType) && sem.getMaxValue() != 1) {
                this.addIssue(results, (EObject)sem, (EStructuralFeature)ePackage.getSemaphore_MaxValue(), "The maximum value must be set to 1 for semaphore type '" + semType + "'.");
            }
            if (EnumSet.of(SemaphoreType.RESOURCE, SemaphoreType.SPINLOCK, SemaphoreType.MUTEX).contains(semType) && !sem.isOwnership()) {
                this.addIssue(results, (EObject)sem, (EStructuralFeature)ePackage.getSemaphore_Ownership(), "Ownership must be set to TRUE for semaphore type '" + semType + "'.");
            }
            if (semType == SemaphoreType.COUNTING_SEMAPHORE && sem.isPriorityCeilingProtocol()) {
                this.addIssue(results, (EObject)sem, (EStructuralFeature)ePackage.getSemaphore_PriorityCeilingProtocol(), "Priority Ceiling Protocol must be set to FALSE for semaphore type '" + semType + "'.");
            }
        }
    }
}

