/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.software;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.CallArgument;
import org.eclipse.app4mc.amalthea.model.DataDependency;
import org.eclipse.app4mc.amalthea.model.DirectionType;
import org.eclipse.app4mc.amalthea.model.IActivityGraphItemContainer;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.RunnableParameter;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-SW-DataDependency", checks={"A data dependency can only be defined for specific types of label accesses, parameters and call arguments", "A data dependency can only refer to specific types of parameters and call arguments"})
public class AmSwDataDependency
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getDataDependency();
    }

    /*
     * WARNING - void declaration
     */
    public void validate(EObject object, List<ValidationDiagnostic> results) {
        EObject eObject = object;
        if (eObject instanceof DataDependency) {
            List<CallArgument> localCallArguments;
            List<RunnableParameter> localParameters;
            EObject eObject2;
            CallArgument direction;
            EObject eObject3;
            RunnableParameter accessType;
            void dependency;
            DataDependency dataDependency = (DataDependency)eObject;
            DataDependency cfr_ignored_0 = (DataDependency)eObject;
            Runnable runnable = dependency.getContainingRunnable();
            if (runnable == null) {
                return;
            }
            EObject container = dependency.eContainer();
            EObject eObject4 = container;
            if (eObject4 instanceof LabelAccess) {
                void labelAccess;
                LabelAccess labelAccess2 = (LabelAccess)eObject4;
                LabelAccess cfr_ignored_1 = (LabelAccess)eObject4;
                accessType = labelAccess.getAccess();
                if (accessType != LabelAccessEnum.WRITE) {
                    this.addIssue(results, (EObject)labelAccess, (EStructuralFeature)ePackage.getIDependsOn_DependsOn(), "Data dependency: A data dependency can only be defined for WRITE label accesses");
                }
            }
            if ((eObject3 = container) instanceof RunnableParameter) {
                void runParam;
                accessType = (RunnableParameter)eObject3;
                RunnableParameter cfr_ignored_2 = (RunnableParameter)eObject3;
                direction = runParam.getDirection();
                if (direction != DirectionType.OUT && direction != DirectionType.INOUT) {
                    this.addIssue(results, (EObject)runParam, (EStructuralFeature)ePackage.getIDependsOn_DependsOn(), "Data dependency: A data dependency can only be defined for OUT/INOUT parameters");
                }
            }
            if ((eObject2 = container) instanceof CallArgument) {
                DirectionType direction2;
                void callArg;
                direction = (CallArgument)eObject2;
                CallArgument cfr_ignored_3 = (CallArgument)eObject2;
                RunnableParameter parameter = callArg.getParameter();
                if (parameter != null && (direction2 = parameter.getDirection()) != DirectionType.IN && direction2 != DirectionType.INOUT) {
                    this.addIssue(results, (EObject)callArg, (EStructuralFeature)ePackage.getIDependsOn_DependsOn(), "Data dependency: A data dependency can only be defined for IN/INOUT call arguments");
                }
            }
            if (!(localParameters = this.getSuitableParameters(runnable)).containsAll((Collection<?>)dependency.getParameters())) {
                this.addIssue(results, (EObject)dependency, (EStructuralFeature)ePackage.getDataDependency_Parameters(), "Data dependency: A data dependency can only refer to local IN/INOUT parameters");
            }
            if (!(localCallArguments = this.getSuitableCallArguments(runnable)).containsAll((Collection<?>)dependency.getCallArguments())) {
                this.addIssue(results, (EObject)dependency, (EStructuralFeature)ePackage.getDataDependency_CallArguments(), "Data dependency: A data dependency can only refer to local OUT/INOUT call arguments");
            }
        }
    }

    private List<RunnableParameter> getSuitableParameters(Runnable runnable) {
        if (runnable == null) {
            return Collections.emptyList();
        }
        return runnable.getParameters().stream().filter(e -> e.getDirection() == DirectionType.IN || e.getDirection() == DirectionType.INOUT).toList();
    }

    private List<CallArgument> getSuitableCallArguments(Runnable runnable) {
        if (runnable == null) {
            return Collections.emptyList();
        }
        List<DirectionType> possibleDirections = List.of(DirectionType.OUT, DirectionType.INOUT);
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)runnable.getActivityGraph(), null, RunnableCall.class).stream().flatMap(e -> e.getArguments().stream()).filter(e -> e.getParameter() != null).filter(e -> possibleDirections.contains(e.getParameter().getDirection())).toList();
    }
}

