/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea._import.atdb;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import org.eclipse.app4mc.amalthea._import.atdb.EventChainConverter;
import org.eclipse.app4mc.amalthea._import.atdb.EventConverter;
import org.eclipse.app4mc.amalthea._import.atdb.HWConverter;
import org.eclipse.app4mc.amalthea._import.atdb.LabelConverter;
import org.eclipse.app4mc.amalthea._import.atdb.ProcessConverter;
import org.eclipse.app4mc.amalthea._import.atdb.RunnableConverter;
import org.eclipse.app4mc.amalthea._import.atdb.StimulusConverter;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.io.AmaltheaLoader;
import org.eclipse.app4mc.amalthea.model.io.AmaltheaWriter;
import org.eclipse.app4mc.amalthea.model.util.HardwareUtil;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ImportTransformation
implements IRunnableWithProgress {
    private final String atdbSource;
    private final String amxmiFile;
    private final boolean extractLabelsAndAccesses;
    private final boolean extractRunnableRuntimes;
    private final boolean overwriteExisting;

    public ImportTransformation(String source, String target, boolean extractLabelsAndAccesses, boolean extractRunnableRuntimes, boolean overwriteExisting) {
        this.atdbSource = source;
        this.amxmiFile = target;
        this.extractLabelsAndAccesses = extractLabelsAndAccesses;
        this.extractRunnableRuntimes = extractRunnableRuntimes;
        this.overwriteExisting = overwriteExisting;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        if (this.atdbSource.isEmpty() || this.amxmiFile.isEmpty()) {
            return;
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)"Creating AMALTHEA model from ATDB...", (int)8);
        SubMonitor openATDBMonitor = subMon.split(1);
        Path amxmiFilePath = Paths.get(this.amxmiFile, new String[0]);
        if (this.overwriteExisting) {
            try {
                Files.deleteIfExists(amxmiFilePath);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        openATDBMonitor.beginTask("Opening ATDB file...", 1);
        try {
            try {
                Throwable e = null;
                Object var6_9 = null;
                try (ATDBConnection con = new ATDBConnection(this.atdbSource);){
                    Amalthea model;
                    openATDBMonitor.worked(1);
                    Amalthea amalthea = model = Files.exists(amxmiFilePath, new LinkOption[0]) ? AmaltheaLoader.loadFromFileNamed((String)this.amxmiFile) : AmaltheaFactory.eINSTANCE.createAmalthea();
                    if (model == null) {
                        throw new InvocationTargetException(new Exception("Could not load amalthea model from file: " + this.amxmiFile + "!"));
                    }
                    SubMonitor hwConvMonitor = subMon.split(1);
                    HWConverter hwConverter = new HWConverter(model, con);
                    hwConverter.run((IProgressMonitor)hwConvMonitor);
                    if (this.extractLabelsAndAccesses) {
                        SubMonitor labelConvMonitor = subMon.split(1);
                        LabelConverter labelConverter = new LabelConverter(model, con);
                        labelConverter.run((IProgressMonitor)labelConvMonitor);
                    }
                    SubMonitor runConvMonitor = subMon.split(1);
                    double freqInHz = HardwareUtil.getModulesFromHwModel(ProcessingUnit.class, (Amalthea)model).stream().mapToLong(HardwareUtil::getFrequencyOfModuleInHz).average().orElse(0.0);
                    RunnableConverter runnableConverter = new RunnableConverter(model, con, this.extractRunnableRuntimes, this.extractLabelsAndAccesses, freqInHz);
                    runnableConverter.run((IProgressMonitor)runConvMonitor);
                    SubMonitor stimConvMonitor = subMon.split(1);
                    StimulusConverter stimulusConverter = new StimulusConverter(model, con);
                    stimulusConverter.run((IProgressMonitor)stimConvMonitor);
                    SubMonitor procConvMonitor = subMon.split(1);
                    ProcessConverter processConverter = new ProcessConverter(model, con);
                    processConverter.run((IProgressMonitor)procConvMonitor);
                    SubMonitor evConvMonitor = subMon.split(1);
                    EventConverter eventConverter = new EventConverter(model, con);
                    eventConverter.run((IProgressMonitor)evConvMonitor);
                    SubMonitor ecConvMonitor = subMon.split(1);
                    EventChainConverter eventChainConverter = new EventChainConverter(model, con);
                    eventChainConverter.run((IProgressMonitor)ecConvMonitor);
                    AmaltheaWriter.writeToFileNamed((Amalthea)model, (String)this.amxmiFile);
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (SQLException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            progressMonitor.done();
        }
    }
}

