/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.validation.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.validation.annotation.Profile;
import org.eclipse.app4mc.validation.annotation.ProfileGroup;
import org.eclipse.app4mc.validation.annotation.ValidationGroup;
import org.eclipse.app4mc.validation.core.IProfile;
import org.eclipse.app4mc.validation.core.IValidation;
import org.eclipse.app4mc.validation.core.Severity;
import org.eclipse.app4mc.validation.util.CachedValidator;

public class CachedProfile {
    private final Class<? extends IProfile> profileClass;
    private final CachedProfile parentProfile;
    private final String name;
    private final String description;
    private final Map<Class<? extends IProfile>, CachedProfile> profiles = new HashMap<Class<? extends IProfile>, CachedProfile>();
    private final Map<Class<? extends IValidation>, CachedValidator> validations = new HashMap<Class<? extends IValidation>, CachedValidator>();

    public CachedProfile(Class<? extends IProfile> profileClass) {
        this(profileClass, null);
    }

    public CachedProfile(Class<? extends IProfile> profileClass, CachedProfile parent) {
        ValidationGroup[] validationGroupList;
        int n;
        ProfileGroup[] profileGroupList;
        if (profileClass == null) {
            throw new IllegalArgumentException("Loading aborted - Undefined profile class (null)");
        }
        this.profileClass = profileClass;
        this.parentProfile = parent;
        Profile profile = profileClass.getAnnotation(Profile.class);
        this.name = profile != null ? profile.name() : profileClass.getSimpleName();
        this.description = profile != null ? profile.description() : "";
        List<Class<? extends IProfile>> forbiddenClasses = this.forbiddenSubProfileClasses();
        ProfileGroup[] profileGroupArray = profileGroupList = (ProfileGroup[])profileClass.getAnnotationsByType(ProfileGroup.class);
        int n2 = profileGroupList.length;
        int n3 = 0;
        while (n3 < n2) {
            ProfileGroup pGroup = profileGroupArray[n3];
            Class<? extends IProfile>[] classArray = pGroup.profiles();
            n = classArray.length;
            int n4 = 0;
            while (n4 < n) {
                Class<? extends IProfile> pClass = classArray[n4];
                if (pClass == null) {
                    throw new IllegalArgumentException("Loading aborted - Undefined sub profile class (null)");
                }
                if (forbiddenClasses.contains(pClass)) {
                    throw new IllegalArgumentException("Loading aborted - Cycle detected: " + pClass);
                }
                this.profiles.put(pClass, new CachedProfile(pClass, this));
                ++n4;
            }
            ++n3;
        }
        ValidationGroup[] validationGroupArray = validationGroupList = (ValidationGroup[])profileClass.getAnnotationsByType(ValidationGroup.class);
        int n5 = validationGroupList.length;
        n2 = 0;
        while (n2 < n5) {
            ValidationGroup vGroup = validationGroupArray[n2];
            Class<? extends IValidation>[] classArray = vGroup.validations();
            int n6 = classArray.length;
            n = 0;
            while (n < n6) {
                Class<? extends IValidation> vClass = classArray[n];
                if (vClass == null) {
                    throw new IllegalArgumentException("Loading aborted - Undefined validation class (null)");
                }
                this.validations.put(vClass, new CachedValidator(vClass, vGroup.severity()));
                ++n;
            }
            ++n2;
        }
    }

    private List<Class<? extends IProfile>> forbiddenSubProfileClasses() {
        ArrayList<Class<? extends IProfile>> classes = new ArrayList<Class<? extends IProfile>>();
        CachedProfile profile = this;
        while (profile != null) {
            Class<? extends IProfile> pc = profile.getProfileClass();
            if (pc != null) {
                classes.add(pc);
            }
            profile = profile.getParentProfile();
        }
        return classes;
    }

    public CachedProfile getParentProfile() {
        return this.parentProfile;
    }

    public Class<? extends IProfile> getProfileClass() {
        return this.profileClass;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<Class<? extends IProfile>, CachedProfile> getCachedProfiles() {
        return this.profiles;
    }

    public Map<Class<? extends IValidation>, CachedValidator> getCachedValidations() {
        return this.validations;
    }

    public Map<Class<? extends IValidation>, Severity> getAllValidations() {
        HashMap<Class<? extends IValidation>, Severity> resultMap = new HashMap<Class<? extends IValidation>, Severity>();
        this.addAllValidations(this, resultMap);
        return resultMap;
    }

    private void addAllValidations(CachedProfile profile, Map<Class<? extends IValidation>, Severity> resultMap) {
        for (CachedValidator cachedValidator : profile.getCachedValidations().values()) {
            Class<? extends IValidation> validatorClass = cachedValidator.getValidatorClass();
            Severity validatorSeverity = cachedValidator.getSeverity();
            Severity oldSeverity = resultMap.get(validatorClass);
            if (oldSeverity != null && oldSeverity.ordinal() >= validatorSeverity.ordinal()) continue;
            resultMap.put(validatorClass, validatorSeverity);
        }
        for (CachedProfile subProfile : profile.getCachedProfiles().values()) {
            this.addAllValidations(subProfile, resultMap);
        }
    }
}

