/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.validation.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.eclipse.app4mc.validation.core.IProfile;
import org.eclipse.app4mc.validation.core.IValidation;
import org.eclipse.app4mc.validation.core.Severity;
import org.eclipse.app4mc.validation.util.CachedProfile;
import org.eclipse.app4mc.validation.util.CachedValidator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;

public class ValidationAggregator {
    private final Map<Class<? extends IProfile>, CachedProfile> profileCache = new HashMap<Class<? extends IProfile>, CachedProfile>();
    private final Map<Class<? extends IValidation>, CachedValidator> validatorCache = new HashMap<Class<? extends IValidation>, CachedValidator>();
    private final Set<EPackage> ePackageSet = new HashSet<EPackage>();
    private final Set<EClass> eClassSet = new HashSet<EClass>();
    private final Map<EClassifier, List<CachedValidator>> validationMap1 = new HashMap<EClassifier, List<CachedValidator>>();
    private final Map<EClassifier, Set<CachedValidator>> validationMap2 = new HashMap<EClassifier, Set<CachedValidator>>();
    private boolean rebuildValidationMaps = false;

    public void addProfiles(Collection<Class<? extends IProfile>> profileClasses) {
        if (profileClasses == null || profileClasses.isEmpty()) {
            return;
        }
        for (Class<? extends IProfile> pClass : profileClasses) {
            this.addProfile(pClass);
        }
    }

    public void addProfile(Class<? extends IProfile> profileClass) {
        if (profileClass == null) {
            return;
        }
        if (!this.profileCache.containsKey(profileClass)) {
            CachedProfile profile = new CachedProfile(profileClass);
            this.profileCache.put(profileClass, profile);
            this.addValidations(profile.getAllValidations());
        }
    }

    public void addValidations(Map<Class<? extends IValidation>, Severity> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<Class<? extends IValidation>, Severity> entry : map.entrySet()) {
            this.addValidation(entry.getKey(), entry.getValue());
        }
    }

    public void addValidation(Class<? extends IValidation> validatorClass, Severity validatorSeverity) {
        if (validatorClass == null) {
            return;
        }
        CachedValidator cachedValidator = this.validatorCache.get(validatorClass);
        if (cachedValidator == null) {
            CachedValidator newValidator = new CachedValidator(validatorClass, validatorSeverity);
            this.validatorCache.put(validatorClass, newValidator);
            this.rebuildValidationMaps = true;
            EPackage ePackage = newValidator.getValidatorInstance().getEPackage();
            if (ePackage != null && !this.ePackageSet.contains(ePackage)) {
                this.ePackageSet.add(ePackage);
                this.extendClassSet(ePackage);
            }
        } else if (cachedValidator.getSeverity().ordinal() < validatorSeverity.ordinal()) {
            cachedValidator.setSeverity(validatorSeverity);
        }
    }

    private void extendClassSet(EPackage ePackage) {
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            EClass eClass;
            if (!(classifier instanceof EClass) || (eClass = (EClass)classifier).isAbstract() || eClass.isInterface()) continue;
            this.eClassSet.add(eClass);
        }
    }

    private void rebuildValidationMaps() {
        this.validationMap1.clear();
        for (CachedValidator cachedValidator : this.validatorCache.values()) {
            EClassifier eClassifier = cachedValidator.getTargetEClassifier();
            this.validationMap1.computeIfAbsent(eClassifier, k -> new ArrayList()).add(cachedValidator);
        }
        this.validationMap2.clear();
        for (Map.Entry entry : this.validationMap1.entrySet()) {
            this.addValidationsToMap2((EClassifier)entry.getKey(), (List)entry.getValue());
        }
        this.rebuildValidationMaps = false;
    }

    private void addValidationsToMap2(EClassifier eClassifier, List<CachedValidator> validatorList) {
        if (eClassifier instanceof EDataType) {
            this.basicAddValidationsToMap2(eClassifier, validatorList);
        } else if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            if (!eClass.isAbstract() && !eClass.isInterface()) {
                this.basicAddValidationsToMap2((EClassifier)eClass, validatorList);
            }
            for (EClass potentialSubclass : this.eClassSet) {
                if (!eClass.equals(EcorePackage.eINSTANCE.getEObject()) && !eClass.isSuperTypeOf(potentialSubclass)) continue;
                this.basicAddValidationsToMap2((EClassifier)potentialSubclass, validatorList);
            }
        }
    }

    private void basicAddValidationsToMap2(EClassifier eClassifier, List<CachedValidator> validatorList) {
        if (this.ePackageSet.contains(eClassifier.eContainer())) {
            this.validationMap2.computeIfAbsent(eClassifier, k -> new HashSet()).addAll(validatorList);
        }
    }

    public List<Class<? extends IProfile>> getProfiles() {
        return this.profileCache.values().stream().map(CachedProfile::getProfileClass).collect(Collectors.toList());
    }

    public Set<EPackage> getEPackages() {
        return Collections.unmodifiableSet(this.ePackageSet);
    }

    public Set<CachedValidator> getValidations(EClass targetClass) {
        Set<CachedValidator> result;
        if (this.rebuildValidationMaps) {
            this.rebuildValidationMaps();
        }
        if ((result = this.validationMap2.get(targetClass)) == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(result);
    }

    public ConcurrentMap<EClassifier, CopyOnWriteArraySet<CachedValidator>> getConcurrentValidationMap() {
        if (this.rebuildValidationMaps) {
            this.rebuildValidationMaps();
        }
        ConcurrentHashMap<EClassifier, CopyOnWriteArraySet<CachedValidator>> map = new ConcurrentHashMap<EClassifier, CopyOnWriteArraySet<CachedValidator>>();
        for (Map.Entry<EClassifier, Set<CachedValidator>> entry : this.validationMap2.entrySet()) {
            map.put(entry.getKey(), new CopyOnWriteArraySet(entry.getValue()));
        }
        return map;
    }

    public void dumpValidationMap1(PrintStream out) {
        if (out == null) {
            return;
        }
        if (this.rebuildValidationMaps) {
            this.rebuildValidationMaps();
        }
        List classifiers = this.validationMap1.keySet().stream().sorted(Comparator.comparing(ENamedElement::getName)).collect(Collectors.toList());
        for (EClassifier cl : classifiers) {
            out.println(String.valueOf(cl.getName()) + ":");
            this.validationMap1.get(cl).stream().sorted(Comparator.comparing(CachedValidator::getValidationID)).forEachOrdered(cv -> out.println("    " + cv.getValidationID() + " -> " + (Object)((Object)cv.getSeverity())));
        }
    }

    public void dumpValidationMap2(PrintStream out) {
        if (out == null) {
            return;
        }
        if (this.rebuildValidationMaps) {
            this.rebuildValidationMaps();
        }
        List classifiers = this.validationMap2.keySet().stream().sorted(Comparator.comparing(ENamedElement::getName)).collect(Collectors.toList());
        for (EClassifier cl : classifiers) {
            out.println(String.valueOf(cl.getName()) + ":");
            this.validationMap2.get(cl).stream().sorted(Comparator.comparing(CachedValidator::getValidationID)).forEachOrdered(cv -> out.println("    " + cv.getValidationID() + " -> " + (Object)((Object)cv.getSeverity())));
        }
    }
}

