/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.Cache;
import org.eclipse.app4mc.amalthea.model.CacheDefinition;
import org.eclipse.app4mc.amalthea.model.ConnectionHandler;
import org.eclipse.app4mc.amalthea.model.ConnectionHandlerDefinition;
import org.eclipse.app4mc.amalthea.model.DataRate;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.HwAccessElement;
import org.eclipse.app4mc.amalthea.model.HwAccessPath;
import org.eclipse.app4mc.amalthea.model.HwConnection;
import org.eclipse.app4mc.amalthea.model.HwDestination;
import org.eclipse.app4mc.amalthea.model.HwModule;
import org.eclipse.app4mc.amalthea.model.HwPathElement;
import org.eclipse.app4mc.amalthea.model.HwStructure;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.util.FactoryUtil;
import org.eclipse.app4mc.amalthea.model.util.RuntimeUtil;

public class HardwareUtil {
    private HardwareUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static <T extends HwModule> List<T> getModulesFromHwModel(Class<T> targetClass, Amalthea model) {
        ArrayList results = new ArrayList();
        for (HwStructure structure : model.getHwModel().getStructures()) {
            HardwareUtil.collectModulesFromHWStructure(structure, targetClass, results);
        }
        return results;
    }

    public static <T extends HwModule> List<T> getModulesFromHWStructure(Class<T> targetClass, HwStructure structure) {
        ArrayList results = new ArrayList();
        HardwareUtil.collectModulesFromHWStructure(structure, targetClass, results);
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends HwModule> void collectModulesFromHWStructure(HwStructure structure, Class<T> targetClass, List<T> results) {
        for (HwModule module : structure.getModules()) {
            void pu;
            HwModule hwModule;
            if (targetClass.isInstance(module)) {
                results.add((HwModule)targetClass.cast(module));
            }
            if (!targetClass.isAssignableFrom(Cache.class) || !((hwModule = module) instanceof ProcessingUnit)) continue;
            ProcessingUnit cfr_ignored_0 = (ProcessingUnit)hwModule;
            ProcessingUnit cfr_ignored_1 = (ProcessingUnit)hwModule;
            for (Cache containedCache : pu.getCaches()) {
                if (!targetClass.isInstance(containedCache)) continue;
                results.add((HwModule)targetClass.cast(containedCache));
            }
        }
        for (HwStructure hwStruct : structure.getStructures()) {
            HardwareUtil.collectModulesFromHWStructure(hwStruct, targetClass, results);
        }
    }

    public static List<ProcessingUnit> getAllProcessingUnitsForProcessingUnitDefinition(Amalthea model, ProcessingUnitDefinition puDef) {
        if (puDef == null) {
            return new ArrayList<ProcessingUnit>();
        }
        ArrayList<ProcessingUnit> result = new ArrayList<ProcessingUnit>();
        for (ProcessingUnit pu : HardwareUtil.getModulesFromHwModel(ProcessingUnit.class, model)) {
            if (!puDef.equals(pu.getDefinition())) continue;
            result.add(pu);
        }
        return result;
    }

    public static Map<Memory, Long> getMemoryAccessLatenciesCycles(Amalthea model, RuntimeUtil.TimeType timeType) {
        HashMap<Memory, Long> result = new HashMap<Memory, Long>();
        List<Memory> mems = HardwareUtil.getModulesFromHwModel(Memory.class, model);
        for (Memory mem : mems) {
            result.put(mem, HardwareUtil.calculateLatency(mem.getDefinition().getAccessLatency(), timeType));
        }
        return result;
    }

    public static Map<Memory, Time> getMemoryAccessLatencyTime(Amalthea model, RuntimeUtil.TimeType timeType) {
        HashMap<Memory, Time> result = new HashMap<Memory, Time>();
        Map<Memory, Long> memoryMap = HardwareUtil.getMemoryAccessLatenciesCycles(model, timeType);
        for (Map.Entry<Memory, Long> entry : memoryMap.entrySet()) {
            Memory memory = entry.getKey();
            double cycles = entry.getValue().floatValue();
            Frequency defaultFrequency = memory.getFrequencyDomain().getDefaultValue();
            Time time = RuntimeUtil.getExecutionTimeForCycles(cycles, defaultFrequency);
            result.put(memory, time);
        }
        return result;
    }

    public static List<HwAccessElement> getAccessElementsToDestination(HwDestination dest, Amalthea model) {
        ArrayList<HwAccessElement> result = new ArrayList<HwAccessElement>();
        List<ProcessingUnit> pus = HardwareUtil.getModulesFromHwModel(ProcessingUnit.class, model);
        for (ProcessingUnit pu : pus) {
            for (HwAccessElement element : pu.getAccessElements()) {
                if (!element.getDestination().equals(dest)) continue;
                result.add(element);
            }
        }
        return result;
    }

    public static Map<ProcessingUnit, HashMap<HwDestination, Time>> getAccessTimes(Amalthea model, RuntimeUtil.TimeType timeType, RuntimeUtil.AccessDirection direction) {
        HashMap<ProcessingUnit, HashMap<HwDestination, Time>> coreMemoryLatency = new HashMap<ProcessingUnit, HashMap<HwDestination, Time>>();
        List<ProcessingUnit> puList = HardwareUtil.getModulesFromHwModel(ProcessingUnit.class, model);
        for (ProcessingUnit pu : puList) {
            HashMap<HwDestination, Time> memoryAccessMap = new HashMap<HwDestination, Time>();
            for (HwAccessElement accessElement : pu.getAccessElements()) {
                HwDestination destination = accessElement.getDestination();
                Time latency = null;
                latency = accessElement.getAccessPath() != null ? HardwareUtil.calculateHwAccessPathTime(accessElement, timeType, direction) : HardwareUtil.calculateLatencyPathTime(accessElement, timeType, direction);
                Time previousLatency = (Time)memoryAccessMap.get(destination);
                if (previousLatency != null && (latency == null || AmaltheaServices.compareTimes(previousLatency, latency) >= 0)) continue;
                memoryAccessMap.put(destination, latency);
            }
            coreMemoryLatency.put(pu, memoryAccessMap);
        }
        return coreMemoryLatency;
    }

    public static Time calculateLatencyPathTime(HwAccessElement accessElement, RuntimeUtil.TimeType timeType, RuntimeUtil.AccessDirection direction) {
        IDiscreteValueDeviation latency = null;
        switch (direction) {
            case READ: {
                if (accessElement.getReadLatency() == null) break;
                latency = accessElement.getReadLatency();
                break;
            }
            case WRITE: {
                if (accessElement.getWriteLatency() == null) break;
                latency = accessElement.getWriteLatency();
                break;
            }
        }
        return RuntimeUtil.getExecutionTimeForCycles(HardwareUtil.calculateLatency(latency, timeType).longValue(), accessElement.getSource().getFrequencyDomain().getDefaultValue());
    }

    /*
     * WARNING - void declaration
     */
    public static Time calculateHwAccessPathTime(HwAccessElement accessElement, RuntimeUtil.TimeType timeType, RuntimeUtil.AccessDirection direction) {
        if (accessElement == null || accessElement.getAccessPath() == null) {
            return null;
        }
        Time result = FactoryUtil.createTime();
        Frequency frequency = null;
        IDiscreteValueDeviation latency = null;
        for (HwPathElement element : accessElement.getAccessPath().getPathElements()) {
            HwPathElement hwPathElement = element;
            if (hwPathElement instanceof ConnectionHandler) {
                void connHandler;
                ConnectionHandler cfr_ignored_0 = (ConnectionHandler)hwPathElement;
                ConnectionHandler cfr_ignored_1 = (ConnectionHandler)hwPathElement;
                latency = HardwareUtil.getLatency((ConnectionHandler)connHandler, direction);
                frequency = HardwareUtil.getFrequencyOfModule((HwModule)connHandler);
            } else {
                HwPathElement hwPathElement2 = element;
                if (hwPathElement2 instanceof Cache) {
                    void cache;
                    Cache cfr_ignored_2 = (Cache)hwPathElement2;
                    Cache cfr_ignored_3 = (Cache)hwPathElement2;
                    latency = HardwareUtil.getLatency((Cache)cache);
                    frequency = HardwareUtil.getFrequencyOfModule((HwModule)cache);
                } else {
                    HwPathElement hwPathElement3 = element;
                    if (hwPathElement3 instanceof HwConnection) {
                        void hwConn;
                        HwConnection cfr_ignored_4 = (HwConnection)hwPathElement3;
                        HwConnection cfr_ignored_5 = (HwConnection)hwPathElement3;
                        latency = HardwareUtil.getLatency((HwConnection)hwConn, direction);
                        if (frequency == null) {
                            frequency = HardwareUtil.getFrequencyOfModule(accessElement.getSource());
                        }
                    } else {
                        HwPathElement hwPathElement4 = element;
                        if (hwPathElement4 instanceof ProcessingUnit) {
                            void pu;
                            ProcessingUnit cfr_ignored_6 = (ProcessingUnit)hwPathElement4;
                            ProcessingUnit cfr_ignored_7 = (ProcessingUnit)hwPathElement4;
                            latency = null;
                            frequency = HardwareUtil.getFrequencyOfModule((HwModule)pu);
                        }
                    }
                }
            }
            Long tmpLatency = HardwareUtil.calculateLatency(latency, timeType);
            Time executionTimeForCycles = RuntimeUtil.getExecutionTimeForCycles(tmpLatency.longValue(), frequency);
            result = result.add(executionTimeForCycles);
        }
        return result.adjustUnit();
    }

    private static IDiscreteValueDeviation getLatency(ConnectionHandler handler, RuntimeUtil.AccessDirection direction) {
        ConnectionHandlerDefinition definition = handler.getDefinition();
        if (definition == null) {
            return null;
        }
        return direction.equals((Object)RuntimeUtil.AccessDirection.READ) ? definition.getReadLatency() : definition.getWriteLatency();
    }

    private static IDiscreteValueDeviation getLatency(Cache cache) {
        CacheDefinition definition = cache.getDefinition();
        if (definition == null) {
            return null;
        }
        return definition.getAccessLatency();
    }

    private static IDiscreteValueDeviation getLatency(HwConnection connection, RuntimeUtil.AccessDirection direction) {
        return direction.equals((Object)RuntimeUtil.AccessDirection.READ) ? connection.getReadLatency() : connection.getWriteLatency();
    }

    public static Long calculateLatency(IDiscreteValueDeviation latency, RuntimeUtil.TimeType timeType) {
        if (latency == null) {
            return 0L;
        }
        switch (timeType) {
            case BCET: {
                return latency.getLowerBound();
            }
            case ACET: {
                return latency.getAverage() != null ? Long.valueOf(latency.getAverage().longValue()) : null;
            }
            case WCET: {
                return latency.getUpperBound();
            }
        }
        return latency.getAverage() != null ? Long.valueOf(latency.getAverage().longValue()) : null;
    }

    /*
     * WARNING - void declaration
     */
    public static DataRate getMinDataRateOfHwAccessPath(HwAccessPath path) {
        if (path == null) {
            return null;
        }
        DataRate minimum = null;
        for (HwPathElement element : path.getPathElements()) {
            DataRate dataRate = null;
            HwPathElement hwPathElement = element;
            if (hwPathElement instanceof ConnectionHandler) {
                void connHandler;
                ConnectionHandler cfr_ignored_0 = (ConnectionHandler)hwPathElement;
                ConnectionHandler cfr_ignored_1 = (ConnectionHandler)hwPathElement;
                dataRate = connHandler.getDefinition().getDataRate();
            } else {
                HwPathElement hwPathElement2 = element;
                if (hwPathElement2 instanceof HwConnection) {
                    void hwConn;
                    HwConnection cfr_ignored_2 = (HwConnection)hwPathElement2;
                    HwConnection cfr_ignored_3 = (HwConnection)hwPathElement2;
                    dataRate = hwConn.getDataRate();
                }
            }
            if (dataRate == null || minimum != null && AmaltheaServices.compareDataRates(dataRate, minimum) >= 0) continue;
            minimum = dataRate;
        }
        return minimum;
    }

    public static Frequency getFrequencyOfModule(HwModule module) {
        return module.getFrequencyDomain().getDefaultValue();
    }

    public static long getFrequencyOfModuleInHz(HwModule module) {
        Frequency frequencyOfModule = HardwareUtil.getFrequencyOfModule(module);
        if (frequencyOfModule == null) {
            return 0L;
        }
        return AmaltheaServices.convertToHertz(frequencyOfModule).longValue();
    }
}

