/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.application;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.EnvironmentVariable;
import org.eclipse.cft.server.core.internal.ApplicationUrlLookupService;
import org.eclipse.cft.server.core.internal.CloudApplicationURL;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryProjectUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Logger;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.DeploymentInfoWorkingCopy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class ManifestParser {
    private final String relativePath;
    private final CloudFoundryApplicationModule appModule;
    private final CloudFoundryServer cloudServer;
    public static final String DEFAULT = "manifest.yml";

    public ManifestParser(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        this(DEFAULT, appModule, cloudServer);
    }

    public ManifestParser(String relativePath, CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        Assert.isNotNull((Object)relativePath);
        this.relativePath = relativePath;
        this.appModule = appModule;
        this.cloudServer = cloudServer;
    }

    private IFile getFile() {
        IProject project = CloudFoundryProjectUtil.getProject(this.appModule);
        if (project == null) {
            return null;
        }
        IFile resource = project.getFile(this.relativePath);
        return resource;
    }

    public boolean hasManifest() {
        IFile file = this.getFile();
        return file != null && file.exists();
    }

    public boolean canWriteToManifest() {
        return CloudFoundryProjectUtil.getProject(this.appModule) != null;
    }

    public String getApplicationProperty(String applicationName, String propertyName) {
        try {
            Map<?, ?> map = this.getApplication(applicationName);
            if (map != null) {
                return this.getStringValue(map, propertyName);
            }
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
        }
        return null;
    }

    protected Map<?, ?> getContainingPropertiesMap(Map<?, ?> containerMap, String propertyName) {
        if (containerMap == null || propertyName == null) {
            return null;
        }
        Object yamlElementObj = containerMap.get(propertyName);
        if (yamlElementObj instanceof Map) {
            return (Map)yamlElementObj;
        }
        return null;
    }

    protected String getStringValue(Map<?, ?> containingMap, String propertyName) {
        if (containingMap == null) {
            return null;
        }
        Object valObj = containingMap.get(propertyName);
        if (valObj instanceof String) {
            return (String)valObj;
        }
        return null;
    }

    protected Integer getIntegerValue(Map<?, ?> containingMap, String propertyName) {
        if (containingMap == null) {
            return null;
        }
        Object valObj = containingMap.get(propertyName);
        if (valObj instanceof Integer) {
            return (Integer)valObj;
        }
        return null;
    }

    protected Map<?, ?> getApplication(String applicationName) throws CoreException {
        Map<Object, Object> results = this.parseManifestFromFile();
        if (results == null) {
            return null;
        }
        Object applicationsObj = results.get("applications");
        if (!(applicationsObj instanceof List)) {
            throw CloudErrorUtil.toCoreException("Expected a top-level list of applications in: " + this.relativePath + ". Unable to continue parsing manifest values. No manifest values will be loaded into the application deployment info.");
        }
        List applicationsList = (List)applicationsObj;
        if (applicationsList.isEmpty()) {
            return null;
        }
        Map application = null;
        String errorMessage = null;
        if (applicationName == null) {
            Object mapObj = applicationsList.get(0);
            Map map = application = mapObj instanceof Map ? (Map)mapObj : null;
            if (application == null) {
                errorMessage = "Expected a map of application properties in: " + this.relativePath + ". Unable to continue parsing manifest values. No manifest values will be loaded into the application deployment info.";
            }
        } else {
            for (Object mapObj : applicationsList) {
                if (!(mapObj instanceof Map)) continue;
                application = (Map)mapObj;
                String appName = this.getStringValue(application, "name");
                if (applicationName.equals(appName)) break;
                application = null;
            }
        }
        if (this.getStringValue(application, "inherit") != null) {
            Logger.println("/debug/warning", this, "load", "Manifest file entry inherit is not support. The inherit entry will be ignored during deployment: " + this.relativePath);
        }
        if (errorMessage != null) {
            throw CloudErrorUtil.toCoreException(errorMessage);
        }
        return application;
    }

    public DeploymentInfoWorkingCopy load(IProgressMonitor monitor) throws CoreException {
        DeploymentInfoWorkingCopy workingCopy;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.beginTask(NLS.bind((String)Messages.ManifestParser_READING, (Object)this.appModule.getDeployedApplicationName()), 6);
        try {
            workingCopy = this.appModule.resolveDeploymentInfoWorkingCopy((IProgressMonitor)subMonitor);
            Map<?, ?> application = this.getApplication(null);
            subMonitor.worked(1);
            if (application == null) {
                return null;
            }
            HashMap applicationClone = new HashMap();
            applicationClone.putAll(application);
            applicationClone.remove("memory");
            applicationClone.remove("disk_quota");
            applicationClone.remove("host");
            applicationClone.remove("domain");
            applicationClone.remove("env");
            applicationClone.remove("services");
            workingCopy.addAllToDeploymentMap(applicationClone);
            String appName = this.getStringValue(application, "name");
            subMonitor.worked(1);
            if (appName == null) {
                CloudFoundryPlugin.logError(Messages.ManifestParser_NO_APP_NAME);
            }
            this.readMemory(application, workingCopy);
            subMonitor.worked(1);
            this.readDiskQuota(application, workingCopy);
            subMonitor.worked(1);
            this.readApplicationURL(application, workingCopy, appName, monitor);
            subMonitor.worked(1);
            this.readEnvars(workingCopy, application);
            subMonitor.worked(1);
            this.readServices(workingCopy, application);
            subMonitor.worked(1);
        }
        finally {
            subMonitor.done();
        }
        return workingCopy;
    }

    protected void readEnvars(DeploymentInfoWorkingCopy workingCopy, Map<?, ?> applications) {
        Map<?, ?> propertiesMap = this.getContainingPropertiesMap(applications, "env");
        if (propertiesMap == null) {
            return;
        }
        ArrayList<EnvironmentVariable> variables = new ArrayList<EnvironmentVariable>();
        for (Map.Entry<?, ?> entry : propertiesMap.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String varName = (String)entry.getKey();
            String varValue = (String)entry.getValue();
            if (varName == null || varValue == null) continue;
            EnvironmentVariable variable = new EnvironmentVariable();
            variable.setVariable(varName);
            variable.setValue(varValue);
            variables.add(variable);
        }
        workingCopy.setEnvVariables(variables);
    }

    protected void readServices(DeploymentInfoWorkingCopy workingCopy, Map<?, ?> applications) {
        Map<?, ?> services = this.getContainingPropertiesMap(applications, "services");
        if (services != null) {
            LinkedHashMap<String, CFServiceInstance> servicesToBind = new LinkedHashMap<String, CFServiceInstance>();
            for (Map.Entry<?, ?> entry : services.entrySet()) {
                String plan;
                String version;
                String serviceName;
                Object serviceNameObj = entry.getKey();
                if (!(serviceNameObj instanceof String) || servicesToBind.containsKey(serviceName = (String)serviceNameObj)) continue;
                CFServiceInstance service = new CFServiceInstance(serviceName);
                servicesToBind.put(serviceName, service);
                Object servicePropertiesObj = entry.getValue();
                if (!(servicePropertiesObj instanceof Map)) continue;
                Map serviceProperties = (Map)servicePropertiesObj;
                String label = this.getStringValue(serviceProperties, "label");
                if (label != null) {
                    service.setService(label);
                }
                if ((version = this.getStringValue(serviceProperties, "version")) != null) {
                    service.setVersion(version);
                }
                if ((plan = this.getStringValue(serviceProperties, "plan")) == null) continue;
                service.setPlan(plan);
            }
            workingCopy.setServices(new ArrayList<CFServiceInstance>(servicesToBind.values()));
        } else {
            Object yamlElementObj = applications.get("services");
            if (yamlElementObj instanceof List) {
                List servListFromYaml = (List)yamlElementObj;
                HashSet<String> addedService = new HashSet<String>();
                ArrayList<CFServiceInstance> cloudServices = new ArrayList<CFServiceInstance>();
                for (Object servNameObj : servListFromYaml) {
                    if (!(servNameObj instanceof String) || addedService.contains(servNameObj)) continue;
                    String serviceName = (String)servNameObj;
                    addedService.add(serviceName);
                    cloudServices.add(new CFServiceInstance(serviceName));
                }
                workingCopy.setServices(cloudServices);
            }
        }
    }

    protected void readApplicationURL(Map<?, ?> application, DeploymentInfoWorkingCopy workingCopy, String appName, IProgressMonitor monitor) {
        String subdomain = this.getStringValue(application, "host");
        String domain = this.getStringValue(application, "domain");
        if (subdomain == null && domain == null && appName == null) {
            return;
        }
        CloudApplicationURL cloudURL = null;
        try {
            ApplicationUrlLookupService urlLookup = ApplicationUrlLookupService.update(this.cloudServer, monitor);
            if (subdomain == null && appName != null) {
                subdomain = appName.replace(".", "");
            }
            if (domain == null) {
                cloudURL = urlLookup.getDefaultApplicationURL(subdomain);
            } else {
                cloudURL = new CloudApplicationURL(subdomain, domain);
                cloudURL = urlLookup.validateCloudApplicationUrl(cloudURL);
            }
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
        }
        if (cloudURL != null) {
            List<String> urls = Arrays.asList(cloudURL.getUrl());
            workingCopy.setUris(urls);
        }
    }

    protected void readMemory(Map<?, ?> application, DeploymentInfoWorkingCopy workingCopy) {
        String memoryStringVal;
        Integer memoryVal = this.getIntegerValue(application, "memory");
        if (memoryVal == null && (memoryStringVal = this.getStringValue(application, "memory")) != null && memoryStringVal.length() > 0) {
            char[] memoryIndicator = new char[]{'M', 'G', 'm', 'g'};
            int gIndex = -1;
            char[] cArray = memoryIndicator;
            int n = memoryIndicator.length;
            int n2 = 0;
            while (n2 < n) {
                char indicator = cArray[n2];
                gIndex = memoryStringVal.indexOf(indicator);
                if (gIndex >= 0) break;
                ++n2;
            }
            if (gIndex > 0) {
                memoryStringVal = memoryStringVal.substring(0, gIndex);
            } else if (gIndex == 0) {
                CloudFoundryPlugin.logError("Failed to read memory value in manifest file: " + this.relativePath + " for: " + this.appModule.getDeployedApplicationName() + ". Invalid memory: " + memoryStringVal);
            }
            try {
                memoryVal = Integer.valueOf(memoryStringVal);
            }
            catch (NumberFormatException e) {
                CloudFoundryPlugin.logError("Failed to parse memory from manifest file: " + this.relativePath + " for: " + this.appModule.getDeployedApplicationName() + " due to: " + e.getMessage());
            }
        }
        if (memoryVal != null) {
            int actualMemory = -1;
            switch (memoryVal) {
                case 1: {
                    actualMemory = 1024;
                    break;
                }
                case 2: {
                    actualMemory = 2048;
                    break;
                }
                default: {
                    actualMemory = memoryVal;
                }
            }
            if (actualMemory > 0) {
                workingCopy.setMemory(actualMemory);
            }
        }
    }

    protected void readDiskQuota(Map<?, ?> application, DeploymentInfoWorkingCopy workingCopy) {
        String diskQuotaStringVal;
        Integer diskQuotaVal = this.getIntegerValue(application, "disk_quota");
        if (diskQuotaVal == null && (diskQuotaStringVal = this.getStringValue(application, "disk_quota")) != null && diskQuotaStringVal.length() > 0) {
            char[] diskQuotaIndicator = new char[]{'M', 'G', 'm', 'g'};
            int gIndex = -1;
            char[] cArray = diskQuotaIndicator;
            int n = diskQuotaIndicator.length;
            int n2 = 0;
            while (n2 < n) {
                char indicator = cArray[n2];
                gIndex = diskQuotaStringVal.indexOf(indicator);
                if (gIndex >= 0) break;
                ++n2;
            }
            if (gIndex > 0) {
                diskQuotaStringVal = diskQuotaStringVal.substring(0, gIndex);
            } else if (gIndex == 0) {
                CloudFoundryPlugin.logError("Failed to disk quota value in manifest file: " + this.relativePath + " for: " + this.appModule.getDeployedApplicationName() + ". Invalid disk quota: " + diskQuotaStringVal);
            }
            try {
                diskQuotaVal = Integer.valueOf(diskQuotaStringVal);
            }
            catch (NumberFormatException e) {
                CloudFoundryPlugin.logError("Failed to disk quota memory from manifest file: " + this.relativePath + " for: " + this.appModule.getDeployedApplicationName() + " due to: " + e.getMessage());
            }
        }
        if (diskQuotaVal != null) {
            int actualDiskQuota = -1;
            switch (diskQuotaVal) {
                case 1: {
                    actualDiskQuota = 1024;
                    break;
                }
                case 2: {
                    actualDiskQuota = 2048;
                    break;
                }
                default: {
                    actualDiskQuota = diskQuotaVal;
                }
            }
            if (actualDiskQuota > 0) {
                workingCopy.setDiskQuota(actualDiskQuota);
            }
        }
    }

    protected Map<Object, Object> parseManifestFromFile() throws CoreException {
        InputStream inputStream = null;
        IFile resource = this.getFile();
        if (resource != null && resource.exists()) {
            inputStream = resource.getContents();
        }
        if (inputStream != null) {
            Object results;
            block9: {
                Map map;
                Yaml yaml = new Yaml();
                try {
                    results = yaml.load(inputStream);
                    if (!(results instanceof Map)) break block9;
                    map = (Map)results;
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                return map;
            }
            throw CloudErrorUtil.toCoreException("Expected a map of values for manifest file: " + this.relativePath + ". Unable to load manifest content.  Actual results: " + results);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean write(IProgressMonitor monitor, ApplicationDeploymentInfo previousInfo) throws CoreException {
        ApplicationDeploymentInfo deploymentInfo = this.appModule.getDeploymentInfo();
        if (deploymentInfo == null) {
            return false;
        }
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)monitor);
        subProgress.beginTask(NLS.bind((String)Messages.ManifestParser_WRITING, (Object)this.appModule.getDeployedApplicationName()), 5);
        try {
            List<CFServiceInstance> servicesToBind;
            String archiveURL;
            List<EnvironmentVariable> envvars;
            List<String> urls;
            int instances;
            String diskQuota;
            Integer diskQuotaInt;
            void var12_17;
            Map map;
            String previousName = previousInfo != null ? previousInfo.getDeploymentName() : null;
            String appName = deploymentInfo.getDeploymentName();
            Map<Object, Object> deploymentInfoYaml = null;
            try {
                deploymentInfoYaml = this.parseManifestFromFile();
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logWarning(e.getMessage());
            }
            subProgress.worked(1);
            if (deploymentInfoYaml == null) {
                deploymentInfoYaml = new LinkedHashMap<Object, Object>();
            }
            Object applicationsObj = deploymentInfoYaml.get("applications");
            List applicationsList = null;
            if (applicationsObj == null) {
                applicationsList = new ArrayList();
                deploymentInfoYaml.put("applications", applicationsList);
            } else if (applicationsObj instanceof List) {
                applicationsList = (List)applicationsObj;
            } else {
                throw CloudErrorUtil.toCoreException("Expected a top-level list of applications in: " + this.relativePath + ". Unable to continue writing manifest values.");
            }
            Map applicationWithSameName = null;
            Map oldApplication = null;
            for (Object e : applicationsList) {
                if (!(e instanceof Map)) continue;
                Map properties = (Map)e;
                String name = this.getStringValue(properties, "name");
                if (appName.equals(name)) {
                    applicationWithSameName = properties;
                    continue;
                }
                if (previousName == null || !previousName.equals(name)) continue;
                oldApplication = properties;
            }
            Map map2 = map = oldApplication != null ? oldApplication : applicationWithSameName;
            if (map == null) {
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                applicationsList.add(linkedHashMap);
            }
            var12_17.put("name", appName);
            String memory = this.getMemoryAsString(deploymentInfo.getMemory());
            if (memory != null) {
                var12_17.put("memory", memory);
            }
            if ((diskQuotaInt = deploymentInfo.getDiskQuota()) != null && (diskQuota = this.getMemoryAsString(diskQuotaInt)) != null) {
                var12_17.put("disk_quota", diskQuota);
            }
            if ((instances = deploymentInfo.getInstances()) > 0) {
                var12_17.put("instances", instances);
            }
            if ((urls = deploymentInfo.getUris()) != null && !urls.isEmpty()) {
                String url = urls.get(0);
                ApplicationUrlLookupService lookup = ApplicationUrlLookupService.getCurrentLookup(this.cloudServer);
                CloudApplicationURL cloudUrl = lookup.getCloudApplicationURL(url);
                String subdomain = cloudUrl.getSubdomain();
                String domain = cloudUrl.getDomain();
                if (subdomain != null) {
                    var12_17.put("host", subdomain);
                }
                if (domain != null) {
                    var12_17.put("domain", domain);
                }
            } else {
                var12_17.remove("host");
                var12_17.remove("domain");
            }
            if ((envvars = deploymentInfo.getEnvVariables()) != null && !envvars.isEmpty()) {
                LinkedHashMap<String, String> varMap = new LinkedHashMap<String, String>();
                var12_17.put("env", varMap);
                for (EnvironmentVariable var : envvars) {
                    varMap.put(var.getVariable(), var.getValue());
                }
            } else {
                var12_17.remove("env");
            }
            String buildpack = deploymentInfo.getBuildpack();
            if (buildpack != null) {
                var12_17.put("buildpack", buildpack);
            }
            if ((archiveURL = deploymentInfo.getArchive()) != null) {
                var12_17.put("path", archiveURL);
            }
            if ((servicesToBind = deploymentInfo.getServices()) != null && !servicesToBind.isEmpty()) {
                ArrayList<String> services = new ArrayList<String>();
                var12_17.put("services", services);
                for (CFServiceInstance service : servicesToBind) {
                    String serviceName = service.getName();
                    if (serviceName == null || services.contains(serviceName)) continue;
                    services.add(serviceName);
                }
            } else {
                var12_17.remove("services");
            }
            HashMap<Object, Object> curUnknownInfo = deploymentInfo.getUnknownInfo();
            var12_17.putAll(curUnknownInfo);
            if (!curUnknownInfo.containsKey("stack")) {
                var12_17.remove("stack");
            }
            subProgress.worked(1);
            if (deploymentInfoYaml.isEmpty()) {
                return false;
            }
            DumperOptions options = new DumperOptions();
            options.setExplicitStart(true);
            options.setCanonical(false);
            options.setPrettyFlow(true);
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(options);
            String manifestValue = yaml.dump(deploymentInfoYaml);
            subProgress.worked(1);
            if (manifestValue == null) {
                throw CloudErrorUtil.toCoreException("Manifest map for " + this.appModule.getDeployedApplicationName() + " contained values but yaml parser failed to serialise the map. : " + deploymentInfoYaml);
            }
            IFile file = this.getFile();
            if (file != null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(manifestValue.getBytes());
                if (file.exists()) {
                    file.delete(true, (IProgressMonitor)subProgress);
                }
                file.create((InputStream)bais, true, (IProgressMonitor)subProgress);
                subProgress.worked(1);
                this.refreshProject(monitor);
                subProgress.worked(1);
                return true;
            }
            throw CloudErrorUtil.toCoreException("No changes could be written to: " + this.relativePath + ". Unable to write changes to the application's manifest file for: " + this.appModule.getDeployedApplicationName());
        }
        finally {
            subProgress.done();
        }
    }

    protected String getMemoryAsString(int memory) {
        if (memory < 1) {
            return null;
        }
        return String.valueOf(memory) + "M";
    }

    protected void refreshProject(IProgressMonitor monitor) throws CoreException {
        IProject project = CloudFoundryProjectUtil.getProject(this.appModule);
        if (project != null && project.isAccessible()) {
            project.refreshLocal(2, monitor);
        }
    }
}

