/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.naming.ResourceLinkRef;

public class ResourceLinkFactory
implements ObjectFactory {
    private static Context globalContext = null;
    private static Map<ClassLoader, Map<String, String>> globalResourceRegistrations = new ConcurrentHashMap<ClassLoader, Map<String, String>>();

    public static void setGlobalContext(Context newGlobalContext) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(ResourceLinkFactory.class.getName() + ".setGlobalContext"));
        }
        globalContext = newGlobalContext;
    }

    public static void registerGlobalResourceAccess(Context globalContext, String localName, String globalName) {
        ResourceLinkFactory.validateGlobalContext(globalContext);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Map<String, String> registrations = globalResourceRegistrations.get(cl);
        if (registrations == null) {
            registrations = new HashMap<String, String>();
            globalResourceRegistrations.put(cl, registrations);
        }
        registrations.put(localName, globalName);
    }

    public static void deregisterGlobalResourceAccess(Context globalContext, String localName) {
        ResourceLinkFactory.validateGlobalContext(globalContext);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Map<String, String> registrations = globalResourceRegistrations.get(cl);
        if (registrations != null) {
            registrations.remove(localName);
        }
    }

    public static void deregisterGlobalResourceAccess(Context globalContext) {
        ResourceLinkFactory.validateGlobalContext(globalContext);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        globalResourceRegistrations.remove(cl);
    }

    private static void validateGlobalContext(Context globalContext) {
        if (ResourceLinkFactory.globalContext != null && ResourceLinkFactory.globalContext != globalContext) {
            throw new SecurityException("Caller provided invalid global context");
        }
    }

    private static boolean validateGlobalResourceAccess(String globalName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Map<String, String> registrations = globalResourceRegistrations.get(cl);
        return registrations != null && registrations.containsValue(globalName);
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws NamingException {
        if (!(obj instanceof ResourceLinkRef)) {
            return null;
        }
        Reference ref = (Reference)obj;
        String globalName = null;
        RefAddr refAddr = ref.get("globalName");
        if (refAddr != null) {
            globalName = refAddr.getContent().toString();
            if (!ResourceLinkFactory.validateGlobalResourceAccess(globalName)) {
                return null;
            }
            Object result = null;
            result = globalContext.lookup(globalName);
            String expectedClassName = ref.getClassName();
            try {
                Class<?> expectedClazz = Class.forName(expectedClassName, true, Thread.currentThread().getContextClassLoader());
                if (!expectedClazz.isAssignableFrom(result.getClass())) {
                    throw new IllegalArgumentException();
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            return result;
        }
        return null;
    }
}

