/*
 * Copyright (c) 2022 The Bank of New York Mellon.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;

import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.impl.set.mutable.AbstractMutableSet;

/**
 * A boxed view of a {@link MutableCharSet}.
 *
 * This is for scenarios where optimization is not a consideration and therefore no further methods will be optimized.
 * <p>
 * This file was automatically generated from template file  boxedPrimitiveSet.stg.
 *
 * @since 12.0
 */
public class BoxedMutableCharSet extends AbstractMutableSet<Character>
        implements MutableSet<Character>
{
    private final MutableCharSet delegate;

    public BoxedMutableCharSet(MutableCharSet delegate)
    {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public int size()
    {
        return this.delegate.size();
    }

    @Override
    public Character getFirst()
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public Character getLast()
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void each(Procedure<? super Character> procedure)
    {
        this.delegate.each(procedure::value);
    }

    @Override
    public boolean add(Character item)
    {
        return this.delegate.add(item.charValue());
    }

    @Override
    public boolean contains(Object object)
    {
        return object instanceof Character && this.delegate.contains(((Character) object).charValue());
    }

    @Override
    public boolean remove(Object object)
    {
        return object instanceof Character && this.delegate.remove(((Character) object).charValue());
    }

    @Override
    public void clear()
    {
        this.delegate.clear();
    }

    @Override
    public ParallelUnsortedSetIterable<Character> asParallel(ExecutorService executorService, int batchSize)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }

        if (!(object instanceof Set))
        {
            return false;
        }

        Set<?> other = (Set<?>) object;
        return this.size() == other.size() && this.containsAll(other);
    }

    @Override
    public Iterator<Character> iterator()
    {
        return new BoxedPrimitiveCharSetIterator(this.delegate.charIterator());
    }

    private static final class BoxedPrimitiveCharSetIterator implements Iterator<Character>
    {
        private final MutableCharIterator delegate;

        private BoxedPrimitiveCharSetIterator(MutableCharIterator iterator)
        {
            this.delegate = iterator;
        }

        @Override
        public boolean hasNext()
        {
            return this.delegate.hasNext();
        }

        @Override
        public Character next()
        {
            return this.delegate.next();
        }
    }
}
