/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains implementations of {@link org.eclipse.collections.api.set.sorted.MutableSortedSet}.
 * <p>
 *     This package contains 4 sorted mutable set implementation:
 * <ul>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.sorted.mutable.SortedSetAdapter} -  a class which provides a MutableSortedSet wrapper around a JDK Collections SortedSet interface instance.
 *     </li>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.sorted.mutable.SynchronizedSortedSet} -  a synchronized view of a SortedSet.
 *     </li>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.sorted.mutable.TreeSortedSet} - a sorted set backed by Tree data structure..
 *     </li>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.sorted.mutable.UnmodifiableSortedSet} -  an unmodifiable view of a SortedSet.
 *     </li>
 * </ul>
 * <p>
 *     This package contains 1 factory implementation:
 * <ul>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.sorted.mutable.MutableSortedSetFactoryImpl} - a factory which creates instances of type {@link org.eclipse.collections.api.set.sorted.MutableSortedSet}.
 *     </li>
 * </ul>
 */
package org.eclipse.collections.impl.set.sorted.mutable;
