/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.launching;

import java.sql.Connection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.core.services.SQLEditorService;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionTracker;
import org.eclipse.datatools.sqltools.launching.IExtendedLaunchSupport;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.datatools.sqltools.routineeditor.launching.Messages;
import org.eclipse.datatools.sqltools.routineeditor.launching.SPDebugTarget_Run;
import org.eclipse.datatools.sqltools.routineeditor.result.CallableSQLResultRunnable;
import org.eclipse.datatools.sqltools.routineeditor.ui.RoutineEditorUIActivator;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.SPLaunchShortcut;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.internal.SaveRoutineStatusHandler;
import org.eclipse.datatools.sqltools.sqleditor.result.SimpleSQLResultRunnable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SPLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public void launch_run(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask(Messages.SPLaunchConfigurationDelegate_Launching, 3);
        }
        try {
            Runnable postrun = null;
            DatabaseIdentifier databaseIdentifier = LaunchHelper.readDatabaseIdentifier((ILaunchConfiguration)configuration);
            String externalId = LaunchHelper.readExternalClientId((ILaunchConfiguration)configuration);
            if (externalId != null && !externalId.equals("")) {
                return;
            }
            if (monitor != null) {
                monitor.subTask(Messages.SPLaunchConfigurationDelegate_CreatingClientConn);
            }
            IControlConnection controlCon = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(databaseIdentifier);
            SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByProfileName((String)databaseIdentifier.getProfileName());
            ConnectionService conService = f.getConnectionService();
            Connection debuggeeCon = conService.createConnection(controlCon.getDatabaseIdentifier().getProfileName(), controlCon.getDatabaseIdentifier().getDBname());
            IExtendedLaunchSupport extendedLaunchSupport = null;
            SQLEditorService s = SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)databaseIdentifier).getSQLEditorService();
            if (s != null) {
                extendedLaunchSupport = s.getExtendedLaunchSupport();
            }
            if (extendedLaunchSupport != null) {
                extendedLaunchSupport.preLaunch(configuration, debuggeeCon, mode);
            }
            monitor.worked(1);
            if (monitor != null) {
                monitor.subTask(Messages.SPLaunchConfigurationDelegate_AttachingConn);
            }
            SPDebugTarget_Run target = new SPDebugTarget_Run(launch, null, databaseIdentifier.getProfileName(), debuggeeCon);
            ProcIdentifier proc = LaunchHelper.readProcIdentifier((ILaunchConfiguration)configuration);
            if (proc == null) {
                postrun = f.getExecutionService().createAdHocScriptRunnable(debuggeeCon, LaunchHelper.constructDirectInvocationSQLString((ILaunchConfiguration)configuration), true, (IConnectionTracker)target, null, databaseIdentifier, configuration, null);
                if (postrun == null) {
                    postrun = new SimpleSQLResultRunnable(debuggeeCon, LaunchHelper.constructDirectInvocationSQLString((ILaunchConfiguration)configuration), true, (IConnectionTracker)target, null, databaseIdentifier, configuration);
                }
            } else {
                switch (proc.getType()) {
                    case 0: {
                        postrun = f.getExecutionService().createStoredProcedureRunnable(debuggeeCon, configuration, true, (IConnectionTracker)target, databaseIdentifier);
                        if (postrun != null) break;
                        postrun = new CallableSQLResultRunnable(debuggeeCon, configuration, true, (IConnectionTracker)target, databaseIdentifier);
                        break;
                    }
                    case 1: {
                        postrun = f.getExecutionService().createFunctionRunnable(debuggeeCon, LaunchHelper.constructDirectInvocationSQLString((ILaunchConfiguration)configuration), true, (IConnectionTracker)target, null, databaseIdentifier, configuration, null);
                        if (postrun != null) break;
                        postrun = new SimpleSQLResultRunnable(debuggeeCon, LaunchHelper.constructDirectInvocationSQLString((ILaunchConfiguration)configuration), true, (IConnectionTracker)target, null, databaseIdentifier, configuration);
                        break;
                    }
                    default: {
                        postrun = f.getExecutionService().createAdHocScriptRunnable(debuggeeCon, LaunchHelper.constructDirectInvocationSQLString((ILaunchConfiguration)configuration), true, (IConnectionTracker)target, null, databaseIdentifier, configuration, null);
                        if (postrun != null) break;
                        postrun = new SimpleSQLResultRunnable(debuggeeCon, LaunchHelper.constructDirectInvocationSQLString((ILaunchConfiguration)configuration), true, (IConnectionTracker)target, null, databaseIdentifier, configuration);
                    }
                }
            }
            monitor.worked(1);
            launch.addDebugTarget((IDebugTarget)target);
            new Thread(postrun).start();
            if (monitor != null) {
                monitor.done();
            }
        }
        catch (Exception ex) {
            RoutineEditorUIActivator.getDefault().log(ex);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.sqltools.routineeditor.ui", 0, ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        DatabaseIdentifier databaseIdentifier;
        try {
            databaseIdentifier = LaunchHelper.readDatabaseIdentifier((ILaunchConfiguration)configuration);
            if (ProfileUtil.connectProfile((String)databaseIdentifier.getProfileName()) == null) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        try {
            IConnectionProfile profile;
            SaveRoutineStatusHandler handler;
            Boolean status;
            if (launch.getAttribute("LAUNCH_VIA_SHORTCUT") == null && !(status = (Boolean)(handler = new SaveRoutineStatusHandler()).handleStatus(SPLaunchShortcut.PROMPT_STATUS, profile = ProfileUtil.getProfile((String)(databaseIdentifier = LaunchHelper.readDatabaseIdentifier((ILaunchConfiguration)configuration)).getProfileName()))).booleanValue()) {
                return;
            }
        }
        catch (Exception e) {
            RoutineEditorUIActivator.getDefault().log(e);
        }
        if ("run".equals(mode)) {
            this.launch_run(configuration, mode, launch, monitor);
        } else {
            boolean supportsDebugging = false;
            try {
                DatabaseIdentifier databaseIdentifier2 = LaunchHelper.readDatabaseIdentifier((ILaunchConfiguration)configuration);
                IControlConnection controlCon = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(databaseIdentifier2);
                supportsDebugging = controlCon.supportsDebugging();
            }
            catch (Exception e) {
                RoutineEditorUIActivator.getDefault().log(e);
            }
            if (supportsDebugging) {
                IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
                IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(RoutineEditorActivator.PLUGIN_ID, "launchConfigurationTypes");
                IExtension[] extensions = extensionPoint.getExtensions();
                if (extensionPoint != null) {
                    int i = 0;
                    while (i < extensions.length) {
                        IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                        int j = 0;
                        while (j < configElements.length) {
                            if (configElements[j].getName().equals("launchConfigurationType")) {
                                String modesStr = configElements[j].getAttribute("modes");
                                String[] modes = modesStr.split(",");
                                int k = 0;
                                while (k < modes.length) {
                                    if (mode.equals(modes[k])) {
                                        try {
                                            ILaunchConfigurationDelegate delegate = (ILaunchConfigurationDelegate)configElements[j].createExecutableExtension("delegate");
                                            delegate.launch(configuration, mode, launch, monitor);
                                            return;
                                        }
                                        catch (CoreException e) {
                                            RoutineEditorUIActivator.getDefault().log(e);
                                            final CoreException e1 = e;
                                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                                public void run() {
                                                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.common_error, (String)e1.getMessage());
                                                }
                                            });
                                            return;
                                        }
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.common_error, (String)Messages.SPLaunchConfigurationDelegate_notsupported);
                }
            });
        }
    }
}

