/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.input;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.input.ISQLBuilderEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.input.ISQLBuilderEditorInputUsageOptions;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IOmitSchemaInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ISQLStatementInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IWindowStateInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.OmitSchemaInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

public class SQLBuilderEditorInput
implements ISQLBuilderEditorInput {
    private ISQLEditorConnectionInfo _connectionInfo;
    private ISQLStatementInfo _sqlStatementInfo;
    private IOmitSchemaInfo _omitSchemaInfo;
    private IWindowStateInfo _windowStateInfo;
    private ISQLBuilderEditorInputUsageOptions _inputUsageOptions;
    protected int _statementType = 0;

    public SQLBuilderEditorInput(ISQLEditorConnectionInfo connectionInfo, int statementType) {
        this(connectionInfo, null, null);
        this._statementType = statementType;
    }

    public SQLBuilderEditorInput(IConnectionProfile connectionProfile, int statementType) {
        this(connectionProfile, null, null);
        this._statementType = statementType;
    }

    public SQLBuilderEditorInput(ISQLEditorConnectionInfo connectionInfo, ISQLStatementInfo sqlStatementInfo) {
        this(connectionInfo, sqlStatementInfo, null);
    }

    public SQLBuilderEditorInput(IConnectionProfile connectionProfile, ISQLStatementInfo sqlStatementInfo) {
        this(connectionProfile, sqlStatementInfo, null);
    }

    public SQLBuilderEditorInput(ISQLEditorConnectionInfo connectionInfo, ISQLStatementInfo sqlStatementInfo, IOmitSchemaInfo omitSchemaInfo) {
        this._connectionInfo = connectionInfo;
        this._sqlStatementInfo = sqlStatementInfo;
        if (omitSchemaInfo != null) {
            this._omitSchemaInfo = omitSchemaInfo;
        } else {
            this._omitSchemaInfo = new OmitSchemaInfo();
            this._omitSchemaInfo.initFromPreferences();
        }
    }

    public SQLBuilderEditorInput(IConnectionProfile connectionProfile, ISQLStatementInfo sqlStatementInfo, IOmitSchemaInfo omitSchemaInfo) {
        this._connectionInfo = new SQLBuilderConnectionInfo(connectionProfile);
        this._sqlStatementInfo = sqlStatementInfo;
        if (omitSchemaInfo != null) {
            this._omitSchemaInfo = omitSchemaInfo;
        } else {
            this._omitSchemaInfo = new OmitSchemaInfo();
            this._omitSchemaInfo.initFromPreferences();
        }
    }

    @Override
    public ISQLEditorConnectionInfo getConnectionInfo() {
        return this._connectionInfo;
    }

    @Override
    public void setConnectionInfo(ISQLEditorConnectionInfo connInfo) {
        this._connectionInfo = connInfo == null ? SQLEditorConnectionInfo.DEFAULT_SQLEDITOR_CONNECTION_INFO : connInfo;
    }

    public IConnectionProfile getConnectionProfile() {
        if (this._connectionInfo != null) {
            return this._connectionInfo.getConnectionProfile();
        }
        return null;
    }

    public void setConnectionProfile(IConnectionProfile connProfile) {
        this._connectionInfo = connProfile == null ? SQLEditorConnectionInfo.DEFAULT_SQLEDITOR_CONNECTION_INFO : new SQLBuilderConnectionInfo(connProfile);
    }

    @Override
    public void setOmitSchemaInfo(IOmitSchemaInfo omitSchemaInfo) {
        if (omitSchemaInfo == null) {
            this._omitSchemaInfo = new OmitSchemaInfo();
            this._omitSchemaInfo.initFromPreferences();
        } else {
            this._omitSchemaInfo = omitSchemaInfo;
        }
    }

    @Override
    public IOmitSchemaInfo getOmitSchemaInfo() {
        return this._omitSchemaInfo;
    }

    public void setSQLStatementInfo(ISQLStatementInfo sqlStatementInfo) {
        this._sqlStatementInfo = sqlStatementInfo;
    }

    public ISQLStatementInfo getSQLStatementInfo() {
        return this._sqlStatementInfo;
    }

    @Override
    public String getSQL() {
        if (this._sqlStatementInfo != null) {
            return this._sqlStatementInfo.getSQL();
        }
        return null;
    }

    public int getStatementType() {
        return this._statementType;
    }

    public void setStatementType(int statementType) {
        this._statementType = statementType;
    }

    public String getId() {
        return null;
    }

    public boolean isConnectionRequired() {
        return false;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return "";
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        StringBuffer sb = new StringBuffer(30);
        if (this._connectionInfo != null) {
            sb.append(this._connectionInfo.getName());
        }
        return sb.toString();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public IWindowStateInfo getWindowStateInfo() {
        return this._windowStateInfo;
    }

    @Override
    public void setWindowStateInfo(IWindowStateInfo windowStateInfo) {
        this._windowStateInfo = windowStateInfo;
    }

    @Override
    public ISQLBuilderEditorInputUsageOptions getInputUsageOptions() {
        return this._inputUsageOptions;
    }

    @Override
    public void setInputUsageOptions(ISQLBuilderEditorInputUsageOptions options) {
        this._inputUsageOptions = options;
    }
}

