/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.CategoryActionFilter;
import org.eclipse.datatools.connectivity.internal.ui.CategoryPropertySource;
import org.eclipse.datatools.connectivity.internal.ui.ConnectionProfileActionFilter;
import org.eclipse.datatools.connectivity.internal.ui.ConnectionProfilePropertySource;
import org.eclipse.datatools.connectivity.internal.ui.WorkbenchWindowPerspectiveActionFilter;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.properties.IPropertySource;
import org.osgi.framework.BundleContext;

public class ConnectivityUIPlugin
extends AbstractUIPlugin {
    public static final int INTERNAL_ERROR = 10001;
    public static final String FILTER_PROPERTY_CONTEN_EXTENSION_ID = "org.eclipse.datatools.connectivity.contentextension.id";
    public static final String FILTER_PROPERTY_CONTEN_EXTENSION_STATE = "org.eclipse.datatools.connectivity.contentextension.state";
    public static final String SERVERS_VIEW_CONTENT_EXTENSION_ID = "org.eclipse.datatools.connectivity.dsexplorer.content";
    public static final String PROP_SHOW_CATEGORIES = "showCategories";
    public static final String SERVERS_VIEW_VIEWER_ID = "org.eclipse.datatools.connectivity.DataSourceExplorerNavigator";
    private static ConnectivityUIPlugin plugin;
    private ResourceBundle resourceBundle;

    public ConnectivityUIPlugin() {
        plugin = this;
    }

    public static ConnectivityUIPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ConnectivityUIPlugin.addIConnectionProfileAdapter();
        ConnectivityUIPlugin.addICategoryAdapter();
        ConnectivityUIPlugin.addIWorkbenchWindowAdapter();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.datatools.connectivity.internal.ui.resources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public String getResourceString(String key) {
        try {
            ResourceBundle resBundle = this.getResourceBundle();
            if (resBundle == null) {
                return key;
            }
            return resBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public String getResourceString(String key, Object[] arguments) {
        MessageFormat f = new MessageFormat(this.getResourceString(key));
        return f.format(arguments);
    }

    private static void addIConnectionProfileAdapter() {
        IAdapterFactory pr = new IAdapterFactory(){

            public Class[] getAdapterList() {
                Class[] c = new Class[]{IPropertySource.class, IActionFilter.class};
                return c;
            }

            public Object getAdapter(Object adaptableObject, Class adapterType) {
                if (adapterType.isAssignableFrom(IPropertySource.class)) {
                    IConnectionProfile icp = (IConnectionProfile)adaptableObject;
                    return new ConnectionProfilePropertySource(icp);
                }
                if (adapterType.isAssignableFrom(IActionFilter.class)) {
                    return new ConnectionProfileActionFilter();
                }
                return null;
            }
        };
        Platform.getAdapterManager().registerAdapters(pr, IConnectionProfile.class);
    }

    private static void addICategoryAdapter() {
        IAdapterFactory pr = new IAdapterFactory(){

            public Class[] getAdapterList() {
                Class[] c = new Class[]{IPropertySource.class, IActionFilter.class};
                return c;
            }

            public Object getAdapter(Object adaptableObject, Class adapterType) {
                if (adapterType.isAssignableFrom(IPropertySource.class)) {
                    ICategory icp = (ICategory)adaptableObject;
                    return new CategoryPropertySource(icp);
                }
                if (adapterType.isAssignableFrom(IActionFilter.class)) {
                    return new CategoryActionFilter();
                }
                return null;
            }
        };
        Platform.getAdapterManager().registerAdapters(pr, ICategory.class);
    }

    private static void addIWorkbenchWindowAdapter() {
        IAdapterFactory pr = new IAdapterFactory(){

            public Class[] getAdapterList() {
                Class[] c = new Class[]{IPropertySource.class, IActionFilter.class};
                return c;
            }

            public Object getAdapter(Object adaptableObject, Class adapterType) {
                if (adapterType.isAssignableFrom(IActionFilter.class)) {
                    return new WorkbenchWindowPerspectiveActionFilter();
                }
                return null;
            }
        };
        Platform.getAdapterManager().registerAdapters(pr, IWorkbenchWindow.class);
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(String message) {
        this.log(this.createErrorStatus(message));
    }

    public void log(Throwable e) {
        this.log(this.createErrorStatus(e));
    }

    public IStatus createErrorStatus(String message) {
        return new Status(4, this.getBundle().getSymbolicName(), 10001, message, null);
    }

    public IStatus createErrorStatus(Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 10001, this.getResourceString("plugin.internal_error"), e);
    }
}

