/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.datatools.enablement.ibm.util.PRSDebug;
import org.eclipse.datatools.enablement.ibm.util.PRSPersistenceUtility;
import org.eclipse.datatools.enablement.ibm.util.StringCache;

public class PRSMetadata
implements ResultSetMetaData {
    public static final int TYPE_BIT = -7;
    public static final int TYPE_TINYINT = -6;
    public static final int TYPE_BIGINT = -5;
    public static final int TYPE_LONGVARBINARY = -4;
    public static final int TYPE_VARBINARY = -3;
    public static final int TYPE_BINARY = -2;
    public static final int TYPE_LONGVARCHAR = -1;
    public static final int TYPE_NULL = 0;
    public static final int TYPE_CHAR = 1;
    public static final int TYPE_NUMERIC = 2;
    public static final int TYPE_DECIMAL = 3;
    public static final int TYPE_INTEGER = 4;
    public static final int TYPE_SMALLINT = 5;
    public static final int TYPE_FLOAT = 6;
    public static final int TYPE_REAL = 7;
    public static final int TYPE_DOUBLE = 8;
    public static final int TYPE_VARCHAR = 12;
    public static final int TYPE_DATE = 91;
    public static final int TYPE_TIME = 92;
    public static final int TYPE_TIMESTAMP = 93;
    public static final int TYPE_CLOB = 2005;
    public static final int TYPE_OTHER = 1111;
    public static final int OTHER = 0;
    public static final int STRING = 1;
    private int columnCount;
    public MetadataForColumn[] columnInfo;
    private final Map<String, int[]> columnmap = new IdentityHashMap<String, int[]>();

    public PRSMetadata() {
    }

    public PRSMetadata(ResultSet rs) throws SQLException {
        this.extractMetadataFromResults(rs);
    }

    public static PRSMetadata loadSavedMetadata(LineNumberReader lr) throws NumberFormatException, IOException {
        int count;
        String line = lr.readLine();
        if (line == null) {
            return null;
        }
        PRSMetadata metadata = new PRSMetadata();
        StringTokenizer toker = new StringTokenizer(line, "|");
        metadata.columnCount = count = PRSPersistenceUtility.getIntToken(toker);
        metadata.columnInfo = new MetadataForColumn[count];
        int ii = 0;
        while (ii < count) {
            line = lr.readLine();
            if (line == null) break;
            MetadataForColumn colinfo = new MetadataForColumn();
            colinfo.fromPrintString(line);
            metadata.columnInfo[ii] = colinfo;
            ++ii;
        }
        return metadata;
    }

    public int[] convertColumnNames(String[] colnames) {
        int[] colnums = new int[colnames.length];
        int ii = 0;
        String[] stringArray = colnames;
        int n = colnames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                colnums[ii] = this.findColumn(name);
            }
            catch (SQLException sQLException) {
                colnums[ii] = 0;
            }
            ++ii;
            ++n2;
        }
        return colnums;
    }

    public int findColumn(String columnName) throws SQLException {
        int[] idx = this.columnmap.get(columnName);
        if (idx != null) {
            return idx[0];
        }
        int count = this.getColumnCount();
        int ii = 1;
        while (ii <= count) {
            if (this.getColumnName(ii).equals(columnName)) {
                this.columnmap.put(columnName, new int[]{ii});
                return ii;
            }
            ++ii;
        }
        throw new SQLException("Can't find column named \"" + columnName + "\"");
    }

    private void extractMetadataFromResults(ResultSet rs) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        this.columnCount = md.getColumnCount();
        this.columnInfo = new MetadataForColumn[this.columnCount];
        int ii = 1;
        while (ii <= this.columnCount) {
            MetadataForColumn mdc;
            this.columnInfo[ii - 1] = mdc = new MetadataForColumn();
            mdc.catalogName = StringCache.getUniqueString(md.getCatalogName(ii));
            mdc.columnClassName = StringCache.getUniqueString(md.getColumnClassName(ii));
            mdc.columnName = StringCache.getUniqueString(md.getColumnLabel(ii));
            mdc.columnType = md.getColumnType(ii);
            mdc.columnTypeName = StringCache.getUniqueString(md.getColumnTypeName(ii));
            mdc.precision = md.getPrecision(ii);
            mdc.scale = md.getScale(ii);
            mdc.schemaName = md.getSchemaName(ii);
            mdc.tableName = StringCache.getUniqueString(md.getTableName(ii));
            mdc.isAutoIncrement = md.isAutoIncrement(ii);
            mdc.isCaseSensitive = md.isCaseSensitive(ii);
            mdc.isCurrency = md.isCurrency(ii);
            mdc.isDefinitelyWritable = md.isDefinitelyWritable(ii);
            mdc.isNullable = md.isNullable(ii);
            mdc.isReadOnly = md.isReadOnly(ii);
            mdc.isSearchable = md.isSearchable(ii);
            mdc.isSigned = md.isSigned(ii);
            mdc.isWritable = md.isWritable(ii);
            ++ii;
        }
    }

    public void save(File saveFile) {
        if (PRSDebug.noFileCache || saveFile == null) {
            return;
        }
        PrintWriter pw = PRSPersistenceUtility.openFileForAppend(saveFile);
        if (pw == null) {
            return;
        }
        pw.print(this.toPrintString());
        pw.close();
    }

    public String toPrintString() {
        StringBuilder sb = new StringBuilder();
        PRSPersistenceUtility.append(sb, this.columnCount);
        PRSPersistenceUtility.newline(sb);
        MetadataForColumn[] metadataForColumnArray = this.columnInfo;
        int n = this.columnInfo.length;
        int n2 = 0;
        while (n2 < n) {
            MetadataForColumn colinfo = metadataForColumnArray[n2];
            PRSPersistenceUtility.addLine(sb, colinfo.toPrintString());
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.columnInfo[column - 1].columnClassName;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.columnInfo[column - 1].catalogName;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return null;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnInfo[column - 1].columnName;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.columnInfo[column - 1].columnType;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.columnInfo[column - 1].columnTypeName;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.columnInfo[column - 1].precision;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.columnInfo[column - 1].scale;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.columnInfo[column - 1].schemaName;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.columnInfo[column - 1].tableName;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.columnInfo[column - 1].isAutoIncrement;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.columnInfo[column - 1].isCaseSensitive;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.columnInfo[column - 1].isCurrency;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.columnInfo[column - 1].isDefinitelyWritable;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.columnInfo[column - 1].isNullable;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.columnInfo[column - 1].isReadOnly;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.columnInfo[column - 1].isSearchable;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.columnInfo[column - 1].isSigned;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.columnInfo[column - 1].isWritable;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    public static class MetadataForColumn {
        public String catalogName;
        public String columnClassName;
        public String columnName;
        public int columnType;
        public String columnTypeName;
        public int precision;
        public int scale;
        public String schemaName;
        public String tableName;
        public boolean isAutoIncrement;
        public boolean isCaseSensitive;
        public boolean isCurrency;
        public boolean isDefinitelyWritable;
        public int isNullable;
        public boolean isReadOnly;
        public boolean isSearchable;
        public boolean isSigned;
        public boolean isWritable;

        public void save(PrintWriter pw) {
            pw.println(this.toPrintString());
        }

        public String toPrintString() {
            StringBuilder sb = new StringBuilder();
            PRSPersistenceUtility.append(sb, this.catalogName);
            PRSPersistenceUtility.append(sb, this.columnClassName);
            PRSPersistenceUtility.append(sb, this.columnName);
            PRSPersistenceUtility.append(sb, this.columnType);
            PRSPersistenceUtility.append(sb, this.columnTypeName);
            PRSPersistenceUtility.append(sb, this.precision);
            PRSPersistenceUtility.append(sb, this.scale);
            PRSPersistenceUtility.append(sb, this.schemaName);
            PRSPersistenceUtility.append(sb, this.tableName);
            PRSPersistenceUtility.append(sb, this.isAutoIncrement);
            PRSPersistenceUtility.append(sb, this.isCaseSensitive);
            PRSPersistenceUtility.append(sb, this.isCurrency);
            PRSPersistenceUtility.append(sb, this.isDefinitelyWritable);
            PRSPersistenceUtility.append(sb, this.isNullable);
            PRSPersistenceUtility.append(sb, this.isReadOnly);
            PRSPersistenceUtility.append(sb, this.isSearchable);
            PRSPersistenceUtility.append(sb, this.isSigned);
            PRSPersistenceUtility.append(sb, this.isWritable);
            return sb.toString();
        }

        public void fromPrintString(String s) {
            StringTokenizer toker = new StringTokenizer(s, "|");
            this.catalogName = PRSPersistenceUtility.getStringToken(toker);
            this.columnClassName = PRSPersistenceUtility.getStringToken(toker);
            this.columnName = PRSPersistenceUtility.getStringToken(toker);
            this.columnType = PRSPersistenceUtility.getIntToken(toker);
            this.columnTypeName = PRSPersistenceUtility.getStringToken(toker);
            this.precision = PRSPersistenceUtility.getIntToken(toker);
            this.scale = PRSPersistenceUtility.getIntToken(toker);
            this.schemaName = PRSPersistenceUtility.getStringToken(toker);
            this.tableName = PRSPersistenceUtility.getStringToken(toker);
            this.isAutoIncrement = PRSPersistenceUtility.getBooleanToken(toker);
            this.isCaseSensitive = PRSPersistenceUtility.getBooleanToken(toker);
            this.isCurrency = PRSPersistenceUtility.getBooleanToken(toker);
            this.isDefinitelyWritable = PRSPersistenceUtility.getBooleanToken(toker);
            this.isNullable = PRSPersistenceUtility.getIntToken(toker);
            this.isReadOnly = PRSPersistenceUtility.getBooleanToken(toker);
            this.isSearchable = PRSPersistenceUtility.getBooleanToken(toker);
            this.isSigned = PRSPersistenceUtility.getBooleanToken(toker);
            this.isWritable = PRSPersistenceUtility.getBooleanToken(toker);
        }
    }
}

