/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.core.ext;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.connector.core.EMFDiffMergeCoreConnectorPlugin;
import org.eclipse.emf.diffmerge.connector.core.ext.URIConvertingScopeDefinition;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.setup.ComparisonSetupManager;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinitionFactory;
import org.eclipse.emf.diffmerge.ui.specification.ext.URIScopeDefinitionFactory;
import org.eclipse.emf.ecore.resource.URIConverter;

public abstract class AbstractURIConvertingScopeDefinitionFactory
extends URIScopeDefinitionFactory {
    public IModelScopeDefinition createScopeDefinition(Object entrypoint_p, String label_p, boolean editable_p) {
        URIConvertingScopeDefinition result = null;
        try {
            URI uri = this.convertToURI(entrypoint_p);
            URIConverter uriConverter = this.getURIConverter(entrypoint_p);
            if (uri != null && uriConverter != null) {
                ComparisonSetupManager setupManager = EMFDiffMergeUIPlugin.getDefault().getSetupManager();
                ArrayList factories = setupManager.getApplicableModelScopeFactories((Object)uri);
                factories = new ArrayList(factories);
                factories.remove((Object)this);
                if (!factories.isEmpty()) {
                    IModelScopeDefinition scopeDefinition;
                    String label;
                    IModelScopeDefinitionFactory factory = (IModelScopeDefinitionFactory)factories.get(0);
                    String string = label = label_p != null ? label_p : this.getLabelFor(entrypoint_p);
                    if (label == null) {
                        label = uri.toString();
                    }
                    if ((scopeDefinition = factory.createScopeDefinition((Object)uri, label, editable_p)) != null) {
                        boolean editable = this.isScopeEditable(entrypoint_p);
                        result = new URIConvertingScopeDefinition(scopeDefinition, uriConverter, editable);
                        result.setStream(this.getStream(entrypoint_p));
                    }
                }
            }
        }
        catch (Exception e) {
            EMFDiffMergeCoreConnectorPlugin.getDefault().logError(e);
        }
        return result;
    }

    public Collection<? extends Class<?>> getOverridenClasses() {
        return Collections.singleton(URIScopeDefinitionFactory.class);
    }

    protected InputStream getStream(Object entrypoint_p) throws CoreException {
        return null;
    }

    protected abstract URIConverter getURIConverter(Object var1);

    protected boolean isScopeEditable(Object entrypoint_p) {
        return false;
    }
}

