/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.spi.swt.util;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emfforms.spi.common.validation.PreSetValidationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class PreSetValidationStrategy
extends UpdateValueStrategy {
    private final EStructuralFeature eStructuralFeature;
    private final VElement vElement;
    private final UpdateValueStrategy strategy;

    public PreSetValidationStrategy(VElement vElement, EStructuralFeature eStructuralFeature, UpdateValueStrategy delegate) {
        this.vElement = vElement;
        this.eStructuralFeature = eStructuralFeature;
        this.strategy = delegate;
    }

    public IStatus validateBeforeSet(Object value) {
        BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(PreSetValidationService.class);
        if (serviceReference == null) {
            return this.strategy.validateBeforeSet(value);
        }
        if (this.eStructuralFeature.isUnsettable() && SetCommand.UNSET_VALUE == value) {
            value = this.eStructuralFeature.getDefaultValue();
        }
        try {
            PreSetValidationService service = (PreSetValidationService)bundleContext.getService(serviceReference);
            if (service == null) {
                IStatus iStatus = this.strategy.validateBeforeSet(value);
                return iStatus;
            }
            Diagnostic result = service.validate(this.eStructuralFeature, value);
            if (result.getSeverity() == 0) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            VDiagnostic vDiagnostic = VViewFactory.eINSTANCE.createDiagnostic();
            vDiagnostic.getDiagnostics().add((Object)result);
            if (this.vElement != null) {
                this.vElement.setDiagnostic(vDiagnostic);
            }
            IStatus iStatus = BasicDiagnostic.toIStatus((Diagnostic)result);
            return iStatus;
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }

    public Object convert(Object value) {
        return this.strategy.convert(value);
    }

    public int getUpdatePolicy() {
        return this.strategy.getUpdatePolicy();
    }

    public UpdateValueStrategy setAfterConvertValidator(IValidator validator) {
        return this.strategy.setAfterConvertValidator(validator);
    }

    public UpdateValueStrategy setBeforeSetValidator(IValidator validator) {
        return this.strategy.setBeforeSetValidator(validator);
    }

    public UpdateValueStrategy setAfterGetValidator(IValidator validator) {
        return this.strategy.setAfterGetValidator(validator);
    }

    public UpdateValueStrategy setConverter(IConverter converter) {
        return this.strategy.setConverter(converter);
    }

    public IStatus validateAfterConvert(Object value) {
        return this.strategy.validateAfterConvert(value);
    }

    public IStatus validateAfterGet(Object value) {
        return this.strategy.validateAfterGet(value);
    }

    public EStructuralFeature getStructuralFeature() {
        return this.eStructuralFeature;
    }

    public VElement getVElement() {
        return this.vElement;
    }
}

