/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.compoundcontrol.swt;

import java.util.LinkedHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecp.view.internal.compoundcontrol.swt.Activator;
import org.eclipse.emf.ecp.view.spi.compoundcontrol.model.VCompoundControl;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.LayoutProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CompoundControlSWTRenderer
extends AbstractSWTRenderer<VCompoundControl> {
    private static final String COMPOUND_CONTROL = "org_eclipse_emf_ecp_ui_compound_control";
    private SWTGridDescription rendererGridDescription;

    protected void dispose() {
        this.rendererGridDescription = null;
        super.dispose();
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
            SWTGridCell swtGridCell = (SWTGridCell)this.rendererGridDescription.getGrid().get(0);
            swtGridCell.setVerticalGrab(false);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        AbstractSWTRenderer renderer;
        if (gridCell.getColumn() != 0) {
            return null;
        }
        Composite columnComposite = new Composite(parent, 0);
        columnComposite.setBackground(parent.getBackground());
        columnComposite.setData("org.eclipse.rap.rwt.customVariant", (Object)COMPOUND_CONTROL);
        LinkedHashMap<VControl, AbstractSWTRenderer> elementRendererMap = new LinkedHashMap<VControl, AbstractSWTRenderer>();
        for (VControl child : ((VCompoundControl)this.getVElement()).getControls()) {
            child.setLabelAlignment(LabelAlignment.NONE);
            renderer = this.getSWTRendererFactory().getRenderer((VElement)child, this.getViewModelContext());
            if (renderer == null) {
                Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.emf.ecp.view.compoundcontrol.swt", String.format("No Renderer for %s found.", child.eClass().getName())));
                continue;
            }
            elementRendererMap.put(child, renderer);
        }
        columnComposite.setLayout(LayoutProviderHelper.getColumnLayout((int)elementRendererMap.size(), (boolean)true));
        for (VControl child : elementRendererMap.keySet()) {
            renderer = (AbstractSWTRenderer)elementRendererMap.get(child);
            Composite column = new Composite(columnComposite, 0);
            column.setBackground(parent.getBackground());
            column.setLayoutData(LayoutProviderHelper.getSpanningLayoutData((int)1, (int)1));
            SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            column.setLayout(LayoutProviderHelper.getColumnLayout((int)gridDescription.getColumns(), (boolean)false));
            try {
                for (SWTGridCell childGridCell : gridDescription.getGrid()) {
                    Control control = ((AbstractSWTRenderer)childGridCell.getRenderer()).render(childGridCell, column);
                    if (control == null) continue;
                    control.setLayoutData(LayoutProviderHelper.getLayoutData((SWTGridCell)childGridCell, (SWTGridDescription)gridDescription, (SWTGridDescription)gridDescription, (SWTGridDescription)gridDescription, (VElement)((AbstractSWTRenderer)childGridCell.getRenderer()).getVElement(), (Control)control));
                }
                for (SWTGridCell childGridCell : gridDescription.getGrid()) {
                    ((AbstractSWTRenderer)childGridCell.getRenderer()).finalizeRendering(column);
                }
            }
            catch (NoPropertyDescriptorFoundExeption noPropertyDescriptorFoundExeption) {}
        }
        return columnComposite;
    }
}

