/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constructorvalidation;

import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.CrossParameterDescriptor;
import javax.validation.metadata.GroupConversionDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import javax.validation.metadata.ReturnValueDescriptor;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constructorvalidation.CrossRepositoryConstraint;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constructorvalidation.Customer;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constructorvalidation.CustomerRepository;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ConstructorValidationTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ConstructorValidationTest.webArchiveBuilder().withTestClassPackage(ConstructorValidationTest.class)).withValidationXml("validation-ConstructorValidationTest.xml")).withResource("customer-repository-constraints-ConstructorValidationTest.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constructorleveloverriding", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constructorleveloverriding", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constructorleveloverriding", id="e")})
    public void testXmlConfiguredConstructors() throws Exception {
        ConstructorDescriptor descriptor = TestUtil.getConstructorDescriptor(CustomerRepository.class, new Class[0]);
        Assert.assertNotNull((Object)descriptor, (String)"the specified constructor should be configured in xml");
        Assert.assertTrue((boolean)descriptor.hasConstrainedReturnValue());
        descriptor = TestUtil.getConstructorDescriptor(CustomerRepository.class, String.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified constructor should be configured in xml");
        Assert.assertTrue((boolean)descriptor.hasConstrainedParameters());
        descriptor = TestUtil.getConstructorDescriptor(CustomerRepository.class, CustomerRepository.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified constructor should be configured in xml");
        Assert.assertTrue((boolean)descriptor.hasConstrainedParameters());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constructorleveloverriding", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constructorleveloverriding", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constructorleveloverriding", id="c")})
    public void testVarargsConstructorParameter() throws Exception {
        ConstructorDescriptor descriptor = TestUtil.getConstructorDescriptor(CustomerRepository.class, String.class, Customer[].class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified constructor should be configured in xml");
        Assert.assertTrue((boolean)descriptor.hasConstrainedParameters());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constructorleveloverriding", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constructorleveloverriding", id="f"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constructorleveloverriding", id="j")})
    public void testConstructorCrossParameterConstraint() throws Exception {
        ConstructorDescriptor descriptor = TestUtil.getConstructorDescriptor(CustomerRepository.class, CustomerRepository.class, CustomerRepository.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified constructor should be configured in xml");
        CrossParameterDescriptor crossParameterDescriptor = descriptor.getCrossParameterDescriptor();
        Assert.assertTrue((boolean)crossParameterDescriptor.hasConstraints());
        Set constraintDescriptors = crossParameterDescriptor.getConstraintDescriptors();
        Assert.assertTrue((constraintDescriptors.size() == 1 ? 1 : 0) != 0);
        ConstraintDescriptor constraintDescriptor = (ConstraintDescriptor)constraintDescriptors.iterator().next();
        Assert.assertEquals(constraintDescriptor.getAnnotation().annotationType(), CrossRepositoryConstraint.class, (String)"Unexpected constraint type");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-constraintdescriptor", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constructorleveloverriding", id="g")})
    public void testConstraintOnConstructorReturnValueAndParameter() throws Exception {
        ConstructorDescriptor descriptor = TestUtil.getConstructorDescriptor(CustomerRepository.class, String.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified constructor should be configured in xml");
        ReturnValueDescriptor returnValueDescriptor = descriptor.getReturnValueDescriptor();
        Set constraintDescriptors = returnValueDescriptor.getConstraintDescriptors();
        Assert.assertTrue((constraintDescriptors.size() == 1 ? 1 : 0) != 0);
        ConstraintDescriptor constraintDescriptor = (ConstraintDescriptor)constraintDescriptors.iterator().next();
        Assert.assertEquals(constraintDescriptor.getAnnotation().annotationType(), NotNull.class, (String)"Unexpected constraint type");
        List parameterDescriptors = descriptor.getParameterDescriptors();
        Assert.assertTrue((parameterDescriptors.size() == 1 ? 1 : 0) != 0);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptors.get(0);
        constraintDescriptors = parameterDescriptor.getConstraintDescriptors();
        Assert.assertTrue((constraintDescriptors.size() == 1 ? 1 : 0) != 0);
        constraintDescriptor = (ConstraintDescriptor)constraintDescriptors.iterator().next();
        Assert.assertEquals(constraintDescriptor.getAnnotation().annotationType(), NotNull.class, (String)"Unexpected constraint type");
    }

    @Test
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constructorleveloverriding", id="h")
    public void testCascadingOnReturnValueAndParameter() throws Exception {
        ConstructorDescriptor descriptor = TestUtil.getConstructorDescriptor(CustomerRepository.class, CustomerRepository.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified constructor should be configured in xml");
        ReturnValueDescriptor returnValueDescriptor = descriptor.getReturnValueDescriptor();
        Assert.assertTrue((boolean)returnValueDescriptor.isCascaded(), (String)"<valid/> is used to configure cascading");
        List parameterDescriptors = descriptor.getParameterDescriptors();
        Assert.assertTrue((parameterDescriptors.size() == 1 ? 1 : 0) != 0);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptors.get(0);
        Assert.assertTrue((boolean)parameterDescriptor.isCascaded(), (String)"<valid/> is used to configure cascading");
    }

    @Test
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constructorleveloverriding", id="i")
    public void testGroupConversionOnReturnValueAndParameter() throws Exception {
        ConstructorDescriptor descriptor = TestUtil.getConstructorDescriptor(CustomerRepository.class, CustomerRepository.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified constructor should be configured in xml");
        ReturnValueDescriptor returnValueDescriptor = descriptor.getReturnValueDescriptor();
        Set groupConversionDescriptors = returnValueDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 1 ? 1 : 0) != 0);
        GroupConversionDescriptor groupConversionDescriptor = (GroupConversionDescriptor)groupConversionDescriptors.iterator().next();
        Assert.assertEquals((Object)groupConversionDescriptor.getFrom(), Default.class, (String)"Wrong from class for group conversion");
        List parameterDescriptors = descriptor.getParameterDescriptors();
        Assert.assertTrue((parameterDescriptors.size() == 1 ? 1 : 0) != 0);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptors.get(0);
        groupConversionDescriptors = parameterDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 1 ? 1 : 0) != 0);
        groupConversionDescriptor = (GroupConversionDescriptor)groupConversionDescriptors.iterator().next();
        Assert.assertEquals((Object)groupConversionDescriptor.getFrom(), Default.class, (String)"Wrong from class for group conversion");
    }
}

