/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.priority.transactional;

import jakarta.annotation.Priority;
import jakarta.annotation.Resource;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.transaction.UserTransaction;
import org.jboss.cdi.tck.tests.event.observer.priority.transactional.AbstractObserver;
import org.jboss.cdi.tck.tests.event.observer.priority.transactional.TxFailure;
import org.jboss.cdi.tck.tests.event.observer.priority.transactional.TxWithdrawal;

public class SenderAccountTransactionObserver
extends AbstractObserver {
    @Resource
    private UserTransaction userTransaction;

    public void withdrawAfterSuccess(@Observes(during=TransactionPhase.AFTER_SUCCESS) @Priority(value=2050) TxWithdrawal txWithdrawal) throws Exception {
        this.logEventFired(TransactionPhase.AFTER_SUCCESS);
    }

    public void withdrawAfterCompletion(@Observes(during=TransactionPhase.AFTER_COMPLETION) @Priority(value=2100) TxWithdrawal txWithdrawal) throws Exception {
        this.logEventFired(TransactionPhase.AFTER_COMPLETION);
    }

    public void withdrawBeforeCompletion(@Observes(during=TransactionPhase.BEFORE_COMPLETION) TxWithdrawal txWithdrawal) throws Exception {
        this.logEventFired(TransactionPhase.BEFORE_COMPLETION);
    }

    public void withdrawNoTx(@Observes(during=TransactionPhase.IN_PROGRESS) TxWithdrawal txWithdrawal) throws Exception {
        this.logEventFired(TransactionPhase.IN_PROGRESS);
    }

    public void withdrawAfterFailure(@Observes(during=TransactionPhase.AFTER_FAILURE) TxWithdrawal txWithdrawal) throws Exception {
        this.logEventFired(TransactionPhase.AFTER_FAILURE);
    }

    public void failBeforeCompletion(@Observes(during=TransactionPhase.IN_PROGRESS) TxFailure txFailure) throws Exception {
        this.logEventFired(TransactionPhase.IN_PROGRESS);
        this.userTransaction.setRollbackOnly();
    }
}

