/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.inheritance.enterprise;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.inheritance.enterprise.Egg;
import org.jboss.cdi.tck.tests.event.observer.inheritance.enterprise.Farmer;
import org.jboss.cdi.tck.tests.event.observer.inheritance.enterprise.IndirectStockWatcher;
import org.jboss.cdi.tck.tests.event.observer.inheritance.enterprise.IntermediateStockWatcher;
import org.jboss.cdi.tck.tests.event.observer.inheritance.enterprise.LazyFarmer;
import org.jboss.cdi.tck.tests.event.observer.inheritance.enterprise.StockPrice;
import org.jboss.cdi.tck.tests.event.observer.inheritance.enterprise.StockWatcher;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"javaee-full"})
@SpecVersion(spec="cdi", version="2.0")
public class EnterpriseObserverInheritanceTest
extends AbstractTest {
    @Deployment
    public static EnterpriseArchive createTestArchive() {
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().withTestClassPackage(EnterpriseObserverInheritanceTest.class)).build();
    }

    @Test
    @SpecAssertion(section="member_level_inheritance_ee", id="df")
    public void testNonStaticObserverMethodInherited() throws Exception {
        Egg egg = new Egg();
        this.getCurrentManager().fireEvent((Object)egg, new Annotation[0]);
        Assert.assertEquals((int)egg.getVisited().size(), (int)2);
        Assert.assertTrue((boolean)egg.getVisited().contains(Farmer.class.getSimpleName()));
        Assert.assertTrue((boolean)egg.getVisited().contains(LazyFarmer.class.getSimpleName()));
    }

    @Test
    @SpecAssertion(section="member_level_inheritance_ee", id="dl")
    public void testNonStaticObserverMethodIndirectlyInherited() throws Exception {
        StockPrice stockPrice = new StockPrice();
        this.getCurrentManager().fireEvent((Object)stockPrice, new Annotation[0]);
        Assert.assertEquals((int)stockPrice.getVisited().size(), (int)3);
        Assert.assertTrue((boolean)stockPrice.getVisited().contains(StockWatcher.class.getSimpleName()));
        Assert.assertTrue((boolean)stockPrice.getVisited().contains(IntermediateStockWatcher.class.getSimpleName()));
        Assert.assertTrue((boolean)stockPrice.getVisited().contains(IndirectStockWatcher.class.getSimpleName()));
    }
}

