/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.util;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;

public class DependentInstance<T> {
    private final Bean<T> bean;
    private final CreationalContext<T> creationalContext;
    private final T instance;
    private boolean destroyed = false;

    public DependentInstance(BeanManager beanManager, Class<T> beanType, Annotation ... qualifiers) {
        Set beans = beanManager.getBeans(beanType, qualifiers);
        if (beans == null || beans.isEmpty()) {
            throw new UnsatisfiedResolutionException(String.format("No bean matches required type %s and required qualifiers %s", beanType, Arrays.toString(qualifiers)));
        }
        this.bean = beanManager.resolve(beans);
        if (!this.bean.getScope().equals(Dependent.class)) {
            throw new IllegalStateException("Bean is not dependent");
        }
        this.creationalContext = beanManager.createCreationalContext(this.bean);
        this.instance = this.bean.create(this.creationalContext);
    }

    public T get() {
        this.checkDestroyed();
        return this.instance;
    }

    public DependentInstance<T> destroy() {
        this.checkDestroyed();
        this.bean.destroy(this.instance, this.creationalContext);
        this.destroyed = true;
        return this;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("Instance already destroyed");
        }
    }
}

