/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.lifecycle;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.CreationException;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.CdOrderProcessor;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Cod;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Duck;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Egg;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.EggProducer;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Farm;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.FishPond;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.FooException;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Goldfish;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Goose;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.IndirectOrderProcessor;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Lorry_Broken;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.NovelOrderProcessor;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.OrderProcessor;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.RedSnapper;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Salmon;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.ShoeFactory;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Tuna;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.TunaFarm;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Van_Broken;
import org.jboss.cdi.tck.util.DependentInstance;
import org.jboss.cdi.tck.util.MockCreationalContext;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class SimpleBeanLifecycleTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SimpleBeanLifecycleTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_bean_constructor", id="f"), @SpecAssertion(section="declaring_bean_constructor", id="g"), @SpecAssertion(section="method_constructor_parameter_qualifiers", id="d")})
    public void testInjectionOfParametersIntoBeanConstructor() {
        assert (this.getBeans(FishPond.class, new Annotation[0]).size() == 1);
        FishPond fishPond = this.getContextualReference(FishPond.class, new Annotation[0]);
        assert (fishPond.goldfish != null);
        assert (fishPond.goldfish instanceof Goldfish);
        assert (fishPond.goose != null);
    }

    @Test
    @SpecAssertion(section="declaring_bean_constructor", id="g")
    public void testQualifierTypeAnnotatedConstructor() {
        this.getContextualReference(Duck.class, new Annotation[0]);
        assert (Duck.constructedCorrectly);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="creational_context", id="d"), @SpecAssertion(section="creational_context", id="g")})
    public void testCreateReturnsSameBeanPushed() {
        MockCreationalContext creationalContext = new MockCreationalContext();
        Contextual bean = (Contextual)this.getBeans(ShoeFactory.class, new Annotation[0]).iterator().next();
        MockCreationalContext.reset();
        ShoeFactory instance = (ShoeFactory)this.getCurrentManager().getContext(Dependent.class).get(bean, creationalContext);
        if (MockCreationalContext.isPushCalled()) assert (instance == MockCreationalContext.getLastBeanPushed());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="managed_bean_lifecycle", id="aa")})
    public void testBeanCreateInjectsDependenciesAndInvokesInitializerToInstantiateInstance() {
        Contextual bean = (Contextual)this.getBeans(FishPond.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(bean);
        FishPond fishPond = (FishPond)bean.create(creationalContext);
        assert (fishPond != null);
        assert (fishPond.goldfish != null);
        assert (fishPond.goldfish instanceof Goldfish);
        assert (fishPond.goose != null);
        assert (fishPond.salmon != null);
        assert (fishPond.postConstructCalled);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="concepts", id="g"), @SpecAssertion(section="legal_bean_types", id="b"), @SpecAssertion(section="legal_bean_types", id="k"), @SpecAssertion(section="initialization", id="ja")})
    public void testManagedBean() {
        assert (this.getBeans(RedSnapper.class, new Annotation[0]).size() == 1);
        assert (this.getContextualReference(RedSnapper.class, new Annotation[0]) instanceof RedSnapper);
        RedSnapper redSnapper = this.getContextualReference(RedSnapper.class, new Annotation[0]);
        redSnapper.ping();
        assert (redSnapper.isTouched());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="managed_bean_lifecycle", id="aa"), @SpecAssertion(section="declaring_bean_constructor", id="aa"), @SpecAssertion(section="injected_field_qualifiers", id="a"), @SpecAssertion(section="injected_fields", id="a"), @SpecAssertion(section="declaring_injected_field", id="aa"), @SpecAssertion(section="bean_archive_ee", id="jg")})
    public void testCreateInjectsFieldsDeclaredInJava() {
        assert (this.getBeans(TunaFarm.class, new Annotation[0]).size() == 1);
        TunaFarm tunaFarm = this.getContextualReference(TunaFarm.class, new Annotation[0]);
        assert (tunaFarm.tuna != null);
        assert (tunaFarm.tuna.getName().equals("Ophir"));
        assert (tunaFarm.qualifiedTuna != null);
        assert (tunaFarm.qualifiedTuna.getName().equals("qualifiedTuna"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="context", id="l")})
    public void testContextCreatesNewInstanceForInjection() {
        Context requestContext = this.getCurrentManager().getContext(RequestScoped.class);
        Bean<Tuna> tunaBean = this.getBeans(Tuna.class, new Annotation[0]).iterator().next();
        assert (requestContext.get(tunaBean) == null);
        TunaFarm tunaFarm = this.getContextualReference(TunaFarm.class, new Annotation[0]);
        assert (tunaFarm.tuna != null);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="managed_bean_lifecycle", id="aa"), @SpecAssertion(section="managed_bean_lifecycle", id="ba")})
    public void testPostConstructPreDestroy() {
        assert (this.getBeans(Farm.class, new Annotation[0]).size() == 1);
        Bean<Farm> farmBean = this.getBeans(Farm.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(farmBean);
        Farm farm = (Farm)farmBean.create(creationalContext);
        assert (farm.founded != null);
        assert (farm.initialStaff == 20);
        assert (farm.closed == null);
        farmBean.destroy((Object)farm, creationalContext);
        assert (farm.closed != null);
        assert (farm.farmOffice.noOfStaff == 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="contextual_reference", id="aa"), @SpecAssertion(section="managed_bean_lifecycle", id="ba"), @SpecAssertion(section="contextual_reference", id="c")})
    public void testContextualDestroyDisposesWhenNecessary() {
        Bean<Goose> gooseBean = this.getBeans(Goose.class, new Annotation[0]).iterator().next();
        CreationalContext gooseCc = this.getCurrentManager().createCreationalContext(gooseBean);
        Goose goose = (Goose)gooseBean.create(gooseCc);
        assert (!this.getCurrentConfiguration().getBeans().isProxy((Object)goose));
        assert (!EggProducer.isEggDisposed());
        assert (!Egg.isEggDestroyed());
        gooseBean.destroy((Object)goose, gooseCc);
        assert (EggProducer.isEggDisposed());
        assert (!Egg.isEggDestroyed());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="contextual", id="ab")})
    public void testContextualDestroyCatchesException() {
        Bean<Cod> codBean = this.getBeans(Cod.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(codBean);
        Cod codInstance = (Cod)codBean.create(creationalContext);
        codInstance.ping();
        codBean.destroy((Object)codInstance, creationalContext);
        Assert.assertTrue((boolean)Cod.isExpcetionThrown());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="dependent_objects_destruction", id="a")})
    public void testDependentsDestroyedAfterPreDestroy() {
        Bean<FishPond> pondBean = this.getBeans(FishPond.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(pondBean);
        FishPond fishPond = (FishPond)pondBean.create(creationalContext);
        pondBean.destroy((Object)fishPond, creationalContext);
        assert (Salmon.isBeanDestroyed());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="member_level_inheritance", id="baa")
    public void testSubClassInheritsPostConstructOnSuperclass(Instance<Object> instance) {
        OrderProcessor.postConstructCalled = false;
        Assert.assertEquals((int)this.getBeans(CdOrderProcessor.class, new Annotation[0]).size(), (int)1);
        this.getContextualReference(CdOrderProcessor.class, new Annotation[0]).order();
        Assert.assertTrue((boolean)OrderProcessor.postConstructCalled);
        Assert.assertNotNull(instance);
        OrderProcessor.postConstructCalled = false;
        ((CdOrderProcessor)instance.select(CdOrderProcessor.class, new Annotation[0]).get()).order();
        Assert.assertTrue((boolean)OrderProcessor.postConstructCalled);
    }

    @Test
    @SpecAssertion(section="member_level_inheritance", id="bac")
    public void testIndirectSubClassInheritsPostConstructOnSuperclass() {
        OrderProcessor.postConstructCalled = false;
        assert (this.getBeans(IndirectOrderProcessor.class, new Annotation[0]).size() == 1);
        this.getContextualReference(IndirectOrderProcessor.class, new Annotation[0]).order();
        assert (OrderProcessor.postConstructCalled);
    }

    @Test
    @SpecAssertion(section="member_level_inheritance", id="bba")
    public void testSubClassInheritsPreDestroyOnSuperclass() {
        OrderProcessor.preDestroyCalled = false;
        assert (this.getBeans(CdOrderProcessor.class, new Annotation[0]).size() == 1);
        DependentInstance<CdOrderProcessor> bean = this.newDependentInstance(CdOrderProcessor.class, new Annotation[0]);
        CdOrderProcessor instance = bean.get();
        Assert.assertFalse((boolean)instance.equals(null));
        bean.destroy();
        Assert.assertTrue((boolean)OrderProcessor.preDestroyCalled);
    }

    @Test
    @SpecAssertion(section="member_level_inheritance", id="bbc")
    public void testIndirectSubClassInheritsPreDestroyOnSuperclass() {
        OrderProcessor.preDestroyCalled = false;
        assert (this.getBeans(IndirectOrderProcessor.class, new Annotation[0]).size() == 1);
        DependentInstance<IndirectOrderProcessor> bean = this.newDependentInstance(IndirectOrderProcessor.class, new Annotation[0]);
        Assert.assertFalse((boolean)bean.get().equals(null));
        bean.destroy();
        Assert.assertTrue((boolean)OrderProcessor.preDestroyCalled);
    }

    @Test
    @SpecAssertion(section="member_level_inheritance", id="baa")
    public void testSubClassDoesNotInheritPostConstructOnSuperclassBlockedByIntermediateClass() {
        assert (this.getBeans(NovelOrderProcessor.class, new Annotation[0]).size() == 1);
        OrderProcessor.postConstructCalled = false;
        this.getContextualReference(NovelOrderProcessor.class, new Annotation[0]).order();
        assert (!OrderProcessor.postConstructCalled);
    }

    @Test
    @SpecAssertion(section="member_level_inheritance", id="bba")
    public void testSubClassDoesNotInheritPreDestroyConstructOnSuperclassBlockedByIntermediateClass() {
        OrderProcessor.preDestroyCalled = false;
        assert (this.getBeans(NovelOrderProcessor.class, new Annotation[0]).size() == 1);
        DependentInstance<NovelOrderProcessor> bean = this.newDependentInstance(NovelOrderProcessor.class, new Annotation[0]);
        NovelOrderProcessor instance = bean.get();
        Assert.assertFalse((boolean)instance.equals(null));
        bean.destroy();
        Assert.assertFalse((boolean)OrderProcessor.preDestroyCalled);
    }

    @Test(expectedExceptions={CreationException.class})
    @SpecAssertion(section="contextual", id="aa")
    public void testCreationExceptionWrapsCheckedExceptionThrownFromCreate() {
        assert (this.getBeans(Lorry_Broken.class, new Annotation[0]).size() == 1);
        this.getContextualReference(Lorry_Broken.class, new Annotation[0]);
    }

    @Test(expectedExceptions={FooException.class})
    @SpecAssertion(section="contextual", id="aa")
    public void testUncheckedExceptionThrownFromCreateNotWrapped() {
        assert (this.getBeans(Van_Broken.class, new Annotation[0]).size() == 1);
        this.getContextualReference(Van_Broken.class, new Annotation[0]);
    }
}

