/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.enterprise.jms;

import javax.annotation.PostConstruct;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.jboss.cdi.tck.impl.ConfigurationFactory;
import org.jboss.cdi.tck.util.JndiLookupUtils;
import org.jboss.cdi.tck.util.SimpleLogger;

public class SimpleMessageProducer {
    private static final SimpleLogger simpleLogger = new SimpleLogger(SimpleMessageProducer.class);
    private ConnectionFactory connectionFactory;
    private Queue queue;
    private Topic topic;

    @PostConstruct
    public void init() {
        this.connectionFactory = (ConnectionFactory)JndiLookupUtils.lookup(ConfigurationFactory.get().getTestJmsConnectionFactory());
        this.queue = (Queue)JndiLookupUtils.lookup(ConfigurationFactory.get().getTestJmsQueue());
        this.topic = (Topic)JndiLookupUtils.lookup(ConfigurationFactory.get().getTestJmsTopic());
    }

    public void sendQueueMessage() {
        Connection connection = null;
        Session session = null;
        MessageProducer messageProducer = null;
        TextMessage message = null;
        try {
            connection = this.connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            messageProducer = session.createProducer((Destination)this.queue);
            message = session.createTextMessage();
            message.setText(SimpleMessageProducer.class.getName());
            messageProducer.send((Message)message);
        }
        catch (JMSException e) {
            throw new RuntimeException("Cannot send message", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    simpleLogger.log(e);
                }
            }
        }
    }

    public void sendTopicMessage() {
        Connection connection = null;
        Session session = null;
        MessageProducer messageProducer = null;
        TextMessage message = null;
        try {
            connection = this.connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            messageProducer = session.createProducer((Destination)this.topic);
            message = session.createTextMessage();
            message.setText(SimpleMessageProducer.class.getName());
            messageProducer.send((Message)message);
        }
        catch (JMSException e) {
            throw new RuntimeException("Cannot send message", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    simpleLogger.log(e);
                }
            }
        }
    }
}

