/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.deserializer.types;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.eclipse.yasson.internal.deserializer.types.AbstractDateDeserializer;
import org.eclipse.yasson.internal.deserializer.types.TypeDeserializerBuilder;

class InstantDeserializer
extends AbstractDateDeserializer<Instant> {
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_INSTANT.withZone(UTC);

    InstantDeserializer(TypeDeserializerBuilder builder) {
        super(builder);
    }

    @Override
    protected Instant fromInstant(Instant instant) {
        return instant;
    }

    @Override
    protected Instant parseDefault(String jsonValue, Locale locale) {
        return Instant.from(DEFAULT_FORMATTER.withLocale(locale).parse(jsonValue));
    }

    @Override
    protected Instant parseWithFormatter(String jsonValue, DateTimeFormatter formatter) {
        return Instant.from(this.getZonedFormatter(formatter).parse(jsonValue));
    }
}

