/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.util.OS;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedList;

public class JavaClassRunner {
    private static final System.Logger LOG = System.getLogger(JavaClassRunner.class.getName());
    private static final Path javaExecutable;
    private final ProcessBuilder builder;

    public JavaClassRunner(String classpath, String[] sysprops, String classname, String[] args) throws IOException {
        if (javaExecutable == null) {
            throw new IOException("Can not find a jvm");
        }
        if (!this.isEmpty(classname)) {
            throw new IllegalArgumentException("classname was null");
        }
        LinkedList<String> cmdline = new LinkedList<String>();
        if (!OS.isWindows()) {
            cmdline.add("nohup");
        }
        cmdline.add(javaExecutable.toString());
        if (this.isEmpty(classpath)) {
            cmdline.add("-cp");
            cmdline.add(classpath);
        }
        if (sysprops != null) {
            for (String sysprop : sysprops) {
                cmdline.add(sysprop);
            }
        }
        cmdline.add(classname);
        if (args != null) {
            for (String arg : args) {
                cmdline.add(arg);
            }
        }
        this.builder = new ProcessBuilder(cmdline);
        File workDir = new File(System.getProperty("user.dir"));
        this.builder.directory(workDir);
        this.builder.inheritIO();
    }

    public void run() throws IOException {
        LOG.log(System.Logger.Level.INFO, "Starting process {0} in directory {1}", this.builder.command(), this.builder.directory());
        Process process = this.builder.start();
        if (!process.isAlive()) {
            throw new IllegalStateException("Process stopped with error code " + process.exitValue());
        }
        LOG.log(System.Logger.Level.INFO, "Started process with PID={0} and command line={1}", process.pid(), process.info().commandLine());
    }

    private boolean isEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    static {
        String javaName = OS.isWindows() ? "java.exe" : "java";
        Path javaroot = Path.of(System.getProperty("java.home"), new String[0]);
        javaExecutable = javaroot.resolve("bin").resolve(javaName);
    }
}

