/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.deserializer;

import jakarta.json.bind.JsonbException;
import java.lang.invoke.MethodHandle;
import java.util.Objects;
import org.eclipse.yasson.internal.DeserializationContextImpl;
import org.eclipse.yasson.internal.deserializer.ModelDeserializer;

class ValueSetterDeserializer
implements ModelDeserializer<Object> {
    private final MethodHandle valueSetter;

    ValueSetterDeserializer(MethodHandle valueSetter) {
        this.valueSetter = Objects.requireNonNull(valueSetter);
    }

    @Override
    public Object deserialize(Object value, DeserializationContextImpl context) {
        Object object = context.getInstance();
        try {
            this.valueSetter.invoke(object, value);
            return value;
        }
        catch (Throwable e) {
            throw new JsonbException("Error setting value on: " + object, e);
        }
    }
}

