/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.util;

import com.sun.enterprise.naming.spi.NamingObjectFactory;
import com.sun.enterprise.naming.spi.NamingUtils;
import com.sun.enterprise.naming.util.CloningNamingObjectFactory;
import com.sun.enterprise.naming.util.JndiInitializationNamingObjectFactory;
import com.sun.enterprise.naming.util.JndiNamingObjectFactory;
import com.sun.enterprise.naming.util.LogFacade;
import com.sun.enterprise.naming.util.SimpleNamingObjectFactory;
import jakarta.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.logging.Level;
import javax.naming.Context;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.common.util.ObjectInputOutputStreamFactoryFactory;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class NamingUtilsImpl
implements NamingUtils {
    @LogMessageInfo(message="Exception in NamingUtilsImpl copyMutableObject(): {0}", cause="Problem with serialising or deserialising of the object", action="Check the class hierarchy to see if all the classes are Serializable.")
    public static final String EXCEPTION_COPY_MUTABLE = "AS-NAMING-00006";

    @Override
    public <T> NamingObjectFactory createSimpleNamingObjectFactory(SimpleJndiName name, T value) {
        return new SimpleNamingObjectFactory<T>(name, value);
    }

    @Override
    public NamingObjectFactory createLazyNamingObjectFactory(SimpleJndiName name, SimpleJndiName jndiName, boolean cacheResult) {
        return new JndiNamingObjectFactory(name, jndiName, cacheResult);
    }

    @Override
    public NamingObjectFactory createLazyInitializationNamingObjectFactory(SimpleJndiName name, SimpleJndiName jndiName, boolean cacheResult) {
        return new JndiInitializationNamingObjectFactory(name, jndiName, cacheResult);
    }

    @Override
    public NamingObjectFactory createCloningNamingObjectFactory(SimpleJndiName name, NamingObjectFactory delegate) {
        return new CloningNamingObjectFactory(name, delegate);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T makeCopyOfObject(T obj) {
        if (obj instanceof Context || !(obj instanceof Serializable)) {
            return obj;
        }
        LogFacade.logger.log(Level.FINE, "makeCopyOfObject({0})", obj);
        try {
            byte[] data;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                 ObjectOutputStream oos = ObjectInputOutputStreamFactoryFactory.getFactory().createObjectOutputStream((OutputStream)bos);){
                oos.writeObject(obj);
                oos.flush();
                data = bos.toByteArray();
            }
            try (ByteArrayInputStream bis = new ByteArrayInputStream(data);){
                Object object;
                block26: {
                    ObjectInputStream ois = ObjectInputOutputStreamFactoryFactory.getFactory().createObjectInputStream((InputStream)bis);
                    try {
                        object = AccessController.doPrivileged(ois::readObject);
                        if (ois == null) break block26;
                    }
                    catch (Throwable throwable) {
                        if (ois != null) {
                            try {
                                ois.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ois.close();
                }
                return (T)object;
            }
        }
        catch (Exception ex) {
            LogFacade.logger.log(Level.SEVERE, EXCEPTION_COPY_MUTABLE, obj);
            throw new RuntimeException("Cant copy Serializable object " + String.valueOf(obj), ex);
        }
    }
}

