/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.configprovider;

import com.sun.faces.RIConstants;
import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.util.FacesLogger;
import jakarta.servlet.ServletContext;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebAppFlowConfigResourceProvider
implements ConfigurationResourceProvider {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();

    @Override
    public Collection<URI> getResources(ServletContext context) {
        List<URI> list = Collections.emptyList();
        Set allPaths = context.getResourcePaths("/");
        if (null == allPaths) {
            return list;
        }
        list = null;
        for (String cur : allPaths) {
            if (cur.startsWith("/META-INF")) continue;
            if (cur.equals("/WEB-INF/")) {
                Set webInfPaths = context.getResourcePaths(cur);
                if (null == webInfPaths) continue;
                for (String webInfCur : webInfPaths) {
                    if (cur.equals("/WEB-INF/classes/") || !webInfCur.endsWith("/")) continue;
                    list = this.inspectDirectory(context, webInfCur, list);
                }
                continue;
            }
            if (!cur.endsWith("/")) continue;
            list = this.inspectDirectory(context, cur, list);
        }
        return null == list ? Collections.emptyList() : list;
    }

    private List<URI> inspectDirectory(ServletContext context, String toInspect, List<URI> list) {
        URL curUrl = null;
        Set allPaths = context.getResourcePaths(toInspect);
        if (null == allPaths) {
            return list;
        }
        for (String cur : allPaths) {
            String dirName;
            int suffixIndex;
            int slash;
            if (!cur.endsWith("-flow.xml") || -1 == (slash = cur.lastIndexOf("/", suffixIndex = cur.length() - RIConstants.FLOW_DEFINITION_ID_SUFFIX_LENGTH))) continue;
            String flowName = cur.substring(slash + 1, suffixIndex);
            int prevSlash = cur.lastIndexOf("/", slash - 1);
            if (-1 == prevSlash || !(dirName = cur.substring(prevSlash + 1, slash)).equals(flowName)) continue;
            if (null == list) {
                list = new ArrayList<URI>();
            }
            try {
                curUrl = context.getResource(cur);
                list.add(curUrl.toURI());
            }
            catch (MalformedURLException ex) {
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.log(Level.SEVERE, "Unable to get resource for {0}" + cur, ex);
            }
            catch (URISyntaxException use) {
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.log(Level.SEVERE, "Unable to get URI for {0}" + curUrl.toExternalForm(), use);
            }
        }
        return list;
    }
}

