/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.persistence.jpa.PersistenceUnitInfoImpl;
import org.glassfish.persistence.jpa.ProviderContainerContractInfo;
import org.glassfish.persistence.jpa.schemageneration.SchemaGenerationProcessor;
import org.glassfish.persistence.jpa.schemageneration.SchemaGenerationProcessorFactory;

public class PersistenceUnitLoader {
    private static Logger logger = LogDomains.getLogger(PersistenceUnitLoader.class, (String)"jakarta.org.glassfish.persistence");
    private static final StringManager localStrings = StringManager.getManager(PersistenceUnitLoader.class);
    private static Map<String, String> integrationProperties;
    private static final String ECLIPSELINK_WEAVING_PROPERTY = "eclipselink.weaving";
    private static final String VALIDATION_MODE_PROPERTY = "jakarta.persistence.validation.mode";
    private static final String VALIDATOR_FACTORY = "jakarta.persistence.validation.factory";
    private static final String DISABLE_UPGRADE_FROM_TOPLINK_ESSENTIALS = "org.glassfish.persistence.jpa.disable.upgrade.from.toplink.essentials";
    private final ProviderContainerContractInfo providerContainerContractInfo;
    private EntityManagerFactory entityManagerFactory;
    private SchemaGenerationProcessor schemaGenerationProcessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceUnitLoader(PersistenceUnitDescriptor persistenceUnitToInstantiate, ProviderContainerContractInfo providerContainerContractInfo) {
        this.providerContainerContractInfo = providerContainerContractInfo;
        this.setSystemPropertyToEnableDoPrivilegedInEclipseLink();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(providerContainerContractInfo.getClassLoader());
        try {
            this.entityManagerFactory = this.loadPersistenceUnit(persistenceUnitToInstantiate);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    private void setSystemPropertyToEnableDoPrivilegedInEclipseLink() {
        String PROPERTY_NAME = "eclipselink.security.usedoprivileged";
        if (System.getProperty("eclipselink.security.usedoprivileged") == null) {
            System.setProperty("eclipselink.security.usedoprivileged", String.valueOf(Boolean.TRUE));
        }
    }

    private EntityManagerFactory loadPersistenceUnit(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        ValidationMode validationMode;
        Map<String, Object> schemaGenerationOverrides;
        PersistenceProvider provider;
        this.checkForUpgradeFromTopLinkEssentials(persistenceUnitDescriptor);
        this.checkForDataSourceOverride(persistenceUnitDescriptor);
        this.calculateDefaultDataSource(persistenceUnitDescriptor);
        PersistenceUnitInfoImpl persistenceUnitInfo = new PersistenceUnitInfoImpl(persistenceUnitDescriptor, this.providerContainerContractInfo);
        String applicationLocation = this.providerContainerContractInfo.getApplicationLocation();
        boolean fineMsgLoggable = logger.isLoggable(Level.FINE);
        if (fineMsgLoggable) {
            logger.fine("Loading persistence unit for application: \"" + applicationLocation + "\"pu Root is: " + persistenceUnitDescriptor.getPuRoot());
            logger.fine("PersistenceInfo for this pud is :\n" + String.valueOf(persistenceUnitInfo));
        }
        try {
            provider = (PersistenceProvider)PersistenceProvider.class.cast(this.providerContainerContractInfo.getClassLoader().loadClass(persistenceUnitInfo.getPersistenceProviderClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new RuntimeException(e);
        }
        this.schemaGenerationProcessor = SchemaGenerationProcessorFactory.createSchemaGenerationProcessor(persistenceUnitDescriptor);
        if (this.providerContainerContractInfo.isJava2DBRequired()) {
            this.schemaGenerationProcessor.init(persistenceUnitDescriptor, this.providerContainerContractInfo.getDeploymentContext());
            schemaGenerationOverrides = this.schemaGenerationProcessor.getOverridesForSchemaGeneration();
        } else {
            schemaGenerationOverrides = this.schemaGenerationProcessor.getOverridesForSuppressingSchemaGeneration();
        }
        HashMap<String, String> overRides = new HashMap<String, String>(integrationProperties);
        if (schemaGenerationOverrides != null) {
            overRides.putAll(schemaGenerationOverrides);
        }
        if ((validationMode = this.getValidationMode(persistenceUnitDescriptor)) == ValidationMode.AUTO || validationMode == ValidationMode.CALLBACK) {
            overRides.put(VALIDATOR_FACTORY, (String)this.providerContainerContractInfo.getValidatorFactory());
        }
        if (!this.providerContainerContractInfo.isWeavingEnabled()) {
            overRides.put(ECLIPSELINK_WEAVING_PROPERTY, System.getProperty(ECLIPSELINK_WEAVING_PROPERTY, "false"));
        }
        EntityManagerFactory entityManagerFactory = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)persistenceUnitInfo, overRides);
        logger.logp(Level.FINE, "PersistenceUnitLoader", "loadPU", "emf = {0}", entityManagerFactory);
        this.providerContainerContractInfo.registerEMF(persistenceUnitInfo.getPersistenceUnitName(), persistenceUnitDescriptor.getPuRoot(), persistenceUnitDescriptor.getParent().getParent(), entityManagerFactory);
        if (fineMsgLoggable) {
            logger.fine("Finished loading persistence unit for application: " + applicationLocation);
        }
        return entityManagerFactory;
    }

    private void checkForDataSourceOverride(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        SimpleJndiName jtaDataSourceOverride = this.providerContainerContractInfo.getJTADataSourceOverride();
        if (jtaDataSourceOverride != null) {
            persistenceUnitDescriptor.setJtaDataSource(jtaDataSourceOverride);
        }
    }

    private void calculateDefaultDataSource(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        SimpleJndiName jtaDataSourceName = this.calculateJtaDataSourceName(persistenceUnitDescriptor.getTransactionType(), persistenceUnitDescriptor.getJtaDataSource(), persistenceUnitDescriptor.getNonJtaDataSource(), persistenceUnitDescriptor.getName());
        SimpleJndiName nonJtaDataSourceName = this.calculateNonJtaDataSourceName(persistenceUnitDescriptor.getJtaDataSource(), persistenceUnitDescriptor.getNonJtaDataSource());
        persistenceUnitDescriptor.setJtaDataSource(jtaDataSourceName);
        persistenceUnitDescriptor.setNonJtaDataSource(nonJtaDataSourceName);
    }

    private SimpleJndiName calculateJtaDataSourceName(String transactionType, SimpleJndiName userSuppliedJTADSName, SimpleJndiName userSuppliedNonJTADSName, String puName) {
        SimpleJndiName dataSourceName;
        if (PersistenceUnitTransactionType.valueOf((String)transactionType) != PersistenceUnitTransactionType.JTA) {
            logger.logp(Level.FINE, "PersistenceUnitInfoImpl", "_getJtaDataSource", "This PU is configured as non-jta, so jta-data-source is null");
            return null;
        }
        if (!PersistenceUnitLoader.isNullOrEmpty(userSuppliedJTADSName)) {
            dataSourceName = userSuppliedJTADSName;
        } else if (PersistenceUnitLoader.isNullOrEmpty(userSuppliedNonJTADSName)) {
            dataSourceName = this.providerContainerContractInfo.getDefaultDataSourceName();
        } else {
            String msg = localStrings.getString("puinfo.jta-ds-not-configured", new Object[]{puName});
            throw new RuntimeException(msg);
        }
        logger.logp(Level.FINE, "PersistenceUnitLoaderImpl", "_getJtaDataSource", "JTADSName = {0}", dataSourceName);
        return dataSourceName;
    }

    private SimpleJndiName calculateNonJtaDataSourceName(SimpleJndiName userSuppliedJTADSName, SimpleJndiName userSuppliedNonJTADSName) {
        SimpleJndiName dataSourceName = !PersistenceUnitLoader.isNullOrEmpty(userSuppliedNonJTADSName) ? userSuppliedNonJTADSName : (!PersistenceUnitLoader.isNullOrEmpty(userSuppliedJTADSName) ? userSuppliedJTADSName : this.providerContainerContractInfo.getDefaultDataSourceName());
        logger.logp(Level.FINE, "PersistenceUnitInfoImpl", "_getNonJtaDataSource", "nonJTADSName = {0}", dataSourceName);
        return dataSourceName;
    }

    private static boolean isNullOrEmpty(SimpleJndiName s) {
        return s == null || s.isEmpty();
    }

    private void checkForUpgradeFromTopLinkEssentials(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        if (Boolean.getBoolean(DISABLE_UPGRADE_FROM_TOPLINK_ESSENTIALS)) {
            return;
        }
        boolean upgradeTopLinkEssentialsProperties = false;
        String providerClassName = persistenceUnitDescriptor.getProvider();
        if (providerClassName == null || providerClassName.isEmpty()) {
            upgradeTopLinkEssentialsProperties = true;
        } else if ("oracle.toplink.essentials.PersistenceProvider".equals(providerClassName) || "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider".equals(providerClassName)) {
            try {
                this.providerContainerContractInfo.getClassLoader().loadClass(providerClassName);
            }
            catch (ClassNotFoundException e) {
                String defaultProvider = PersistenceUnitInfoImpl.getDefaultprovider();
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "puloader.defaulting.provider.on.upgrade", new Object[]{persistenceUnitDescriptor.getName(), defaultProvider});
                }
                persistenceUnitDescriptor.setProvider(defaultProvider);
                upgradeTopLinkEssentialsProperties = true;
            }
        }
        if (upgradeTopLinkEssentialsProperties) {
            String TOPLINK = "toplink";
            String ECLIPSELINK = "eclipselink";
            Properties properties = persistenceUnitDescriptor.getProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("toplink")) continue;
                String translatedKey = "eclipselink" + key.substring("toplink".length());
                persistenceUnitDescriptor.addProperty(translatedKey, entry.getValue());
            }
        }
    }

    void doJava2DB() {
        if (this.schemaGenerationProcessor.isContainerDDLExecutionRequired()) {
            logger.fine("<--- To Create Tables");
            this.schemaGenerationProcessor.executeCreateDDL();
            logger.fine("---> Done Create Tables");
        }
    }

    private ValidationMode getValidationMode(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        ValidationMode validationMode = persistenceUnitDescriptor.getValidationMode();
        String validationModeFromProperty = (String)persistenceUnitDescriptor.getProperties().get(VALIDATION_MODE_PROPERTY);
        if (validationModeFromProperty != null) {
            validationMode = ValidationMode.valueOf((String)validationModeFromProperty);
        }
        return validationMode;
    }

    static {
        HashMap<String, String> props = new HashMap<String, String>();
        String ECLIPSELINK_SERVER_PLATFORM_CLASS_NAME_PROPERTY = "eclipselink.target-server";
        props.put("eclipselink.target-server", System.getProperty("eclipselink.target-server", "Glassfish"));
        String HIBERNATE_TRANSACTION_MANAGER_LOOKUP_CLASS_PROPERTY = "hibernate.transaction.manager_lookup_class";
        props.put("hibernate.transaction.manager_lookup_class", System.getProperty("hibernate.transaction.manager_lookup_class", "org.hibernate.transaction.SunONETransactionManagerLookup"));
        integrationProperties = Collections.unmodifiableMap(props);
    }
}

