/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.ldap;

import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.SharedSecureRandom;

public class CustomSocketFactory
extends SocketFactory
implements Comparator<SocketFactory> {
    public static final String SSL = "SSL";
    protected static final Logger _logger = SecurityLoggerInfo.getLogger();
    protected static final StringManager sm = StringManager.getManager(CustomSocketFactory.class);
    private static final CustomSocketFactory customSocketFactory = new CustomSocketFactory();
    private SocketFactory socketFactory;

    public CustomSocketFactory() {
        SSLUtils sslUtils = (SSLUtils)Globals.get(SSLUtils.class);
        try {
            SSLContext sslContext = SSLContext.getInstance(SSL);
            sslContext.init(sslUtils.getKeyManagers(), sslUtils.getTrustManagers(), SharedSecureRandom.SECURE_RANDOM);
            this.socketFactory = sslContext.getSocketFactory();
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "NCLS-SECURITY-01000", ex);
        }
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.socketFactory.createSocket();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.socketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.socketFactory.createSocket(address, port, localAddress, localPort);
    }

    @Override
    public int compare(SocketFactory s1, SocketFactory s2) {
        return s1.getClass().toString().compareTo(s2.getClass().toString());
    }

    public static SocketFactory getDefault() {
        return customSocketFactory;
    }
}

