/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.util;

import com.sun.tdk.signaturetest.util.BatchFileParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.OptionInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class CommandLineParser {
    private Object servicedObject;
    private KnownOptions knownOptions;
    private Map decoders = new HashMap();
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(CommandLineParser.class);
    private Map foundOptions = new HashMap();

    public CommandLineParser(Object servicedObject, String optionPrefix) {
        this.servicedObject = servicedObject;
        this.knownOptions = new KnownOptions(optionPrefix);
    }

    public final void addOption(String option, OptionInfo info) {
        String temp = option;
        if (!info.isCaseSentitive()) {
            temp = option.toLowerCase();
        }
        this.knownOptions.add(temp, info);
    }

    public final void addOption(String option, OptionInfo info, String decoder) {
        String temp = option;
        if (!info.isCaseSentitive()) {
            temp = option.toLowerCase();
        }
        this.knownOptions.add(temp, info);
        this.decoders.put(temp, decoder);
    }

    public final void removeKnownOption(String option) {
        this.knownOptions.remove(option);
    }

    public void processArgs(String[] args) throws CommandLineParserException {
        args = BatchFileParser.processParameters(args);
        this.foundOptions.clear();
        String optionStr = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.knownOptions.isKnownOption(arg)) {
                OptionInfo ki = this.knownOptions.get(arg);
                optionStr = ki.toKey(arg);
                ArrayList params = (ArrayList)this.foundOptions.get(optionStr);
                if (params == null) {
                    this.foundOptions.put(optionStr, new ArrayList());
                    continue;
                }
                if (ki.isMultiple()) continue;
                throw new CommandLineParserException(i18n.getString("CommandLineParser.error.option.duplicate", (Object)optionStr));
            }
            if (!this.knownOptions.isOption(arg)) {
                if (optionStr == null) continue;
                ((List)this.foundOptions.get(optionStr)).add(arg);
                continue;
            }
            throw new CommandLineParserException(i18n.getString("CommandLineParser.error.option.unknown", (Object)arg));
        }
        this.knownOptions.validate(this.foundOptions);
        for (String foundOption : this.foundOptions.keySet()) {
            this.invokeDecoder(foundOption, (ArrayList)this.foundOptions.get(foundOption));
        }
    }

    public boolean isOptionSpecified(String arg, String checkedOption) {
        return this.knownOptions.isOption(arg) && checkedOption.equalsIgnoreCase(arg);
    }

    public boolean isOptionSpecified(String option) {
        if (!this.knownOptions.isKnownOption(option)) {
            throw new IllegalArgumentException(i18n.getString("CommandLineParser.error.option.unknown", (Object)option));
        }
        OptionInfo ki = this.knownOptions.get(option);
        String temp = ki.toKey(option);
        return this.foundOptions.get(temp) != null;
    }

    private void invokeDecoder(String option, ArrayList params) throws CommandLineParserException {
        String decoder = (String)this.decoders.get(option);
        if (decoder != null) {
            this.invokeExplicitDecoder(decoder, option, params);
        } else {
            this.invokeDefaultDecoder(option, params);
        }
    }

    private void invokeExplicitDecoder(String decoder, String option, ArrayList params) throws CommandLineParserException {
        Class<?> cl = this.servicedObject.getClass();
        String[] stemp = new String[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            stemp[i] = (String)params.get(i);
        }
        try {
            Method method = cl.getMethod(decoder, String.class, String[].class);
            method.invoke(this.servicedObject, option, stemp);
        }
        catch (NoSuchMethodException nsme) {
            throw new CommandLineParserException(i18n.getString("CommandLineParser.error.decoder.explicit.notfound", decoder, option, cl.getName()), nsme);
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getTargetException();
            String message = th instanceof CommandLineParserException ? th.getMessage() : i18n.getString("CommandLineParser.error.decoder.failed", option, th);
            throw new CommandLineParserException(message);
        }
        catch (Exception e) {
            throw new CommandLineParserException(i18n.getString("CommandLineParser.error.decoder.failed", option, e));
        }
    }

    private void invokeDefaultDecoder(String option, ArrayList params) throws CommandLineParserException {
        try {
            String[] stemp = new String[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                stemp[i] = (String)params.get(i);
            }
            this.getDefaultDecoderMethod(option).invoke(this.servicedObject, new Object[]{stemp});
        }
        catch (Exception e) {
            throw new CommandLineParserException(i18n.getString("CommandLineParser.error.decoder.failed", option, e));
        }
    }

    private boolean isDecoder(Method method, String option) {
        String methodName = "decode" + option;
        return method.getName().equalsIgnoreCase(methodName) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].isAssignableFrom(String[].class);
    }

    private Method getDefaultDecoderMethod(String option) throws CommandLineParserException {
        Method m = this.getDefaultDecoderMethod(this.servicedObject.getClass().getMethods(), option);
        if (m == null) {
            throw new CommandLineParserException(i18n.getString("CommandLineParser.error.decoder.default.notfound", option, this.servicedObject.getClass().getName()));
        }
        return m;
    }

    private Method getDefaultDecoderMethod(Method[] methods, String option) {
        for (int i = 0; i < methods.length; ++i) {
            if (!this.isDecoder(methods[i], option)) continue;
            return methods[i];
        }
        return null;
    }

    public static String[] parseListOption(String[] args) {
        ArrayList<String> ar = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            StringTokenizer st = new StringTokenizer(args[i], System.getProperty("path.separator"));
            while (st.hasMoreTokens()) {
                ar.add(st.nextToken());
            }
        }
        return ar.toArray(new String[0]);
    }

    private static class KnownOptions {
        private Map data = new HashMap();
        private final String optionPrefix;

        public KnownOptions(String optionPrefix) {
            this.optionPrefix = optionPrefix;
        }

        private boolean isKnownOption(String arg) {
            if (this.isOption(arg)) {
                String temp = arg;
                if (!this.data.containsKey(temp)) {
                    OptionInfo ki = (OptionInfo)this.data.get(temp = temp.toLowerCase());
                    if (ki != null) {
                        return !ki.isCaseSentitive();
                    }
                } else {
                    return true;
                }
            }
            return false;
        }

        private void add(String option, OptionInfo info) {
            if (!option.startsWith(this.optionPrefix)) {
                throw new IllegalArgumentException(i18n.getString("CommandLineParser.error.option.noprefix", (Object)this.optionPrefix));
            }
            this.data.put(option, info);
        }

        private void remove(String option) {
            this.data.remove(option);
        }

        private OptionInfo get(String option) {
            String temp = option;
            OptionInfo ki = (OptionInfo)this.data.get(temp);
            if (ki == null && ((ki = (OptionInfo)this.data.get(temp = temp.toLowerCase())) == null || ki.isCaseSentitive())) {
                return null;
            }
            return ki;
        }

        private void validateRequiredOptions(Set foundKeys) throws CommandLineParserException {
            Set keySet = this.data.keySet();
            for (String option : keySet) {
                OptionInfo ki = (OptionInfo)this.data.get(option);
                if (!ki.isRequired() || foundKeys.contains(option)) continue;
                throw new CommandLineParserException(i18n.getString("CommandLineParser.error.option.required", (Object)option));
            }
        }

        private void validateCount(String option, int paramCount) throws CommandLineParserException {
            OptionInfo info = (OptionInfo)this.data.get(option);
            int minCount = info.getMinCount();
            int maxCount = info.getMaxCount();
            if (paramCount < minCount) {
                throw new CommandLineParserException(i18n.getString("CommandLineParser.error.option.require_more_parameters", option, new Integer(minCount)));
            }
            if (paramCount > maxCount) {
                String msg = i18n.getString("CommandLineParser.error.option.require_less_parameters", option, new Integer(maxCount));
                if (maxCount == 0) {
                    msg = i18n.getString("CommandLineParser.error.option.require_no_parameters", (Object)option);
                }
                throw new CommandLineParserException(msg);
            }
        }

        private void validate(Map params) throws CommandLineParserException {
            this.validateRequiredOptions(params.keySet());
            for (String option : params.keySet()) {
                this.validateCount(option, ((List)params.get(option)).size());
            }
        }

        public boolean isOption(String arg) {
            return arg.startsWith(this.optionPrefix);
        }
    }
}

