/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._double.maxinclusive.maxinclusive_3;

import jakarta.xml.bind.*;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class maxInclusive3_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        maxInclusive3_GetSetCTTests test = new maxInclusive3_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    static strictfp boolean equal(double a, double b) { return a == b; };

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "maxInclusive-3-1.xml", "maxInclusive-3-2.xml", "maxInclusive-3-3.xml",
            "maxInclusive-3-4.xml", "maxInclusive-3-5.xml"
        };
        double[] expectedValues = {0.0, 0.0, 0.0, 0.0, 0.0,};
        double[] anExpectedValues = {0.0, - Double.MIN_VALUE, -1.0, - Double.MAX_VALUE
                                    , Double.NEGATIVE_INFINITY};
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<Double> elemObj = (JAXBElement<Double>)unmarshal(xmlDocNames[i]);
            if (!equal(elemObj.getValue(), expectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (!equal(elemObj.getValue(), anExpectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        double[] setValues = {0.0, - Double.MIN_VALUE, -1.0, - Double.MAX_VALUE
                             , Double.NEGATIVE_INFINITY};
        double[] anSetValues = {Double.NEGATIVE_INFINITY, -1.0, - Double.MAX_VALUE
                               , - Double.MIN_VALUE, 0.0};
        JAXBElement<Double> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<Double>)(new ObjectFactory()).createNISTSchemaDoubleMaxInclusive3(setValues[i]);
            
            if (!equal(elemObj.getValue(), setValues[i])){
                return Status.failed("dynamically created JAXBElement<Double>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (!equal(elemObj.getValue(), anSetValues[i])){
                return Status.failed("dynamically created JAXBElement<Double>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

