/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.config;

import com.sun.ts.tests.jaspic.tssv.config.TSClientAuthContext;
import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ClientAuthContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class TSClientAuthConfig
implements ClientAuthConfig {
    private static String messageLayer = null;
    private static String appContext = null;
    private static CallbackHandler callbackHandler = null;
    private static TSLogger logger = null;
    private Map properties = null;

    public TSClientAuthConfig(String layer, String applicationCtxt, CallbackHandler cbkHandler, Map props) {
        messageLayer = layer;
        appContext = applicationCtxt;
        callbackHandler = cbkHandler;
        this.properties = props;
    }

    public TSClientAuthConfig(String layer, String applicationCtxt, CallbackHandler cbkHandler, Map props, TSLogger tsLogger) {
        this(layer, applicationCtxt, cbkHandler, props);
        logger = tsLogger;
        String str = "TSClientAuthConfig called for  layer=" + layer + " : appContext=" + applicationCtxt;
        logger.log(Level.INFO, str);
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        String rval = null;
        logger.log(Level.INFO, "TSClientAuthConfig.getOperation called");
        if (messageLayer.equals("SOAP")) {
            return this.getOpName((SOAPMessage)messageInfo.getRequestMessage());
        }
        if (messageLayer.equals("HttpServlet")) {
            HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
            rval = request.getServletPath() + " " + request.getMethod();
            return rval;
        }
        return null;
    }

    private String getOpName(SOAPMessage message) {
        Name name;
        String[] actions;
        if (message == null) {
            return null;
        }
        String rvalue = null;
        MimeHeaders headers = message.getMimeHeaders();
        if (headers != null && (actions = headers.getHeader("SOAPAction")) != null && actions.length > 0 && (rvalue = actions[0]) != null && rvalue.equals("\"\"")) {
            rvalue = null;
        }
        if (rvalue == null && (name = this.getName(message)) != null) {
            rvalue = name.getLocalName();
        }
        return rvalue;
    }

    private Name getName(SOAPMessage message) {
        Name rvalue;
        block4: {
            rvalue = null;
            SOAPPart soap = message.getSOAPPart();
            if (soap != null) {
                try {
                    SOAPBody body;
                    SOAPEnvelope envelope = soap.getEnvelope();
                    if (envelope == null || (body = envelope.getBody()) == null) break block4;
                    Iterator it = body.getChildElements();
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (!(o instanceof SOAPElement)) continue;
                        rvalue = ((SOAPElement)o).getElementName();
                        break;
                    }
                }
                catch (SOAPException se) {
                    logger.log(Level.INFO, "WSS: Unable to get SOAP envelope");
                }
            }
        }
        return rvalue;
    }

    public void refresh() {
    }

    public String getMessageLayer() {
        return messageLayer;
    }

    public String getAppContext() {
        return appContext;
    }

    public ClientAuthContext getAuthContext(String operation, Subject clientSubject, Map properties) throws AuthException {
        this.properties.putAll(properties);
        try {
            String logStr = "TSClientAuthConfig.getAuthContext:  layer=" + messageLayer + " : appContext=" + appContext;
            logger.log(Level.INFO, logStr);
            logger.log(Level.INFO, "TSClientAuthConfig.getAuthContext:  layer=" + messageLayer + " : appContext=" + appContext + " operationId=" + operation);
            TSClientAuthContext clientAuthContext = new TSClientAuthContext(messageLayer, appContext, callbackHandler, operation, clientSubject, this.properties, logger);
            logStr = "TSClientAuthConfig.getAuthContext: returned non-null ClientAuthContext for operationId=" + operation;
            logger.log(Level.INFO, logStr);
            return clientAuthContext;
        }
        catch (Exception e) {
            throw new AuthException(e.getMessage());
        }
    }

    public boolean isProtected() {
        return true;
    }
}

