/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.arquillian.junit.AdaptorManagerWithNotifier;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.junit.InSequenceSorter;
import org.jboss.arquillian.junit.JUnitClassRulesFilter;
import org.jboss.arquillian.junit.JavaSPILoader;
import org.jboss.arquillian.junit.MethodInvoker;
import org.jboss.arquillian.junit.State;
import org.jboss.arquillian.junit.event.AfterRules;
import org.jboss.arquillian.junit.event.BeforeRules;
import org.jboss.arquillian.junit.event.RulesEnrichment;
import org.jboss.arquillian.test.spi.LifecycleMethodExecutor;
import org.jboss.arquillian.test.spi.TestRunnerAdaptor;
import org.jboss.arquillian.test.spi.event.suite.TestLifecycleEvent;
import org.junit.internal.runners.model.MultipleFailureException;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.Fail;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class Arquillian
extends BlockJUnit4ClassRunner {
    private TestRunnerAdaptor adaptor;

    public Arquillian(Class<?> testClass) throws InitializationError {
        super(testClass);
        if (State.isRunningInEclipse()) {
            State.runnerStarted();
        }
    }

    protected List<FrameworkMethod> getChildren() {
        List children = super.getChildren();
        boolean hasDefinedOrder = false;
        for (FrameworkMethod method : children) {
            if (method.getAnnotation(InSequence.class) == null) continue;
            hasDefinedOrder = true;
        }
        if (hasDefinedOrder) {
            ArrayList<FrameworkMethod> sorted = new ArrayList<FrameworkMethod>(children);
            Collections.sort(sorted, new InSequenceSorter());
            return sorted;
        }
        return children;
    }

    public void run(RunNotifier notifier) {
        if (State.hasAnyArquillianRule(this.getTestClass())) {
            throw new RuntimeException(String.format("TestClass: %s contains Arquillian runner and Arquillian Rule. Arquillian doesn't support @RunWith(Arquillian.class) and ArquillianTestClass or ArquillianTest to use at the same time. You have to decide whether you want use runner: http://arquillian.org/arquillian-core/#how-it-works or rules : http://arquillian.org/arquillian-core/#_how_to_use_it", this.getTestClass().getName()));
        }
        if (State.isNotRunningInEclipse()) {
            State.runnerStarted();
        }
        AdaptorManagerWithNotifier adaptorManager = new AdaptorManagerWithNotifier(notifier){

            @Override
            protected void setAdaptor(TestRunnerAdaptor testRunnerAdaptor) {
                Arquillian.this.adaptor = testRunnerAdaptor;
            }

            @Override
            protected TestRunnerAdaptor getAdaptor() {
                return Arquillian.this.adaptor;
            }

            @Override
            protected Description getFailureDescription() {
                return Arquillian.this.getDescription();
            }
        };
        adaptorManager.initializeAdaptor();
        adaptorManager.prepareDestroyAdaptorProcess();
        if (State.hasTestAdaptor()) {
            super.run(notifier);
        }
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        List methods = this.getTestClass().getAnnotatedMethods(annotation);
        for (FrameworkMethod eachTestMethod : methods) {
            eachTestMethod.validatePublicVoid(isStatic, errors);
        }
    }

    protected List<TestRule> classRules() {
        List<JUnitClassRulesFilter> junitClassRulesFilters = new JavaSPILoader().all(Arquillian.class.getClassLoader(), JUnitClassRulesFilter.class);
        List<TestRule> result = super.classRules();
        if (!junitClassRulesFilters.isEmpty()) {
            for (JUnitClassRulesFilter junitClassRulesFilter : junitClassRulesFilters) {
                result = junitClassRulesFilter.filter(result);
            }
        }
        return result;
    }

    protected Statement withBeforeClasses(final Statement originalStatement) {
        final Statement onlyBefores = super.withBeforeClasses((Statement)new EmptyStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                Arquillian.this.adaptor.beforeClass(Arquillian.this.getTestClass().getJavaClass(), (LifecycleMethodExecutor)new StatementLifecycleExecutor(onlyBefores));
                originalStatement.evaluate();
            }
        };
    }

    protected Statement withAfterClasses(final Statement originalStatement) {
        final Statement onlyAfters = super.withAfterClasses((Statement)new EmptyStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                Arquillian.this.multiExecute(new Statement[]{originalStatement, new Statement(){

                    public void evaluate() throws Throwable {
                        Arquillian.this.adaptor.afterClass(Arquillian.this.getTestClass().getJavaClass(), (LifecycleMethodExecutor)new StatementLifecycleExecutor(onlyAfters));
                    }
                }});
            }
        };
    }

    protected Statement withBefores(final FrameworkMethod method, final Object target, final Statement originalStatement) {
        final Statement onlyBefores = super.withBefores(method, target, (Statement)new EmptyStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                Arquillian.this.adaptor.before(target, method.getMethod(), (LifecycleMethodExecutor)new StatementLifecycleExecutor(onlyBefores));
                originalStatement.evaluate();
            }
        };
    }

    protected Statement withAfters(final FrameworkMethod method, final Object target, final Statement originalStatement) {
        final Statement onlyAfters = super.withAfters(method, target, (Statement)new EmptyStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                Arquillian.this.multiExecute(new Statement[]{originalStatement, new Statement(){

                    public void evaluate() throws Throwable {
                        Arquillian.this.adaptor.after(target, method.getMethod(), (LifecycleMethodExecutor)new StatementLifecycleExecutor(onlyAfters));
                    }
                }});
            }
        };
    }

    protected Statement methodBlock(final FrameworkMethod method) {
        Object temp;
        try {
            temp = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return Arquillian.this.createTest();
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
        final Object test = temp;
        try {
            Method withRules = BlockJUnit4ClassRunner.class.getDeclaredMethod("withRules", FrameworkMethod.class, Object.class, Statement.class);
            withRules.setAccessible(true);
            Statement statement = this.methodInvoker(method, test);
            statement = this.possiblyExpectingExceptions(method, test, statement);
            statement = this.withPotentialTimeout(method, test, statement);
            Statement arounds = this.withBefores(method, test, statement);
            final Statement stmtWithLifecycle = arounds = this.withAfters(method, test, arounds);
            this.adaptor.fireCustomLifecycle((TestLifecycleEvent)new RulesEnrichment(test, this.getTestClass(), method.getMethod(), LifecycleMethodExecutor.NO_OP));
            final Statement stmtWithRules = (Statement)withRules.invoke((Object)this, method, test, arounds);
            return new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void evaluate() throws Throwable {
                    ArrayList<Throwable> exceptions;
                    block15: {
                        State.caughtExceptionAfterJunit(null);
                        final AtomicInteger integer = new AtomicInteger();
                        exceptions = new ArrayList<Throwable>();
                        try {
                            Arquillian.this.adaptor.fireCustomLifecycle((TestLifecycleEvent)new BeforeRules(test, Arquillian.this.getTestClass(), stmtWithRules, method.getMethod(), new LifecycleMethodExecutor(){

                                public void invoke() throws Throwable {
                                    integer.incrementAndGet();
                                    stmtWithRules.evaluate();
                                }
                            }));
                            if (integer.get() != 0) break block15;
                            try {
                                stmtWithLifecycle.evaluate();
                            }
                            catch (Throwable t) {
                                State.caughtExceptionAfterJunit(t);
                                throw t;
                            }
                        }
                        catch (Throwable t) {
                            State.caughtExceptionAfterJunit(t);
                            exceptions.add(t);
                        }
                        finally {
                            try {
                                Arquillian.this.adaptor.fireCustomLifecycle((TestLifecycleEvent)new AfterRules(test, method.getMethod(), LifecycleMethodExecutor.NO_OP));
                            }
                            catch (Throwable t) {
                                State.caughtExceptionAfterJunit(t);
                                exceptions.add(t);
                            }
                        }
                    }
                    if (exceptions.isEmpty()) {
                        return;
                    }
                    if (exceptions.size() == 1) {
                        throw (Throwable)exceptions.get(0);
                    }
                    throw new MultipleFailureException(exceptions);
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create statement", e);
        }
    }

    protected Statement methodInvoker(final FrameworkMethod method, final Object test) {
        return new Statement(){

            public void evaluate() throws Throwable {
                new MethodInvoker(){

                    @Override
                    void invokeMethod(Object ... parameters) throws Throwable {
                        try {
                            method.invokeExplosively(test, parameters);
                        }
                        catch (Throwable e) {
                            State.caughtTestException(e);
                            throw e;
                        }
                    }
                }.invoke(Arquillian.this.adaptor, method, test);
            }
        };
    }

    private void multiExecute(Statement ... statements) throws Throwable {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (Statement command : statements) {
            try {
                command.evaluate();
            }
            catch (Throwable e) {
                exceptions.add(e);
            }
        }
        if (exceptions.isEmpty()) {
            return;
        }
        if (exceptions.size() == 1) {
            throw (Throwable)exceptions.get(0);
        }
        throw new MultipleFailureException(exceptions);
    }

    private static class StatementLifecycleExecutor
    implements LifecycleMethodExecutor {
        private Statement statement;

        public StatementLifecycleExecutor(Statement statement) {
            this.statement = statement;
        }

        public void invoke() throws Throwable {
            this.statement.evaluate();
        }
    }

    private static class EmptyStatement
    extends Statement {
        private EmptyStatement() {
        }

        public void evaluate() throws Throwable {
        }
    }
}

