/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.jbosscommon51;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.InjectionTargetType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.PersistenceUnitRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.InjectionTargetTypeImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitRefTypeImpl<T>
implements Child<T>,
PersistenceUnitRefType<T> {
    private T t;
    private Node childNode;

    public PersistenceUnitRefTypeImpl(T t, String nodeName, Node node) {
        this.t = t;
        this.childNode = node.createChild(nodeName);
    }

    public PersistenceUnitRefTypeImpl(T t, String nodeName, Node node, Node childNode) {
        this.t = t;
        this.childNode = childNode;
    }

    public T up() {
        return this.t;
    }

    public PersistenceUnitRefType<T> jndiName(String jndiName) {
        this.childNode.getOrCreate("jndi-name").text(jndiName);
        return this;
    }

    public String getJndiName() {
        return this.childNode.getTextValueForPatternName("jndi-name");
    }

    public PersistenceUnitRefType<T> removeJndiName() {
        this.childNode.removeChildren("jndi-name");
        return this;
    }

    public PersistenceUnitRefType<T> mappedName(String mappedName) {
        this.childNode.getOrCreate("mapped-name").text(mappedName);
        return this;
    }

    public String getMappedName() {
        return this.childNode.getTextValueForPatternName("mapped-name");
    }

    public PersistenceUnitRefType<T> removeMappedName() {
        this.childNode.removeChildren("mapped-name");
        return this;
    }

    public InjectionTargetType<PersistenceUnitRefType<T>> getOrCreateInjectionTarget() {
        List nodeList = this.childNode.get("injection-target");
        if (nodeList != null && nodeList.size() > 0) {
            return new InjectionTargetTypeImpl<PersistenceUnitRefType<T>>(this, "injection-target", this.childNode, (Node)nodeList.get(0));
        }
        return this.createInjectionTarget();
    }

    public InjectionTargetType<PersistenceUnitRefType<T>> createInjectionTarget() {
        return new InjectionTargetTypeImpl<PersistenceUnitRefType<T>>(this, "injection-target", this.childNode);
    }

    public List<InjectionTargetType<PersistenceUnitRefType<T>>> getAllInjectionTarget() {
        ArrayList<InjectionTargetType<PersistenceUnitRefType<T>>> list = new ArrayList<InjectionTargetType<PersistenceUnitRefType<T>>>();
        List nodeList = this.childNode.get("injection-target");
        for (Node node : nodeList) {
            InjectionTargetTypeImpl<PersistenceUnitRefTypeImpl> type = new InjectionTargetTypeImpl<PersistenceUnitRefTypeImpl>(this, "injection-target", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    public PersistenceUnitRefType<T> removeAllInjectionTarget() {
        this.childNode.removeChildren("injection-target");
        return this;
    }

    public PersistenceUnitRefType<T> ignoreDependency() {
        this.childNode.getOrCreate("ignore-dependency");
        return this;
    }

    public Boolean isIgnoreDependency() {
        return this.childNode.getSingle("ignore-dependency") != null;
    }

    public PersistenceUnitRefType<T> removeIgnoreDependency() {
        this.childNode.removeChild("ignore-dependency");
        return this;
    }

    public PersistenceUnitRefType<T> description(String ... values) {
        if (values != null) {
            for (String name : values) {
                this.childNode.createChild("description").text(name);
            }
        }
        return this;
    }

    public List<String> getAllDescription() {
        ArrayList<String> result = new ArrayList<String>();
        List nodes = this.childNode.get("description");
        for (Node node : nodes) {
            result.add(node.getText());
        }
        return result;
    }

    public PersistenceUnitRefType<T> removeAllDescription() {
        this.childNode.removeChildren("description");
        return this;
    }

    public PersistenceUnitRefType<T> persistenceUnitRefName(String persistenceUnitRefName) {
        this.childNode.getOrCreate("persistence-unit-ref-name").text(persistenceUnitRefName);
        return this;
    }

    public String getPersistenceUnitRefName() {
        return this.childNode.getTextValueForPatternName("persistence-unit-ref-name");
    }

    public PersistenceUnitRefType<T> removePersistenceUnitRefName() {
        this.childNode.removeChildren("persistence-unit-ref-name");
        return this;
    }

    public PersistenceUnitRefType<T> persistenceUnitName(String persistenceUnitName) {
        this.childNode.getOrCreate("persistence-unit-name").text(persistenceUnitName);
        return this;
    }

    public String getPersistenceUnitName() {
        return this.childNode.getTextValueForPatternName("persistence-unit-name");
    }

    public PersistenceUnitRefType<T> removePersistenceUnitName() {
        this.childNode.removeChildren("persistence-unit-name");
        return this;
    }

    public PersistenceUnitRefType<T> id(String id) {
        this.childNode.attribute("id", id);
        return this;
    }

    public String getId() {
        return this.childNode.getAttribute("id");
    }

    public PersistenceUnitRefType<T> removeId() {
        this.childNode.removeAttribute("id");
        return this;
    }
}

