/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.nocontentexception;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.NoContentException;
import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 3227433857540172402L;
    private static final String MESSAGE = "Any NoContentException message";

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorStringTest() throws JAXRSCommonClient.Fault {
        NoContentException e = new NoContentException(MESSAGE);
        JAXRSClientIT.assertMessage(MESSAGE, (Exception)e);
    }

    @Test
    public void constructorNullStringTest() throws JAXRSCommonClient.Fault {
        NoContentException e = new NoContentException((String)null);
        JAXRSClientIT.assertNullMessage((Exception)e);
    }

    @Test
    public void constructorStringThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            NoContentException e = new NoContentException(MESSAGE, t);
            JAXRSClientIT.assertMessage(MESSAGE, (Exception)e);
            JAXRSClientIT.assertCause(e, t);
            e = new NoContentException(null, t);
            JAXRSClientIT.assertNullMessage((Exception)e);
            JAXRSClientIT.assertCause(e, t);
        }
    }

    @Test
    public void constructorThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            NoContentException e = new NoContentException(t);
            JAXRSClientIT.assertCause(e, t);
        }
    }

    private static void assertMessage(String message, Exception exception) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertEquals(message, exception.getMessage(), "Unexpected message in exception", exception.getMessage(), "expected was", message);
        JAXRSClientIT.logMsg("The exception contains expected", "#getMessage()");
    }

    private static void assertNullMessage(Exception exception) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNull(exception.getMessage(), "Unexpected message in exception", exception.getMessage(), "expected was null");
        JAXRSClientIT.logMsg("The exception contains expected", "#getMessage()");
    }

    private static void assertCause(NoContentException e, Throwable expected) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertEquals(e.getCause(), expected, "#getCause does not contain expected", expected, "but", e.getCause());
        JAXRSClientIT.logMsg("getCause contains expected", expected);
    }
}

