/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.get;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.get.HttpMethodGetTest;
import ee.jakarta.tck.ws.rs.ee.rs.get.RecursiveLocator;
import ee.jakarta.tck.ws.rs.ee.rs.get.SubResource;
import ee.jakarta.tck.ws.rs.ee.rs.get.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_get_web/GetTest");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/get/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_get_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, HttpMethodGetTest.class, RecursiveLocator.class, SubResource.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void getTest1() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "CTS-get text/plain");
        this.invoke();
    }

    @Test
    public void getTest2() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_HTML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "CTS-get text/html");
        this.invoke();
    }

    @Test
    public void getSubTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "sub"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "CTS-get text/plain");
        this.invoke();
    }

    @Test
    public void headTest1() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("HEAD", ""));
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, "CTS-HEAD: text-plain");
        this.invoke();
    }

    @Test
    public void headTest2() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_HTML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("HEAD", ""));
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, "CTS-HEAD: text-html");
        this.invoke();
    }

    @Test
    public void headSubTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("HEAD", "sub"));
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, "CTS-HEAD: sub-text-plain");
        this.invoke();
    }

    @Test
    public void optionSubTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_HTML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("OPTIONS", "sub"));
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, "ALLOW:GET,OPTIONS,HEAD");
        this.invoke();
    }

    @Test
    public void dynamicGetTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "123"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "JAXRS:DIRECT");
        this.invoke();
    }

    @Test
    public void recursiveResourceLocatorTest() throws JAXRSCommonClient.Fault {
        StringBuilder sb = new StringBuilder();
        sb.append("recursive");
        for (int i = 0; i != 10; ++i) {
            sb.append("/lvl");
        }
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", sb.toString()));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "10");
        this.invoke();
    }
}

