/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.resource.java2entity;

import ee.jakarta.tck.ws.rs.common.AbstractMessageBodyRW;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.ee.resource.java2entity.CollectionWriter;
import ee.jakarta.tck.ws.rs.ee.resource.java2entity.IncorrectCollectionWriter;
import ee.jakarta.tck.ws.rs.ee.resource.java2entity.Resource;
import ee.jakarta.tck.ws.rs.ee.resource.java2entity.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_resource_java2entity_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/resource/java2entity/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_resource_java2entity_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, AbstractMessageBodyRW.class, Resource.class, CollectionWriter.class, IncorrectCollectionWriter.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void directClassTypeTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "linkedlist"));
        this.setProperty("SEARCH_STRING", Response.Status.OK.name());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "ERROR ");
        this.invoke();
    }

    @Test
    public void responseDirectClassTypeTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "response/linkedlist"));
        this.setProperty("SEARCH_STRING", Response.Status.OK.name());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "ERROR ");
        this.invoke();
    }

    @Test
    public void responseGenericEntityTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "response/genericentity/linkedlist"));
        this.setProperty("SEARCH_STRING", Response.Status.OK.name());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "ERROR ");
        this.invoke();
    }

    @Test
    public void genericEntityTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "genericentity/linkedlist"));
        this.setProperty("SEARCH_STRING", Response.Status.OK.name());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "ERROR ");
        this.invoke();
    }
}

