/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.ListViewSkin;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import org.eclipse.fx.ui.controls.styledtext.StyleRange;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.StyledTextLayoutContainer;
import org.eclipse.fx.ui.controls.styledtext.StyledTextNode;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.fx.ui.controls.styledtext.behavior.StyledTextBehavior;
import org.eclipse.jdt.annotation.NonNull;

public class StyledTextSkin
extends BehaviorSkinBase<StyledTextArea, StyledTextBehavior> {
    ListView<Line> contentView;
    LineRuler lineRuler;
    ObservableList<Line> lineList = FXCollections.observableArrayList();
    Map<LineCell, LineInfo> lineInfoMap = new HashMap<LineCell, LineInfo>();
    HBox rootContainer = new HBox();
    private StyledTextLayoutContainer currentActiveNode;

    public StyledTextSkin(StyledTextArea styledText) {
        super((Control)styledText, (BehaviorBase)new StyledTextBehavior(styledText));
        this.rootContainer.setSpacing(0.0);
        this.lineRuler = new LineRuler();
        this.lineRuler.visibleProperty().bind((ObservableValue)((StyledTextArea)this.getSkinnable()).lineRulerVisibleProperty());
        this.lineRuler.managedProperty().bind((ObservableValue)((StyledTextArea)this.getSkinnable()).lineRulerVisibleProperty());
        this.rootContainer.getChildren().add((Object)this.lineRuler);
        this.contentView = new ListView<Line>(){

            protected Skin<?> createDefaultSkin() {
                return new MyListViewSkin(this);
            }
        };
        this.contentView.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    ((StyledTextArea)StyledTextSkin.this.getSkinnable()).requestFocus();
                }
            }
        });
        this.contentView.setCellFactory((Callback)new Callback<ListView<Line>, ListCell<Line>>(){

            public ListCell<Line> call(ListView<Line> arg0) {
                return new LineCell();
            }
        });
        this.contentView.setMinHeight(0.0);
        this.contentView.setMinWidth(0.0);
        this.contentView.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ((StyledTextBehavior)StyledTextSkin.this.getBehavior()).updateCursor(event, StyledTextSkin.this.getCurrentVisibleCells(), event.isShiftDown());
                event.consume();
            }
        });
        this.contentView.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ((StyledTextBehavior)StyledTextSkin.this.getBehavior()).updateCursor(event, StyledTextSkin.this.getCurrentVisibleCells(), true);
                event.consume();
            }
        });
        this.recalculateItems();
        this.contentView.setItems(this.lineList);
        HBox.setHgrow(this.contentView, (Priority)Priority.ALWAYS);
        this.rootContainer.getChildren().addAll((Object[])new Node[]{this.contentView});
        this.getChildren().addAll((Object[])new Node[]{this.rootContainer});
        styledText.caretOffsetProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                int lineIndex = ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getContent().getLineAtOffset(newValue.intValue());
                Line lineObject = (Line)StyledTextSkin.this.lineList.get(lineIndex);
                StyledTextSkin.this.getFlow().show(lineIndex);
                for (LineCell c : StyledTextSkin.this.getCurrentVisibleCells()) {
                    if (c.domainElement != lineObject) continue;
                    if (StyledTextSkin.this.contentView.getSelectionModel().getSelectedItem() != c.domainElement) {
                        StyledTextSkin.this.contentView.getSelectionModel().select((Object)lineObject);
                    }
                    StyledTextLayoutContainer p = (StyledTextLayoutContainer)c.getGraphic();
                    p.setCaretIndex(newValue.intValue() - p.getStartOffset());
                    p.requestLayout();
                    StyledTextSkin.this.updateCurrentCursorNode(p);
                    return;
                }
            }
        });
        styledText.selectionProperty().addListener((ChangeListener)new ChangeListener<TextSelection>(){

            public void changed(ObservableValue<? extends TextSelection> observable, TextSelection oldValue, TextSelection newValue) {
                if (newValue == null || newValue.length == 0) {
                    for (LineCell c : StyledTextSkin.this.getCurrentVisibleCells()) {
                        if (c.getGraphic() == null) continue;
                        StyledTextLayoutContainer block = (StyledTextLayoutContainer)c.getGraphic();
                        block.setSelection(new TextSelection(0, 0));
                    }
                } else {
                    TextSelection selection = newValue;
                    for (LineCell c : StyledTextSkin.this.getCurrentVisibleCells()) {
                        if (c.getGraphic() == null) continue;
                        Line arg0 = c.domainElement;
                        StyledTextLayoutContainer block = (StyledTextLayoutContainer)c.getGraphic();
                        if (selection.length > 0 && block.intersectOffset(selection.offset, selection.offset + selection.length)) {
                            int start = Math.max(0, selection.offset - arg0.getLineOffset());
                            if (arg0.getLineOffset() + arg0.getLineLength() > selection.offset + selection.length) {
                                block.setSelection(new TextSelection(start, selection.offset + selection.length - arg0.getLineOffset() - start));
                                continue;
                            }
                            block.setSelection(new TextSelection(start, arg0.getLineLength() - start));
                            continue;
                        }
                        block.setSelection(new TextSelection(0, 0));
                    }
                }
            }
        });
    }

    void updateCurrentCursorNode(StyledTextLayoutContainer node) {
        if (this.currentActiveNode != node) {
            if (this.currentActiveNode != null) {
                this.currentActiveNode.setCaretIndex(-1);
            }
            this.currentActiveNode = node;
        }
    }

    public void refreshLineRuler() {
        this.lineRuler.refresh();
    }

    MyVirtualFlow getFlow() {
        if (this.contentView == null || this.contentView.getSkin() == null) {
            return null;
        }
        return ((MyListViewSkin)this.contentView.getSkin()).getFlow();
    }

    public double getLineHeight(int caretPosition) {
        int lineIndex = ((StyledTextArea)this.getSkinnable()).getContent().getLineAtOffset(caretPosition);
        Line lineObject = (Line)this.lineList.get(lineIndex);
        for (LineCell c : this.getCurrentVisibleCells()) {
            if (c.domainElement != lineObject) continue;
            return c.getHeight();
        }
        return 0.0;
    }

    public Point2D getCaretLocation(int caretPosition) {
        if (caretPosition < 0) {
            return null;
        }
        int lineIndex = ((StyledTextArea)this.getSkinnable()).getContent().getLineAtOffset(caretPosition);
        Line lineObject = (Line)this.lineList.get(lineIndex);
        for (LineCell c : this.getCurrentVisibleCells()) {
            if (c.domainElement != lineObject) continue;
            StyledTextLayoutContainer b = (StyledTextLayoutContainer)c.getGraphic();
            Point2D careLocation = b.getCareLocation(caretPosition - b.getStartOffset());
            Point2D tmp = ((StyledTextArea)this.getSkinnable()).sceneToLocal(b.localToScene(careLocation));
            return new Point2D(tmp.getX(), ((StyledTextArea)this.getSkinnable()).sceneToLocal(b.localToScene(0.0, b.getHeight())).getY());
        }
        return null;
    }

    protected double computeMinHeight(double width) {
        return this.contentView.minHeight(width);
    }

    protected double computeMinWidth(double height) {
        return this.contentView.minWidth(height);
    }

    public void recalculateItems() {
        if (this.lineList.size() != ((StyledTextArea)this.getSkinnable()).getContent().getLineCount()) {
            if (this.lineList.size() > ((StyledTextArea)this.getSkinnable()).getContent().getLineCount()) {
                this.lineList.remove(((StyledTextArea)this.getSkinnable()).getContent().getLineCount(), this.lineList.size());
            } else {
                ArrayList<Line> tmp = new ArrayList<Line>(((StyledTextArea)this.getSkinnable()).getContent().getLineCount() - this.lineList.size());
                int i = this.lineList.size();
                while (i < ((StyledTextArea)this.getSkinnable()).getContent().getLineCount()) {
                    tmp.add(new Line());
                    ++i;
                }
                this.lineList.addAll(tmp);
            }
        }
        this.redraw();
    }

    public void redraw() {
        for (LineCell l : this.getCurrentVisibleCells()) {
            if (l == null) continue;
            l.update();
        }
    }

    List<LineCell> getCurrentVisibleCells() {
        if (this.contentView == null || this.contentView.getSkin() == null) {
            return Collections.emptyList();
        }
        return ((MyListViewSkin)this.contentView.getSkin()).getFlow().getCells();
    }

    static String removeLineending(String s) {
        return s.replace("\n", "").replace("\r", "");
    }

    public class Line
    implements StyledTextArea.StyledTextLine {
        @Override
        public String getText() {
            return StyledTextSkin.removeLineending(((StyledTextArea)StyledTextSkin.this.getSkinnable()).getContent().getLine(StyledTextSkin.this.lineList.indexOf((Object)this)));
        }

        @Override
        public int getLineIndex() {
            return StyledTextSkin.this.lineList.indexOf((Object)this);
        }

        public int getLineOffset() {
            int idx = StyledTextSkin.this.lineList.indexOf((Object)this);
            return ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getContent().getOffsetAtLine(idx);
        }

        public int getLineLength() {
            int idx = StyledTextSkin.this.lineList.indexOf((Object)this);
            String s = ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getContent().getLine(idx);
            return s.length();
        }

        public List<Segment> getSegments() {
            int idx = StyledTextSkin.this.lineList.indexOf((Object)this);
            ArrayList<Segment> segments = new ArrayList<Segment>();
            String line = ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getContent().getLine(idx);
            if (line != null) {
                int start = ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getContent().getOffsetAtLine(idx);
                int length = line.length();
                StyleRange[] ranges = ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getStyleRanges(start, length, true);
                if (ranges == null) {
                    return Collections.emptyList();
                }
                if (ranges.length == 0 && line.length() > 0) {
                    StyleRange styleRange = new StyleRange(null);
                    styleRange.start = start;
                    styleRange.length = line.length();
                    Segment seg = new Segment();
                    seg.text = StyledTextSkin.removeLineending(line.substring(0, line.length()));
                    seg.style = styleRange;
                    segments.add(seg);
                } else {
                    StyleRange styleRange;
                    int lastIndex = -1;
                    if (ranges.length > 0 && ranges[0].start - start > 0) {
                        styleRange = new StyleRange(null);
                        styleRange.start = start;
                        styleRange.length = ranges[0].start - start;
                        Segment seg = new Segment();
                        seg.text = StyledTextSkin.removeLineending(line.substring(0, ranges[0].start - start));
                        seg.style = styleRange;
                        segments.add(seg);
                    }
                    StyleRange[] styleRangeArray = ranges;
                    int n = ranges.length;
                    int seg = 0;
                    while (seg < n) {
                        StyleRange r = styleRangeArray[seg];
                        int begin = r.start - start;
                        int end = r.start - start + r.length;
                        if (lastIndex != -1 && lastIndex != begin) {
                            StyleRange styleRange2 = new StyleRange(null);
                            styleRange2.start = start + lastIndex;
                            styleRange2.length = begin - lastIndex;
                            Segment seg2 = new Segment();
                            seg2.text = StyledTextSkin.removeLineending(line.substring(lastIndex, begin));
                            seg2.style = styleRange2;
                            segments.add(seg2);
                        }
                        Segment seg3 = new Segment();
                        seg3.text = StyledTextSkin.removeLineending(line.substring(begin, end));
                        seg3.style = r;
                        segments.add(seg3);
                        lastIndex = end;
                        ++seg;
                    }
                    if (lastIndex > 0 && lastIndex < line.length()) {
                        styleRange = new StyleRange(null);
                        styleRange.start = start + lastIndex;
                        styleRange.length = line.length() - lastIndex;
                        Segment seg4 = new Segment();
                        seg4.text = StyledTextSkin.removeLineending(line.substring(lastIndex, line.length()));
                        seg4.style = styleRange;
                        segments.add(seg4);
                    }
                }
            }
            return segments;
        }
    }

    public class LineCell
    extends ListCell<Line> {
        Line domainElement;
        List<Segment> currentSegments;

        public LineCell() {
            this.getStyleClass().add((Object)"styled-text-line");
        }

        public Line getDomainElement() {
            return this.domainElement;
        }

        public void update() {
            if (this.domainElement != null) {
                this.updateItem(this.domainElement, false);
            }
        }

        public void updateCaret() {
            int caretPosition = ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getCaretOffset();
            if (caretPosition < 0) {
                return;
            }
        }

        protected void updateItem(Line arg0, boolean arg1) {
            if (arg0 != null && !arg1) {
                this.domainElement = arg0;
                LineInfo lineInfo = StyledTextSkin.this.lineInfoMap.get((Object)this);
                if (lineInfo == null) {
                    lineInfo = new LineInfo();
                    lineInfo.setDomainElement(this.domainElement);
                    StyledTextSkin.this.lineInfoMap.put(this, lineInfo);
                    StyledTextSkin.this.lineRuler.getChildren().add((Object)lineInfo);
                    StyledTextSkin.this.lineRuler.requestLayout();
                } else {
                    lineInfo.setDomainElement(this.domainElement);
                    StyledTextSkin.this.lineRuler.requestLayout();
                }
                lineInfo.setLayoutY(this.getLayoutY());
                StyledTextLayoutContainer block = (StyledTextLayoutContainer)this.getGraphic();
                if (block == null) {
                    block = new StyledTextLayoutContainer();
                    block.getStyleClass().add((Object)"source-segment-container");
                    this.setGraphic((Node)block);
                }
                block.setStartOffset(arg0.getLineOffset());
                List<Segment> segments = arg0.getSegments();
                if (segments.equals(this.currentSegments)) {
                    return;
                }
                this.currentSegments = segments;
                ArrayList<@NonNull StyledTextNode> texts = new ArrayList<StyledTextNode>();
                for (Segment seg : this.currentSegments) {
                    StyledTextNode t = new StyledTextNode(seg.text);
                    if (seg.style.stylename != null) {
                        t.getStyleClass().setAll((Object[])new String[]{"source-segment", seg.style.stylename});
                    } else if (seg.style.foreground != null) {
                        t.getStyleClass().setAll((Object[])new String[]{"plain-source-segment"});
                    } else {
                        t.getStyleClass().setAll((Object[])new String[]{"source-segment"});
                    }
                    texts.add(t);
                }
                if (segments.isEmpty()) {
                    StyledTextNode t = new StyledTextNode("");
                    t.getStyleClass().setAll((Object[])new String[]{"source-segment"});
                    block.getTextNodes().setAll((Object[])new StyledTextNode[]{t});
                } else {
                    block.getTextNodes().setAll(texts);
                }
                TextSelection selection = ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getSelection();
                if (selection.length > 0 && block.intersectOffset(selection.offset, selection.offset + selection.length)) {
                    int start = Math.max(0, selection.offset - arg0.getLineOffset());
                    if (arg0.getLineOffset() + arg0.getLineLength() > selection.offset + selection.length) {
                        block.setSelection(new TextSelection(start, selection.offset + selection.length - arg0.getLineOffset() - start));
                    } else {
                        block.setSelection(new TextSelection(start, arg0.getLineLength() - start));
                    }
                } else {
                    block.setSelection(new TextSelection(0, 0));
                }
                if (arg0.getLineOffset() <= ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getCaretOffset() && arg0.getLineOffset() + arg0.getText().length() >= ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getCaretOffset()) {
                    block.setCaretIndex(((StyledTextArea)StyledTextSkin.this.getSkinnable()).getCaretOffset() - arg0.getLineOffset());
                    StyledTextSkin.this.updateCurrentCursorNode(block);
                } else {
                    block.setCaretIndex(-1);
                }
            } else {
                this.setGraphic(null);
                this.domainElement = null;
                this.currentSegments = null;
                LineInfo lineInfo = StyledTextSkin.this.lineInfoMap.remove((Object)this);
                if (lineInfo != null) {
                    lineInfo.setDomainElement(null);
                }
            }
            super.updateItem((Object)arg0, arg1);
        }
    }

    class LineInfo
    extends HBox {
        private Label markerLabel = new Label();
        private Label lineText;
        Line line;

        public LineInfo() {
            this.markerLabel.setPrefWidth(20.0);
            this.lineText = new Label();
            this.lineText.getStyleClass().add((Object)"line-ruler-text");
            this.lineText.setMaxWidth(Double.MAX_VALUE);
            this.lineText.setMaxHeight(Double.MAX_VALUE);
            this.lineText.setAlignment(Pos.CENTER_RIGHT);
            HBox.setHgrow((Node)this.lineText, (Priority)Priority.ALWAYS);
            this.getChildren().addAll((Object[])new Node[]{this.markerLabel, this.lineText});
        }

        public void setDomainElement(Line line) {
            if (line == null) {
                this.line = null;
                this.setManaged(false);
                StyledTextSkin.this.rootContainer.requestLayout();
            } else if (line != this.line) {
                this.line = line;
                this.calculateContent();
            }
        }

        public void calculateContent() {
            Line line = this.line;
            if (line != null) {
                this.setManaged(true);
                String newText = String.valueOf(this.line.getLineIndex() + 1);
                String oldText = this.lineText.getText();
                if (oldText == null) {
                    oldText = "";
                }
                this.lineText.setText(newText);
                this.markerLabel.setGraphic((Node)((StyledTextArea)StyledTextSkin.this.getSkinnable()).getLineRulerGraphicNodeFactory().call((Object)line));
                if (newText.length() != oldText.length()) {
                    StyledTextSkin.this.rootContainer.requestLayout();
                }
                StyledTextSkin.this.lineRuler.layout();
            }
        }
    }

    class LineRuler
    extends Pane {
        boolean skipRelayout;

        LineRuler() {
        }

        protected void layoutChildren() {
            if (this.skipRelayout) {
                return;
            }
            super.layoutChildren();
            HashSet children = new HashSet(this.getChildren());
            ArrayList<LineInfo> layouted = new ArrayList<LineInfo>();
            double maxWidth = 0.0;
            for (LineCell c : ((MyListViewSkin)StyledTextSkin.this.contentView.getSkin()).getFlow().getCells()) {
                LineInfo lineInfo;
                if (!c.isVisible() || (lineInfo = StyledTextSkin.this.lineInfoMap.get((Object)c)) == null) continue;
                layouted.add(lineInfo);
                maxWidth = Math.max(maxWidth, lineInfo.getWidth());
                lineInfo.relocate(0.0, c.getLayoutY());
                lineInfo.resize(lineInfo.getWidth(), c.getHeight());
                lineInfo.setVisible(true);
                children.remove((Object)lineInfo);
            }
            for (LineInfo l : layouted) {
                l.resize(maxWidth, l.getHeight());
            }
            ArrayList<LineInfo> toRemove = new ArrayList<LineInfo>();
            for (Node n : children) {
                if (n instanceof LineInfo) {
                    LineInfo l = (LineInfo)n;
                    if (l.line == null) {
                        toRemove.add(l);
                    }
                }
                n.setVisible(false);
            }
            this.getChildren().removeAll(toRemove);
        }

        public void refresh() {
            this.getChildren().filtered(n -> n instanceof LineInfo).forEach(n -> ((LineInfo)((Object)n)).calculateContent());
        }
    }

    class MyListViewSkin
    extends ListViewSkin<Line> {
        private MyVirtualFlow flow;

        public MyListViewSkin(ListView<Line> listView) {
            super(listView);
        }

        public MyVirtualFlow getFlow() {
            return this.flow;
        }

        protected VirtualFlow<ListCell<Line>> createVirtualFlow() {
            this.flow = new MyVirtualFlow();
            return this.flow;
        }
    }

    class MyVirtualFlow
    extends VirtualFlow<LineCell> {
        protected void positionCell(LineCell cell, double position) {
            super.positionCell((IndexedCell)cell, position);
            LineInfo lineInfo = StyledTextSkin.this.lineInfoMap.get((Object)cell);
            if (lineInfo != null) {
                lineInfo.setDomainElement(cell.domainElement);
                lineInfo.setLayoutY(cell.getLayoutY());
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((MyVirtualFlow)MyVirtualFlow.this).StyledTextSkin.this.lineRuler.requestLayout();
                }
            });
        }

        public List<LineCell> getCells() {
            return super.getCells();
        }

        public void rebuildCells() {
            StyledTextSkin.this.lineRuler.skipRelayout = true;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((MyVirtualFlow)MyVirtualFlow.this).StyledTextSkin.this.lineRuler.skipRelayout = false;
                    ((MyVirtualFlow)MyVirtualFlow.this).StyledTextSkin.this.lineRuler.requestLayout();
                }
            });
            super.rebuildCells();
        }
    }

    static class RegionImpl
    extends Region {
        public RegionImpl(Node ... nodes) {
            this.getChildren().addAll((Object[])nodes);
        }

        public ObservableList<Node> getChildren() {
            return super.getChildren();
        }
    }

    class Segment {
        public String text;
        public StyleRange style;

        Segment() {
        }

        public String toString() {
            return String.valueOf(this.text) + " => " + this.style;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Segment other = (Segment)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.style == null ? other.style != null : !this.style.equals(other.style)) {
                return false;
            }
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }

        private StyledTextSkin getOuterType() {
            return StyledTextSkin.this;
        }
    }
}

