/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.action.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egf.core.ui.workbench.Messages;
import org.eclipse.egf.core.ui.workbench.action.navigator.AbstractNavigatorAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractActionProvider
extends CommonActionProvider {
    private static final String GROUP_DELETE = "group.delete";
    private static final String GROUP_NEW_SUB_MENU_ID = "group.new.subMenu";
    private List<IAction> _newActions = new ArrayList<IAction>(0);
    private List<IAction> _openActions = new ArrayList<IAction>(0);
    private List<IAction> _editActions = new ArrayList<IAction>(0);
    private List<IAction> _deleteActions = new ArrayList<IAction>(0);
    private List<IAction> _additionActions = new ArrayList<IAction>(0);

    public void init(ICommonActionExtensionSite site_p) {
        super.init(site_p);
        ICommonViewerSite commonViewerSite = site_p.getViewSite();
        if (commonViewerSite instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite workbenchSite = (ICommonViewerWorkbenchSite)commonViewerSite;
            IWorkbenchPage page = workbenchSite.getPage();
            ISelectionProvider selectionProvider = workbenchSite.getSelectionProvider();
            Shell shell = workbenchSite.getShell();
            this.initActions(shell, page, selectionProvider);
        }
    }

    protected abstract void initActions(Shell var1, IWorkbenchPage var2, ISelectionProvider var3);

    public void fillActionBars(IActionBars actionBars_p) {
        this.fillActionsBars(actionBars_p, this._newActions);
        this.fillActionsBars(actionBars_p, this._openActions);
        this.fillActionsBars(actionBars_p, this._editActions);
        this.fillActionsBars(actionBars_p, this._deleteActions);
        this.fillActionsBars(actionBars_p, this._additionActions);
    }

    protected void fillActionsBars(IActionBars actionBars_p, List<IAction> actions_p) {
        for (IAction action : actions_p) {
            boolean isSelectionCompatible = true;
            if (action instanceof AbstractNavigatorAction) {
                isSelectionCompatible = ((AbstractNavigatorAction)action).isSelectionCompatible();
            }
            if (!isSelectionCompatible || !action.isEnabled()) continue;
            actionBars_p.setGlobalActionHandler(action.getId(), action);
        }
    }

    public void fillContextMenu(IMenuManager menu_p) {
        IMenuManager subMenu = this.createNewSubMenuManager();
        menu_p.insertAfter("group.new", (IContributionItem)subMenu);
        this.fillContextMenu(menu_p, this._editActions, "group.edit");
        this.fillContextMenu(menu_p, this._openActions, "group.open");
        this.fillContextMenu(menu_p, this._deleteActions, GROUP_DELETE);
        this.fillContextMenu(menu_p, this._additionActions, "additions");
    }

    protected IMenuManager createNewSubMenuManager() {
        MenuManager subMenuManager = new MenuManager(Messages.ExplorerActionProvider_NewMenuItem_Title, GROUP_NEW_SUB_MENU_ID);
        this.fillContextMenu((IMenuManager)subMenuManager, this._newActions, null);
        return subMenuManager;
    }

    protected void fillContextMenu(IMenuManager menu_p, List<IAction> actions_p, String groupId_p) {
        for (IAction action : actions_p) {
            boolean isSelectionCompatible = true;
            if (action instanceof AbstractNavigatorAction) {
                isSelectionCompatible = ((AbstractNavigatorAction)action).isSelectionCompatible();
            }
            if (!isSelectionCompatible) continue;
            ActionContributionItem item = new ActionContributionItem(action){

                public boolean isDirty() {
                    return true;
                }

                public boolean isDynamic() {
                    return true;
                }
            };
            if (groupId_p != null) {
                menu_p.appendToGroup(groupId_p, (IContributionItem)item);
                continue;
            }
            menu_p.add((IContributionItem)item);
        }
    }

    protected List<IAction> getNewActions() {
        return this._newActions;
    }

    protected List<IAction> getOpenActions() {
        return this._openActions;
    }

    protected List<IAction> getEditActions() {
        return this._editActions;
    }

    protected List<IAction> getDeleteActions() {
        return this._deleteActions;
    }

    protected List<IAction> getAdditionActions() {
        return this._additionActions;
    }
}

