/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.edit.command.plugin.mapping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.model.MappingModel;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.model.edit.command.plugin.PluginChangeWrapperCommand;
import org.eclipse.egf.model.edit.helper.FactoryComponentHelper;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.mapping.MappingPackage;
import org.eclipse.emf.mapping.ecore2ecore.Ecore2EcoreFactory;
import org.eclipse.emf.mapping.ecore2ecore.Ecore2EcoreMappingRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingWrapperCommand
extends PluginChangeWrapperCommand {
    private static final Logger __logger = Logger.getLogger((String)AbstractMappingWrapperCommand.class.getPackage().getName());

    public AbstractMappingWrapperCommand(EditingDomain domain_p, EObject modelElement_p, EStructuralFeature feature_p, Object value_p) {
        super(domain_p, modelElement_p, feature_p, value_p);
    }

    @Override
    protected List<IPluginChangesCommand> getExecutablePluginChangeCommand() {
        MappingModel mapping = this.getMapping();
        String mappingPath = mapping.getPath();
        IProject project = ModelHelper.getProject((NamedModelElementWithId)this.getModelElement());
        String mappingFileFullPath = this.getMappingPath(mappingPath, project);
        this.handleMappingFile(mappingFileFullPath);
        ProjectHelper.refreshProject((IProject)project, (int)2, (IProgressMonitor)new NullProgressMonitor());
        return new ArrayList<IPluginChangesCommand>(0);
    }

    protected abstract void handleMappingFile(String var1);

    protected String getMappingPath(String mappingFilePath_p, IProject project_p) {
        StringBuilder fullPathBuilder = new StringBuilder(project_p.getFullPath().toString());
        fullPathBuilder.append('/').append(mappingFilePath_p);
        return fullPathBuilder.toString();
    }

    protected void initializeInputOrOutput(Ecore2EcoreMappingRoot mappingRoot_p, String resourcePath_p, EReference containerReference_p, ResourceSet resourceSet_p) {
        Resource resource = this.getResource(resourcePath_p, resourceSet_p);
        if (resource != null) {
            List references = (List)mappingRoot_p.eGet((EStructuralFeature)containerReference_p);
            references.addAll(resource.getContents());
        } else {
            StringBuilder loggerMessage = new StringBuilder("AbstractMappingWrapperCommand.initializeInputOrOutput(..) _ ");
            loggerMessage.append("Domain resource for factory component id#").append(resourcePath_p).append("used as mapping").append(containerReference_p.getName()).append(" not found!!!");
            __logger.error((Object)loggerMessage.toString());
        }
    }

    private Resource getResource(String fcId_p, ResourceSet resourceSet_p) {
        Resource result = null;
        URI domainURI = FactoryComponentHelper.getDomainURI(fcId_p);
        if (domainURI != null) {
            result = resourceSet_p.getResource(domainURI, true);
        }
        return result;
    }

    protected void createMappingFile(String mappingFileFullPath_p) {
        Ecore2EcoreMappingRoot mappingRoot = Ecore2EcoreFactory.eINSTANCE.createEcore2EcoreMappingRoot();
        mappingRoot.setTopToBottom(true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        MappingModel mappingModelElement = this.getMapping();
        this.initializeInputOrOutput(mappingRoot, mappingModelElement.getSource(), MappingPackage.Literals.MAPPING__INPUTS, (ResourceSet)resourceSet);
        this.initializeInputOrOutput(mappingRoot, mappingModelElement.getTarget(), MappingPackage.Literals.MAPPING__OUTPUTS, (ResourceSet)resourceSet);
        URI mappingFileFullURI = FileHelper.getFileFullUri((String)mappingFileFullPath_p);
        Resource mappingFileResource = resourceSet.createResource(mappingFileFullURI);
        mappingFileResource.getContents().add((Object)mappingRoot);
        try {
            mappingFileResource.save(null);
        }
        catch (IOException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("AddMappingWrapperCommand.handleMappingFile(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
    }

    protected abstract MappingModel getMapping();

    @Override
    protected List<IPluginChangesCommand> getUndoablePluginChangeCommand() {
        return null;
    }
}

