/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.fc.generator.java.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.fc.generator.java.internal.AbstractGenerator;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenResourceKind;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.converter.util.ConverterUtil;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ui.contribution.ModelImporterDescriptor;
import org.eclipse.emf.importer.ui.contribution.ModelImporterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenModelGenerator
extends AbstractGenerator {
    private static final Logger _logger = Logger.getLogger((String)AbstractGenModelGenerator.class.getPackage().getName());
    protected static final String MODEL_FOLDER = "/model/";
    private ModelImporter _modelImporter;
    private IPath _inputPath;
    private String _modelPluginId;
    private String _basePackage;
    private IPath _genModelPath;
    private IPath _genModelContainerPath;
    private String _rootExtendsInterface;
    private String _rootExtendsClass;
    private GenJDKLevel _jdkComplianceLevel;
    private String _modelDirectory;
    private GenResourceKind _resourcetype;
    private String _implementationPackageSuffix;
    private String _interfacePackageSuffix;
    private String _metadataPackageSuffix;
    private String _utilityPackageSuffix;

    protected abstract ModelImporter createModelImporter();

    private String getModelDirectory() {
        return new StringBuilder(47).append(this._modelPluginId).append('/').append(this._modelDirectory).append('/').toString();
    }

    private GenModel createGenModel(Monitor monitor_p) {
        GenModel genModel = null;
        try {
            try {
                ModelImporter modelImporter = this.getModelImporter();
                modelImporter.setModelPluginDirectory(this.getModelDirectory());
                modelImporter.prepareGenModelAndEPackages(monitor_p);
                genModel = modelImporter.getGenModel();
                this.setGenModelParameters(genModel);
                try {
                    modelImporter.saveGenModelAndEPackages(monitor_p);
                }
                catch (Exception exception_p) {
                    StringBuffer loggerMessage = new StringBuffer("AbstractGenModelGenerator.generateGenModelWithImporter(..) _ ");
                    _logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
                    genModel = null;
                }
            }
            catch (Exception exception_p) {
                genModel = null;
                Diagnostic errorDiagnostic = ConverterUtil.createErrorDiagnostic((Throwable)exception_p, (boolean)true);
                if (errorDiagnostic != null) {
                    this.handleDiagnostic(errorDiagnostic, "Error in genmodel creation");
                }
                monitor_p.done();
            }
        }
        finally {
            monitor_p.done();
        }
        return genModel;
    }

    private void handleReferencedPackages(ModelImporter modelImporter_p, Monitor monitor_p) {
        ArrayList<GenModel> externalGenModels = new ArrayList<GenModel>(0);
        this.addExternalGenModels(externalGenModels);
        List packages = modelImporter_p.getEPackages();
        for (EPackage currentPackage : packages) {
            GenPackage externalGenPackage = null;
            Iterator iteratorOverExternalGenModels = externalGenModels.iterator();
            while (iteratorOverExternalGenModels.hasNext() && externalGenPackage == null) {
                GenModel currentExternalGenModel = (GenModel)iteratorOverExternalGenModels.next();
                Iterator externalGenPackages = currentExternalGenModel.getGenPackages().iterator();
                while (externalGenPackages.hasNext() && externalGenPackage == null) {
                    GenPackage currentGenPackage = (GenPackage)externalGenPackages.next();
                    EPackage ecorePackage = currentGenPackage.getEcorePackage();
                    if (currentPackage != ecorePackage && !currentPackage.getNsURI().equals(ecorePackage.getNsURI())) continue;
                    externalGenPackage = currentGenPackage;
                }
            }
            if (externalGenPackage != null) {
                modelImporter_p.getReferencedGenPackages().add(externalGenPackage);
                modelImporter_p.getReferenceGenPackageConvertInfo(externalGenPackage).setValidReference(true);
                continue;
            }
            modelImporter_p.getEPackageConvertInfo(currentPackage).setConvert(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setGenModelParameters(GenModel genModel_p) {
        genModel_p.setRootExtendsInterface(this._rootExtendsInterface);
        genModel_p.setRootExtendsClass(this._rootExtendsClass);
        genModel_p.setComplianceLevel(this._jdkComplianceLevel);
        genModel_p.setModelPluginID(this._modelPluginId);
        genModel_p.setNonNLSMarkers(true);
        genModel_p.setModelDirectory(this.getModelDirectory());
        genPackages = genModel_p.getAllGenPackagesWithClassifiers();
        for (GenPackage genPackage : genPackages) {
            block2: {
                genPackage.setResource(this._resourcetype);
                ePackage = genPackage.getEcorePackage();
                container = ePackage.getESuperPackage();
                suffix = "";
                if (container != null) ** GOTO lbl18
                this.setPackageParameters(genPackage, this._basePackage);
                break block2;
lbl-1000:
                // 1 sources

                {
                    suffix = String.valueOf('.') + container.getName() + suffix;
                    container = container.getESuperPackage();
lbl18:
                    // 2 sources

                    ** while (container != null)
                }
            }
            this.setPackageParameters(genPackage, String.valueOf(this._basePackage) + suffix);
        }
    }

    private void setPackageParameters(GenPackage genPackage_p, String basePackage_p) {
        genPackage_p.setBasePackage(basePackage_p);
        genPackage_p.setClassPackageSuffix(this._implementationPackageSuffix);
        genPackage_p.setInterfacePackageSuffix(this._interfacePackageSuffix);
        genPackage_p.setMetaDataPackageSuffix(this._metadataPackageSuffix);
        genPackage_p.setUtilityPackageSuffix(this._utilityPackageSuffix);
    }

    public GenModel execute(Monitor monitor_p) {
        GenModel genModel = null;
        try {
            ModelImporter modelImporter = this.getModelImporter();
            boolean result = this.adjustAttributes(CodeGenUtil.createMonitor((Monitor)monitor_p, (int)1));
            if (result) {
                this.adjustModelImporter(CodeGenUtil.createMonitor((Monitor)monitor_p, (int)1));
                Diagnostic diagnostic = modelImporter.checkGenModelFileName();
                result = this.handleDiagnostic(diagnostic, "Check genmodel file name failed");
                if (result && (result = this.handleEPackages(CodeGenUtil.createMonitor((Monitor)monitor_p, (int)1)))) {
                    genModel = this.createGenModel(CodeGenUtil.createMonitor((Monitor)monitor_p, (int)1));
                }
            }
        }
        catch (RuntimeException exception_p) {
            StringBuffer loggerMessage = new StringBuffer("AbstractGenModelGenerator.execute(..) _ ");
            _logger.error((Object)loggerMessage.toString(), (Throwable)exception_p);
            genModel = null;
        }
        return genModel;
    }

    protected ModelImporter getModelImporter() {
        if (this._modelImporter == null) {
            this._modelImporter = this.createModelImporter();
        }
        return this._modelImporter;
    }

    protected boolean adjustAttributes(Monitor monitor_p) {
        try {
            monitor_p.beginTask("", 1);
            this._genModelContainerPath = this.getGenModelContainer();
            this._genModelPath = this.getGenModelPath();
        }
        finally {
            monitor_p.done();
        }
        return true;
    }

    protected abstract IPath getGenModelPath();

    protected void adjustModelImporter(Monitor monitor_p) {
        try {
            monitor_p.beginTask("", 1);
            ModelImporter modelImporter = this.getModelImporter();
            ModelImporterDescriptor modelImporterDescriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor(this.getModelImporter().getID());
            modelImporter.getFileExtensions().addAll(modelImporterDescriptor.getExtensions());
            modelImporter.setModelProjectName(this._modelPluginId);
            modelImporter.setModelPluginID(this._modelPluginId);
            this.handleGenModelPath(this._genModelPath);
        }
        finally {
            monitor_p.done();
        }
    }

    private void handleGenModelPath(IPath genModelPath_p) {
        ModelImporter modelImporter = this.getModelImporter();
        modelImporter.setGenModelContainerPath(this._genModelContainerPath);
        modelImporter.setGenModelFileName(genModelPath_p.toString());
    }

    protected IPath getGenModelContainer() {
        IPath relativePath;
        Path result = new Path(this.getModelPluginId());
        File physicalFile = this.getInputPath().toFile();
        result = physicalFile.isDirectory() ? result.append(MODEL_FOLDER) : ((relativePath = this.getInputPath().removeFirstSegments(1).removeLastSegments(1).removeFileExtension()).segmentCount() > 0 ? result.append(relativePath) : result.append(MODEL_FOLDER));
        return result;
    }

    private boolean handleEPackages(Monitor monitor_p) {
        boolean result = true;
        try {
            try {
                ModelImporter modelImporter = this.getModelImporter();
                Diagnostic diagnostic = modelImporter.computeEPackages(monitor_p);
                result = this.handleDiagnostic(diagnostic, "Computes EPackages error");
                if (result) {
                    this.handleReferencedPackages(modelImporter, monitor_p);
                    modelImporter.adjustEPackages(monitor_p);
                }
            }
            catch (Exception exception_p) {
                StringBuffer loggerMessage = new StringBuffer("AbstractGenModelGenerator.handleEPackages(..) _ ");
                _logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
        }
        finally {
            monitor_p.done();
        }
        return result;
    }

    protected void addExternalGenModels(List<GenModel> genModels_p) {
        ModelImporter modelImporter = this.getModelImporter();
        ArrayList externalGenModels = new ArrayList(modelImporter.getExternalGenModels());
        if (!externalGenModels.isEmpty()) {
            boolean hasExporterGenModel;
            GenModel exporterGenModel = modelImporter.getGenModel();
            boolean bl = hasExporterGenModel = exporterGenModel != null && genModels_p.contains(exporterGenModel);
            if (!hasExporterGenModel) {
                genModels_p.add(exporterGenModel);
            }
            for (GenModel genModel : genModels_p) {
                Iterator j = externalGenModels.iterator();
                while (j.hasNext()) {
                    URI externalURI;
                    URI uri;
                    GenModel externalGenModel = (GenModel)j.next();
                    if (genModel == externalGenModel) {
                        j.remove();
                        continue;
                    }
                    URI uRI = uri = genModel.eResource() != null ? genModel.eResource().getURI() : null;
                    if (uri == null) continue;
                    URI uRI2 = externalURI = externalGenModel.eResource() != null ? externalGenModel.eResource().getURI() : null;
                    if (!uri.equals((Object)externalURI)) continue;
                    j.remove();
                }
            }
            genModels_p.addAll(externalGenModels);
            if (!hasExporterGenModel) {
                genModels_p.remove(exporterGenModel);
            }
        }
    }

    public void setPluginId(String pluginId_p) {
        this._modelPluginId = pluginId_p;
    }

    public void setBasePackagePrefix(String basePackage_p) {
        this._basePackage = basePackage_p;
    }

    public void setInputPath(IPath inputPath_p) {
        this._inputPath = inputPath_p;
    }

    protected IPath getInputPath() {
        return this._inputPath;
    }

    protected String getModelPluginId() {
        return this._modelPluginId;
    }

    protected String getRootExtendsInterface() {
        return this._rootExtendsInterface;
    }

    public void clear() {
        this._modelImporter = null;
        this._inputPath = null;
        this._modelPluginId = null;
        this._basePackage = null;
        this._genModelPath = null;
        this._genModelContainerPath = null;
        this._rootExtendsInterface = null;
        this._rootExtendsClass = null;
        this._jdkComplianceLevel = null;
    }

    public void setRootExtendsInterface(String rootExtendsInterface_p) {
        this._rootExtendsInterface = rootExtendsInterface_p;
    }

    public void setRootExtendsClass(String rootExtendsClass_p) {
        this._rootExtendsClass = rootExtendsClass_p;
    }

    public void setJdkComplianceLevel(GenJDKLevel jdkComplianceLevel_p) {
        this._jdkComplianceLevel = jdkComplianceLevel_p;
    }

    public void setModelDirectory(String modelDirectory_p) {
        this._modelDirectory = modelDirectory_p;
    }

    public void setResourceType(GenResourceKind resourceType_p) {
        this._resourcetype = resourceType_p;
    }

    public void setPackagesSuffixes(String implementationPackageSuffix_p, String interfacePackageSuffix_p, String metadataPackageSuffix_p, String utilityPackageSuffix_p) {
        this._implementationPackageSuffix = implementationPackageSuffix_p;
        this._interfacePackageSuffix = interfacePackageSuffix_p;
        this._metadataPackageSuffix = metadataPackageSuffix_p;
        this._utilityPackageSuffix = utilityPackageSuffix_p;
    }
}

