/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editor;

import org.apache.log4j.Logger;
import org.eclipse.egf.common.ui.helper.WorkbenchHelper;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.model.internal.data.ModelElement;
import org.eclipse.egf.pattern.ui.editor.PatternEditor;
import org.eclipse.egf.pattern.ui.editor.PatternEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;

public class PatternEditorHelper {
    private static final Logger __logger = Logger.getLogger((String)PatternEditorHelper.class.getPackage().getName());

    public static IEditorPart isPatternEditorOpen(PatternModel patternModel_p) {
        IEditorPart result = null;
        IEditorInput patternEditorInput = (IEditorInput)((ModelElement)patternModel_p).getAdapter(PatternEditorInput.class);
        if (patternEditorInput == null) {
            return result;
        }
        IEditorReference[] allOpenPatternEditors = WorkbenchHelper.getAllOpenEditors((String)PatternEditor.class.getName());
        int i = 0;
        while (i < allOpenPatternEditors.length && result == null) {
            IEditorReference currentEditor = allOpenPatternEditors[i];
            IEditorInput currentEditorInput = null;
            try {
                currentEditorInput = currentEditor.getEditorInput();
                if (patternEditorInput == currentEditorInput) {
                    result = currentEditor.getEditor(false);
                }
            }
            catch (PartInitException exception_p) {
                StringBuilder loggerMessage = new StringBuilder("PatternEditorHelper.isPatternEditorOpen(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
            ++i;
        }
        return result;
    }

    public static IEditorInput getEditorInput(PatternModel pattern_p, boolean editable_p) {
        ModelElement patternAsModelElement = (ModelElement)pattern_p;
        PatternEditorInput editorInput = (PatternEditorInput)patternAsModelElement.getAdapter(PatternEditorInput.class);
        if (editorInput == null) {
            FactoryComponent fc = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)pattern_p);
            editorInput = new PatternEditorInput(fc.getId(), pattern_p, editable_p);
            patternAsModelElement.setAdapter(PatternEditorInput.class, (Object)editorInput);
        }
        return editorInput;
    }
}

