/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard;

import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.common.ui.helper.MessageFormatHelper;
import org.eclipse.egf.core.ui.EgfUiActivator;
import org.eclipse.egf.core.ui.command.ChangeRecorderWrapperCommand;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.edit.command.plugin.PluginChangeWrapperCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.Wizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelElementWizard
extends Wizard {
    private ChangeRecorder _changeRecorder;
    private EObject _parent;
    private NamedModelElementWithId _modelElement;
    private boolean _isInCreationMode;
    private boolean _isInReadOnly;
    private String _description;
    private ChangeDescription _changeDescription;

    protected AbstractModelElementWizard(EObject parent_p, NamedModelElementWithId modelElement_p, boolean readOnlyMode_p) {
        this._isInReadOnly = readOnlyMode_p;
        this.initialize(parent_p, modelElement_p);
    }

    private void initialize(EObject parent_p, NamedModelElementWithId modelElement_p) {
        if (parent_p == null) {
            throw new IllegalArgumentException("Argument parent_p can not be null");
        }
        this._parent = parent_p;
        this._modelElement = modelElement_p;
        if (!this._isInReadOnly) {
            if (this._modelElement == null) {
                this._modelElement = this.doCreateModelElement();
                this._isInCreationMode = true;
            } else {
                this.startChangesRecording((EObject)this._modelElement);
            }
        }
        this.handleWizardDescription();
        ImageDescriptor wizardDefaultPageImage = this.getWizardDefaultPageImageDescriptor();
        if (wizardDefaultPageImage != null) {
            this.setDefaultPageImageDescriptor(wizardDefaultPageImage);
        }
    }

    protected abstract NamedModelElementWithId doCreateModelElement();

    protected abstract String getCreationDescription();

    protected abstract String getEditDescription();

    protected abstract String getTitle();

    private void handleWizardDescription() {
        this._description = this._isInCreationMode ? this.getCreationDescription() : this.getEditDescription();
    }

    protected void startChangesRecording(EObject modelElement_p) {
        this._changeRecorder = new ChangeRecorder(modelElement_p){

            protected void eliminateEmptyChanges() {
            }
        };
    }

    protected ChangeDescription endChangesRecording() {
        ChangeDescription changeDescription = this._changeRecorder.endRecording();
        this._changeRecorder.dispose();
        return changeDescription;
    }

    public boolean performCancel() {
        if (!this._isInReadOnly) {
            if (this._isInCreationMode) {
                this._modelElement = null;
                this._parent = null;
            } else {
                ChangeDescription changes = this.endChangesRecording();
                if (changes != null) {
                    changes.applyAndReverse();
                }
            }
        }
        return super.performCancel();
    }

    public boolean performFinish() {
        boolean result = true;
        if (this._isInCreationMode) {
            Command command = this.getAddCommandForCreatedElement(this.getEditingDomain(), this._parent, this._modelElement);
            this.executeCommand(command);
        } else {
            this._changeDescription = this.endChangesRecording();
            result = this.handleChangeDescription();
        }
        return result;
    }

    public final boolean canFinish() {
        boolean canFisnish;
        boolean bl = canFisnish = !this._isInReadOnly;
        if (canFisnish) {
            canFisnish = this.handleCanFinish();
        }
        return canFisnish;
    }

    protected boolean handleCanFinish() {
        return super.canFinish();
    }

    protected abstract Command getAddCommandForCreatedElement(AdapterFactoryEditingDomain var1, EObject var2, NamedModelElementWithId var3);

    protected boolean handleChangeDescription() {
        ChangeDescription changes = this.getChangeDescription();
        if (this.containsChanges(changes)) {
            NamedModelElementWithId modifiedObject = this.getModelElement();
            Couple<EStructuralFeature, Object> modifiedFeature = this.getModifiedFeature(changes, (EObject)modifiedObject);
            EStructuralFeature feature = (EStructuralFeature)modifiedFeature.getKey();
            Object value = modifiedFeature.getValue();
            AdapterFactoryEditingDomain editingDomain = this.getEditingDomain();
            ChangeRecorderWrapperCommand command = new ChangeRecorderWrapperCommand(changes, (EditingDomain)editingDomain, (EObject)modifiedObject, feature, value);
            command.setPluginChangeCommand(this.getPluginChangeCommand((EditingDomain)editingDomain, (EObject)modifiedObject, feature, value));
            this.executeCommand((Command)command);
        }
        return true;
    }

    protected boolean containsChanges(ChangeDescription changes_p) {
        boolean result = false;
        if (changes_p != null) {
            EMap objectChanges = changes_p.getObjectChanges();
            result = !objectChanges.isEmpty();
        }
        return result;
    }

    protected Couple<EStructuralFeature, Object> getModifiedFeature(ChangeDescription changes_p, EObject modifiedObject_p) {
        EMap objectChanges = changes_p.getObjectChanges();
        EList objectChangeList = (EList)objectChanges.get((Object)modifiedObject_p);
        FeatureChange featureChange = (FeatureChange)objectChangeList.get(0);
        EStructuralFeature feature = featureChange.getFeature();
        Object value = featureChange.getValue();
        return new Couple((Object)feature, value);
    }

    private void executeCommand(Command command_p) {
        this.getEditingDomain().getCommandStack().execute(command_p);
    }

    private AdapterFactoryEditingDomain getEditingDomain() {
        AdapterFactoryEditingDomain result = this.isInReadOnlyMode() ? EgfUiActivator.getDefault().getEditingDomainInReadOnly() : EgfUiActivator.getDefault().getEditingDomain();
        return result;
    }

    protected abstract PluginChangeWrapperCommand getPluginChangeCommand(EditingDomain var1, EObject var2, EStructuralFeature var3, Object var4);

    public void addPages() {
        Object[] arguments = new String[]{this._isInCreationMode ? Messages.CreationWizard_Prefix : Messages.EditWizard_Prefix, this.getTitle()};
        String titleMessage = MessageFormatHelper.formatMessage((String)Messages.Wizard_Title, (Object[])arguments);
        this.setWindowTitle(titleMessage);
    }

    protected ChangeRecorder getChangeRecorder() {
        return this._changeRecorder;
    }

    public NamedModelElementWithId getModelElement() {
        return this._modelElement;
    }

    public String getDescription() {
        return this._description;
    }

    protected ChangeDescription getChangeDescription() {
        return this._changeDescription;
    }

    public EObject getParent() {
        return this._parent;
    }

    public boolean isInReadOnlyMode() {
        return this._isInReadOnly;
    }

    protected ImageDescriptor getWizardDefaultPageImageDescriptor() {
        return null;
    }
}

